/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.ws;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.nameformatter.BWGenericFormatter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebServicesClientFormatter
extends BWGenericFormatter {
    private static final String C_SoapJmsRequestor = "com.tibco.bw.soap.share.reqrep.SoapJmsRequestor";

    public WebServicesClientFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object service;
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getF_SoapSendReceiveActivity_requestor(soapSendReceive)) != null && (service = TibcoReflectionCache.getF_SoapRequestor_ISoapServiceConfig(requestor)) != null) {
                namespace = (String)TibcoReflectionCache.getF_SoapCommonConfig_wsdlNamespace(service);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getNamespace: " + namespace);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals("UnknownNamespace") ? "UnknownNamespace" : namespace;
    }

    @Override
    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getF_SoapSendReceiveActivity_requestor(soapSendReceive)) != null) {
                if (requestor.getClass().getName().equalsIgnoreCase(C_SoapJmsRequestor)) {
                    Map urlToServiceConfigListMap;
                    Object engineConfig = TibcoReflectionCache.getF_SoapRequestor_SoapEngineConfig(requestor);
                    if (engineConfig != null && (urlToServiceConfigListMap = (Map)TibcoReflectionCache.getF_SoapEngineConfig_urlToServiceConfigListMap(engineConfig)) != null) {
                        Set col = urlToServiceConfigListMap.keySet();
                        Iterator itr = col.iterator();
                        while (itr.hasNext()) {
                            webServiceURI = itr.next().toString();
                        }
                    }
                } else {
                    Object endpointConfig = TibcoReflectionCache.getF_SoapHttpRequestor_SoapEndpointConfig(requestor);
                    if (endpointConfig != null) {
                        webServiceURI = (String)TibcoReflectionCache.getF_SoapEndpointConfiguration_kString(endpointConfig);
                    }
                }
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals("UnknownServiceName") ? "UnknownServiceName" : webServiceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getF_SoapSendReceiveActivity_requestor(soapSendReceive)) != null) {
                operationName = (String)TibcoReflectionCache.getF_SoapRequestor_operationName(requestor);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getOperationName: " + operationName);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_OPERATION_NAME", bomb);
        }
        return operationName == null || operationName.trim().length() == 0 || operationName.equals("UnknownOperationName") ? "UnknownOperationName" : operationName;
    }
}

