/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.ws.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.SharedDataStructure2;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.CountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.FaultedBlameTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.ws.hc2.SOAPFaultTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ClientSOAPFaultTracer
extends BlamePointTracer {
    public boolean soapFlag = false;
    boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();

    public ClientSOAPFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private void processError(InvocationData data, String component, WilyTransactionElement start) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String objString = null;
        Throwable error = data.getInvocationThrownException();
        Object fData = TibcoReflectionCache.getM_getData(error);
        if (fData != null) {
            Method M_Attribute = TibcoReflectionCache.getM_Attribute_getStringValue(fData);
            Object fDataObj = M_Attribute.invoke(fData, KConstants.EMPTY_OBJECT_ARRAY);
            if (fDataObj != null) {
                objString = (String)fDataObj;
            }
            this.soapFlag = objString != null;
            if (this.soapFlag) {
                String errorMessage = "SOAP Fault: " + start.getComponentName() + ": " + objString;
                if (this.isDebugEnabled) {
                    TibcoBWUtils.getLogger().debug("ClientSOAPFaultTracer - SOAP Fault Message: " + errorMessage);
                }
                FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)errorMessage);
                if (start instanceof FaultedBlameTransactionElement) {
                    FaultedBlameTransactionElement faultelem = (FaultedBlameTransactionElement)start;
                    FaultFeature.incrementFaultMetric((FaultedBlameTransactionElement)faultelem, (IStackElement)data);
                }
            }
        }
        Throwable errorNew = error;
        String errorMessage = String.valueOf(component) + ": " + errorNew.getClass().getName() + ": " + errorNew.getMessage();
        if (this.isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("ClientSOAPFaultTracer - Error Message: " + errorMessage);
        }
        ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
        ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
        ErrorFeature.incrementErrorMetric((WilyTransactionElement)start, (IStackElement)data);
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation info) {
        HashMap<SharedDataStructure2, AgentMetric[]> agentMetrics = new HashMap<SharedDataStructure2, AgentMetric[]>();
        AgentMetric[] errorMetric = this.createErrorsMetric(String.valueOf(componentName) + ":" + "Errors Per Interval");
        CountMetricGathererWrapper wrapper = CountMetricGathererWrapper.getFactory((boolean)true);
        SharedDataStructure2 errorsSds = new SharedDataStructure2((ISharedElement)wrapper);
        agentMetrics.put(errorsSds, errorMetric);
        AgentMetric[] soapFaults = this.createErrorsMetric(String.valueOf(componentName) + ":" + SOAPFaultTracer.SOAP_FAULT_PER_INTERVAL);
        return FaultFeature.createFaultedBlameTransactionElement((Object)key, (String)componentName, (int)blameStatus, (boolean)isStartTrace, (ITransactionElement)parent, (IBlameTransactionElement)previous, (IBlameTransactionElement)start, agentMetrics, null, null, null, (IRepository)errorsSds, null, (ProbeInformation)info, (AgentMetric[])soapFaults);
    }

    protected void updateCustomMetricsIfAny(WilyTransactionElement start, InvocationData data) {
        if (data.hasInvocationThrownException()) {
            try {
                String componentName = start.getComponentName();
                this.processError(data, componentName, start);
            }
            catch (Throwable bomb) {
                TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_CLIENT_SOAPFAULT_TRACER", bomb);
            }
        }
    }

    protected ABlameComponent getBlameComponent(int tracerIndex, InvocationData data) {
        Object key = this.getBlameKey(data);
        ABlameComponent result = ABlameComponent.getInstance((Object)key);
        return result;
    }

    protected Object getBlameKey(InvocationData data) {
        return String.valueOf(this.getComponentName(data)) + "|" + SOAPFaultTracer.SOAP_FAULT_PER_INTERVAL;
    }
}

