/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.sysview.ctgtracer.eci;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.WilyStringBuilder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class JavaGatewayNameFormatter
implements INameFormatter {
    private static final String kListSystems = "LISTSYSTEMS";
    private static final String kEciNoExtend = "ECI_NO_EXTEND";
    private static final String kEciExtended = "ECI_EXTENDED";
    private static final String kEciCommit = "ECI_COMMIT";
    private static final String kEciBackout = "ECI_BACKOUT";
    private static final long eciExtended_value = 1L;
    private static final long eciCommit_value = 2L;
    private static final long eciBackout_value = 4L;
    public static final String kCommunicateCTGChannel = "CTG Channel";
    public static final String kCommunicateCommAreaStatic = "CommArea Static";
    public static final String kCommunicateCommAreaDynamic = "CommArea Dynamic";
    public static final String kRequestType_Unknown = "Unknown";
    public static final String kRequestType_CodePage = "Code Page";
    public static final String kRequestType_ECI = "ECI";
    public static final String kRequestType_EPI = "EPI";
    public static final String kRequestType_ESI = "ESI";
    public static final String kRequestType_XA = "XA";
    public static final Integer RequestCode_Unknown = 0;
    public static final Integer RequestCode_CodePage = 1;
    public static final Integer RequestCode_ECI = 2;
    public static final Integer RequestCode_EPI = 3;
    public static final Integer RequestCode_ESI = 4;
    public static final Integer RequestCode_XA = 5;
    private static final String kMaxNumServersFieldKey = "maxNumServers";
    private static final String kUnknownXARequestType = "UNKNOWN XA REQUEST";
    public static final String kCTGRequestClassParameterKey = "CTG Request Class";
    public static final String kCTGRequestTypeParameterKey = "CTG Request Type";
    public static final String kCTGRequestCodeParameterKey = "CTG Code Type";
    public static final String kUserIDParameterKey = "User ID";
    public static final String kXARequestTypeParameterKey = "XA Request Type";
    public static final String kTransactionNameParameterKey = "Transaction Name";
    public static final String kProgramNameParameterKey = "Program Name";
    public static final String kCTGServerNameParameterKey = "CTG Server Name";
    public static final String kCTGExtendModeParameterKey = "CTG Extend Mode";
    public static final String kCommunicationMethodParameterKey = "Communication Method";
    private static String NAME_FOR_UNKNOWN = "UNKNOWN";
    private static final String kJavaGatewayFlowHashmapKey = "JavaGatewayFlowHashMap";
    private static final String kUndefinedServerName = "UNDEFINED";
    private static final String kDefaultTransactionID = "CSMI";
    private static final String kChannelClassKey = "com.ibm.ctg.client.Channel";
    private static final String kConnectionServerFieldKey = "strAddress";
    public static final String kECIChannelFieldKey = "channel";
    public static final String kECICommareaFieldKey = "Commarea";
    private static final String kECIExtendModeField = "Extend_Mode";
    private static final String kECIProgramField = "Program";
    private static final String kECIServerFieldKey = "Server";
    private static final String kECITransidFieldKey = "Transid";
    private static final String kECIUserIDFieldKey = "Userid";
    private static final String kEPIServerFieldKey = "Server";
    private static final String kEPITransidFieldKey = "Transid";
    private static final String kEPIUserIDFieldKey = "userid";
    private static final String kESIServerFieldKey = "server";
    private static final String kESIUserIDFieldKey = "userid";
    private static final String kXAServerFieldKey = "serverName";
    private static final String kXAUserIDFieldKey = "username";
    private static final String kGetRequestTypeStringMethodKey = "getRequestTypeString";
    protected final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private static ThreadLocal<WilyStringBuilder> NameFormatterBuilder = new ThreadLocal<WilyStringBuilder>(){

        @Override
        protected WilyStringBuilder initialValue() {
            return new WilyStringBuilder();
        }
    };
    private static final ThreadLocal<Constructor<?>> threadSpecificChannelConstructor = new ThreadLocal<Constructor<?>>(){

        @Override
        protected Constructor<?> initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<Class<? extends Object>> threadSpecificClassOfEciRequest = new ThreadLocal<Class<? extends Object>>(){

        @Override
        protected Class<? extends Object> initialValue() {
            return null;
        }
    };
    private static final char[] kRequestTypePlaceHolder = "{Request type}".toCharArray();
    private static final char[] kServerNamePlaceHolder = "{Server}".toCharArray();
    private static final char[] kProgramNamePlaceHolder = "{Program}".toCharArray();
    private static final char[] kTransactionNamePlaceHolder = "{Transaction}".toCharArray();
    private static final char[] kXOperationPlaceHolder = "{xOperation}".toCharArray();
    private static final String kServerNamePrefix = " server ";
    private static final String kProgramNamePrefix = " program ";
    private static final String kTransactionNamePrefix = " transaction ";

    public static Constructor<?> getChannelConstructor() {
        return threadSpecificChannelConstructor.get();
    }

    public static Constructor<?> loadChannelConstructor(Object eciRequest) throws SecurityException, NoSuchMethodException, ClassNotFoundException, NoClassDefFoundError {
        Constructor<?> channelConstructor = JavaGatewayNameFormatter.getChannelConstructor();
        if (channelConstructor == null) {
            ClassLoader classLoader = null;
            classLoader = eciRequest.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> classOfChannel = classLoader.loadClass(kChannelClassKey);
            channelConstructor = classOfChannel.getConstructor(String.class);
            threadSpecificChannelConstructor.set(channelConstructor);
        }
        return channelConstructor;
    }

    public JavaGatewayNameFormatter(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
    }

    public String INameFormatter_format(String nameTemplate, InvocationData invocationData) {
        String requestType = kRequestType_Unknown;
        String serverName = null;
        String programName = null;
        String transactionName = null;
        String xOperation = null;
        if (nameTemplate == null) {
            return nameTemplate;
        }
        WilyStringBuilder bldr = NameFormatterBuilder.get();
        bldr.setString(nameTemplate);
        try {
            Integer requestCode;
            Map<String, Object> propertiesMap = JavaGatewayNameFormatter.getPropertiesHashMap(invocationData);
            if (propertiesMap != null && (requestCode = (Integer)propertiesMap.get(kCTGRequestCodeParameterKey)) != null) {
                requestType = (String)propertiesMap.get(kCTGRequestTypeParameterKey);
                serverName = (String)propertiesMap.get(kCTGServerNameParameterKey);
                programName = (String)propertiesMap.get(kProgramNameParameterKey);
                transactionName = (String)propertiesMap.get(kTransactionNameParameterKey);
                if (requestCode == RequestCode_ECI) {
                    if (programName == null) {
                        xOperation = (String)propertiesMap.get(kCTGExtendModeParameterKey);
                    }
                    transactionName = null;
                } else if (requestCode == RequestCode_XA) {
                    xOperation = (String)propertiesMap.get(kXARequestTypeParameterKey);
                }
            }
        }
        catch (Exception exception) {}
        this.replacePlaceHolder(bldr, kRequestTypePlaceHolder, " ", requestType);
        this.replacePlaceHolder(bldr, kServerNamePlaceHolder, kServerNamePrefix, serverName);
        this.replacePlaceHolder(bldr, kProgramNamePlaceHolder, kProgramNamePrefix, programName);
        this.replacePlaceHolder(bldr, kTransactionNamePlaceHolder, kTransactionNamePrefix, transactionName);
        this.replacePlaceHolder(bldr, kXOperationPlaceHolder, " ", xOperation);
        return bldr.toString().intern();
    }

    void replacePlaceHolder(WilyStringBuilder bldr, char[] placeholder, String prefix, String substitution) {
        int placeHolderIndex = bldr.indexOf(placeholder);
        if (placeHolderIndex >= 0) {
            substitution = substitution == null ? "" : String.valueOf(prefix) + substitution;
            bldr = bldr.replace(placeHolderIndex, placeHolderIndex + placeholder.length, substitution);
        }
    }

    protected IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public IStringLocalizer getFLocalizer() {
        return this.fLocalizer;
    }

    public static Map<String, Object> getPropertiesHashMap(InvocationData invocationData) throws Exception {
        Field channelField = null;
        Object channel = null;
        Object commarea = null;
        String serverName = null;
        String programName = null;
        String transactionName = null;
        String extendModeName = null;
        String xaRequestType = null;
        String userID = null;
        HashMap<String, Object> propertiesHashMap = (HashMap<String, Object>)invocationData.get(kJavaGatewayFlowHashmapKey);
        if (propertiesHashMap != null) {
            return propertiesHashMap;
        }
        Object gatewayRequest = invocationData.getInvocationParameterAsObject(0);
        Class<?> classOfGatewayRequest = gatewayRequest.getClass();
        String classNameOfGatewayRequest = classOfGatewayRequest.getName();
        String ctgRequestType = kRequestType_Unknown;
        Integer requestCode = RequestCode_Unknown;
        if (classNameOfGatewayRequest.equals("com.ibm.ctg.client.CicsCpRequest")) {
            ctgRequestType = kRequestType_CodePage;
            requestCode = RequestCode_CodePage;
        } else if (classNameOfGatewayRequest.equals("com.ibm.ctg.client.ECIRequest")) {
            Object connection;
            ctgRequestType = kRequestType_ECI;
            requestCode = RequestCode_ECI;
            channel = JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, kECIChannelFieldKey);
            try {
                channelField = classOfGatewayRequest.getDeclaredField(kECIChannelFieldKey);
                if (channelField != null) {
                    channelField.setAccessible(true);
                    channel = channelField.get(gatewayRequest);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (Exception exception) {}
            commarea = JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, kECICommareaFieldKey);
            transactionName = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, "Transid");
            if (transactionName != null && (transactionName = transactionName.trim()).length() == 0) {
                transactionName = null;
            }
            try {
                if (classOfGatewayRequest.getDeclaredField(kMaxNumServersFieldKey).getLong(gatewayRequest) > 0L) {
                    programName = kListSystems;
                } else {
                    Long extendMode = classOfGatewayRequest.getDeclaredField(kECIExtendModeField).getLong(gatewayRequest);
                    if (extendMode == 2L) {
                        extendModeName = kEciCommit;
                        programName = null;
                    } else if (extendMode == 4L) {
                        extendModeName = kEciBackout;
                        programName = null;
                    } else {
                        extendModeName = extendMode == 1L ? kEciExtended : kEciNoExtend;
                        programName = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, kECIProgramField);
                        if (programName != null && (programName = programName.trim()).length() == 0) {
                            programName = null;
                        }
                        if (transactionName == null) {
                            transactionName = kDefaultTransactionID;
                        }
                    }
                }
            }
            catch (Exception exception) {}
            serverName = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, "Server");
            if (serverName == null && (serverName = (String)JavaGatewayNameFormatter.getMemberOfObject((connection = invocationData.getInvocationObject()).getClass(), connection, kConnectionServerFieldKey)) != null && (serverName = serverName.trim()).length() == 0) {
                serverName = null;
            }
            userID = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, kECIUserIDFieldKey);
        } else if (classNameOfGatewayRequest.equals("com.ibm.ctg.client.EPIRequest")) {
            Object connection;
            ctgRequestType = kRequestType_EPI;
            requestCode = RequestCode_EPI;
            serverName = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, "Server");
            if (serverName == null && (serverName = (String)JavaGatewayNameFormatter.getMemberOfObject((connection = invocationData.getInvocationObject()).getClass(), connection, kConnectionServerFieldKey)) == null) {
                serverName = kUndefinedServerName;
            }
            transactionName = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, "Transid");
            userID = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, "userid");
        } else if (classNameOfGatewayRequest.equals("com.ibm.ctg.client.ESIRequest")) {
            Object connection;
            ctgRequestType = kRequestType_ESI;
            requestCode = RequestCode_ESI;
            serverName = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, kESIServerFieldKey);
            if (serverName == null && (serverName = (String)JavaGatewayNameFormatter.getMemberOfObject((connection = invocationData.getInvocationObject()).getClass(), connection, kConnectionServerFieldKey)) == null) {
                serverName = kUndefinedServerName;
            }
            userID = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, "userid");
        } else if (classNameOfGatewayRequest.equals("com.ibm.ctg.client.XARequest")) {
            Object connection;
            ctgRequestType = kRequestType_XA;
            requestCode = RequestCode_XA;
            serverName = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, kXAServerFieldKey);
            if (serverName == null && (serverName = (String)JavaGatewayNameFormatter.getMemberOfObject((connection = invocationData.getInvocationObject()).getClass(), connection, kConnectionServerFieldKey)) == null) {
                serverName = kUndefinedServerName;
            }
            userID = (String)JavaGatewayNameFormatter.getMemberOfObject(classOfGatewayRequest, gatewayRequest, kXAUserIDFieldKey);
            xaRequestType = null;
            try {
                Method method = classOfGatewayRequest.getMethod(kGetRequestTypeStringMethodKey, new Class[0]);
                method.setAccessible(true);
                xaRequestType = (String)method.invoke(gatewayRequest, new Object[0]);
            }
            catch (Exception exception) {
                xaRequestType = kUnknownXARequestType;
            }
        }
        if (serverName != null) {
            serverName = serverName.trim().toUpperCase();
        }
        propertiesHashMap = new HashMap<String, Object>();
        propertiesHashMap.put(kCTGRequestClassParameterKey, classNameOfGatewayRequest);
        propertiesHashMap.put(kCTGRequestTypeParameterKey, ctgRequestType);
        propertiesHashMap.put(kCTGRequestCodeParameterKey, requestCode);
        if (programName != null) {
            propertiesHashMap.put(kProgramNameParameterKey, programName);
        }
        if (serverName != null) {
            propertiesHashMap.put(kCTGServerNameParameterKey, serverName);
        }
        if (transactionName != null) {
            propertiesHashMap.put(kTransactionNameParameterKey, transactionName);
        }
        if (extendModeName != null) {
            propertiesHashMap.put(kCTGExtendModeParameterKey, extendModeName);
        }
        if (channelField != null) {
            propertiesHashMap.put(kECIChannelFieldKey, channel);
        }
        if (commarea != null) {
            propertiesHashMap.put(kECICommareaFieldKey, commarea);
        }
        if (userID != null) {
            propertiesHashMap.put(kUserIDParameterKey, userID);
        }
        if (xaRequestType != null) {
            propertiesHashMap.put(kXARequestTypeParameterKey, xaRequestType);
        }
        invocationData.put(kJavaGatewayFlowHashmapKey, propertiesHashMap);
        return propertiesHashMap;
    }

    private static Object getMemberOfObject(Class<? extends Object> classOfObject, Object object, String memberName) {
        try {
            Field field = classOfObject.getDeclaredField(memberName);
            if (field != null) {
                field.setAccessible(true);
                return field.get(object);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (Exception exception) {}
        return null;
    }
}

