/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.ICacheable;
import com.wily.util.adt.NotifyingCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class Cache {
    private final int fMaxSize;
    private final boolean fUniqueValues;
    private final HashMap fLookup;
    private final HashMap fReverseLookup;
    private HashMap fSnapshot;
    private ValueWrapper fFirst;
    private ValueWrapper fLast;

    public Cache() {
        this(-1, false);
    }

    public Cache(int maxSize) {
        this(maxSize, false);
    }

    public Cache(int maxSize, boolean uniqueValues) {
        if (maxSize < -1) {
            throw new IllegalArgumentException("the cache size must be at least zero (or -1 if no max size)");
        }
        this.fMaxSize = maxSize;
        this.fUniqueValues = uniqueValues;
        this.fLookup = new HashMap();
        this.fReverseLookup = new HashMap();
        this.fSnapshot = null;
        this.fFirst = null;
        this.fLast = null;
    }

    public synchronized void clear() {
        Iterator it = this.fLookup.values().iterator();
        while (it.hasNext()) {
            this.objectRemoved(it.next());
        }
        this.fLookup.clear();
        this.fReverseLookup.clear();
        this.fSnapshot = null;
        this.fFirst = null;
        this.fLast = null;
    }

    public synchronized Set keySnapshot() {
        if (this.fSnapshot == null) {
            this.fSnapshot = (HashMap)this.fLookup.clone();
        }
        return this.fSnapshot.keySet();
    }

    public synchronized int size() {
        return this.fLookup.size();
    }

    public synchronized Object get(Object key) {
        ValueWrapper wrapper = (ValueWrapper)this.fLookup.get(key);
        if (wrapper == null) {
            return null;
        }
        this.updateItem(wrapper);
        return wrapper.fValue;
    }

    public synchronized void put(Object key, Object value) {
        ValueWrapper wrapper;
        if (this.fMaxSize == 0) {
            return;
        }
        if (this.fMaxSize != -1 && this.size() == this.fMaxSize) {
            this.fSnapshot = null;
            ValueWrapper removed = this.removeItem();
            if (removed != null) {
                this.remove(removed.fKey);
            }
        }
        if ((wrapper = (ValueWrapper)this.fLookup.get(key)) != null) {
            this.fSnapshot = null;
            this.removeItem(wrapper);
        }
        wrapper = new ValueWrapper(key, value);
        this.fLookup.put(key, wrapper);
        this.fSnapshot = null;
        this.addItem(wrapper);
        if (this.fUniqueValues) {
            this.fReverseLookup.put(value, key);
        }
    }

    protected void objectRemoved(Object value) {
    }

    public synchronized Object remove(Object key) {
        ValueWrapper wrapper = (ValueWrapper)this.fLookup.remove(key);
        if (wrapper == null) {
            return null;
        }
        this.fSnapshot = null;
        this.removeItem(wrapper);
        this.fReverseLookup.remove(wrapper.fValue);
        this.objectRemoved(wrapper.fValue);
        return wrapper.fValue;
    }

    public synchronized Object reverseGet(Object value) {
        ValueWrapper wrapper;
        if (!this.fUniqueValues) {
            throw new IllegalStateException("can only do a reverse cache lookup when the values are unique");
        }
        Object key = this.fReverseLookup.get(value);
        if (key != null && (wrapper = (ValueWrapper)this.fLookup.get(key)) != null) {
            this.updateItem(wrapper);
        }
        return key;
    }

    private void addItem(ValueWrapper wrapper) {
        if (this.fFirst == null) {
            this.fFirst = wrapper;
            this.fLast = wrapper;
        } else {
            wrapper.fPrev = this.fLast;
            if (this.fLast != null) {
                this.fLast.fNext = wrapper;
            }
            this.fLast = wrapper;
        }
    }

    private void updateItem(ValueWrapper wrapper) {
        this.removeItem(wrapper);
        this.addItem(wrapper);
    }

    private ValueWrapper removeItem() {
        ValueWrapper item = this.fFirst;
        if (item != null) {
            this.removeItem(item);
        }
        return item;
    }

    private void removeItem(ValueWrapper wrapper) {
        if (wrapper.fPrev == null) {
            if (wrapper.fNext == null) {
                this.fFirst = null;
                this.fLast = null;
            } else {
                this.fFirst = wrapper.fNext;
                this.fFirst.fPrev = null;
            }
        } else if (wrapper.fNext == null) {
            this.fLast = wrapper.fPrev;
            this.fLast.fNext = null;
        } else {
            wrapper.fNext.fPrev = wrapper.fPrev;
            wrapper.fPrev.fNext = wrapper.fNext;
        }
        wrapper.fPrev = null;
        wrapper.fNext = null;
    }

    private class ValueWrapper
    implements ICacheable {
        public Object fKey;
        public Object fValue;
        public ValueWrapper fPrev;
        public ValueWrapper fNext;

        public ValueWrapper(Object key, Object value) {
            this.fKey = key;
            this.fValue = value;
            this.fPrev = null;
            this.fNext = null;
        }

        @Override
        public void ICacheable_addedToCache(NotifyingCache cache) {
            if (this.fValue instanceof ICacheable) {
                ((ICacheable)this.fValue).ICacheable_addedToCache(cache);
            }
        }

        @Override
        public void ICacheable_removedFromCache(NotifyingCache cache) {
            if (this.fValue instanceof ICacheable) {
                ((ICacheable)this.fValue).ICacheable_removedFromCache(cache);
            }
        }
    }
}

