/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.io.AbstractByteArrayOutputStream;
import com.wily.util.io.FastArrayCopy;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

public class NonSyncByteArrayOutputStream
extends AbstractByteArrayOutputStream {
    private static final byte[] kEmptyByteArray = new byte[0];
    private static final int kBufferSize = 8192;
    private final int fBufferSize;
    private LinkedList fBuffers;
    private int fBufferPosition;
    private byte[] fCurrentBuffer;
    private static final int sIoChunkSize = Integer.parseInt(System.getProperty("wily.maxIOsize", Integer.toString(8192)));

    public NonSyncByteArrayOutputStream() {
        this(8192);
    }

    public NonSyncByteArrayOutputStream(int buffersSize) {
        this.fBufferSize = buffersSize;
        this.fBuffers = new LinkedList();
        this.reset();
    }

    private void addBuffer() {
        if (this.fCurrentBuffer != null) {
            this.fBuffers.add(this.fCurrentBuffer);
        }
        this.fCurrentBuffer = new byte[this.fBufferSize];
        this.fBufferPosition = 0;
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.fBufferPosition == this.fBufferSize) {
            this.addBuffer();
        }
        this.fCurrentBuffer[this.fBufferPosition++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len != 0) {
            if (this.fBufferPosition == this.fBufferSize) {
                this.addBuffer();
            }
            int amountForCurrentBuff = Math.min(len, this.fBufferSize - this.fBufferPosition);
            FastArrayCopy.copy(b, off, this.fCurrentBuffer, this.fBufferPosition, amountForCurrentBuff);
            off += amountForCurrentBuff;
            this.fBufferPosition += amountForCurrentBuff;
            len -= amountForCurrentBuff;
        }
    }

    @Override
    public void rewriteInt(int position, int v) throws IOException {
        this.rewrite(position++, v >>> 24 & 0xFF);
        this.rewrite(position++, v >>> 16 & 0xFF);
        this.rewrite(position++, v >>> 8 & 0xFF);
        this.rewrite(position, v >>> 0 & 0xFF);
    }

    public void rewrite(int position, int value) throws IOException {
        int searchPosition = 0;
        for (byte[] buffer : this.fBuffers) {
            if (position >= searchPosition && position < searchPosition + this.fBufferSize) {
                buffer[position -= searchPosition] = (byte)(value & 0xFF);
                return;
            }
            searchPosition += this.fBufferSize;
        }
        if (position < searchPosition || position >= searchPosition + this.fBufferPosition) {
            throw new IOException("Invalid write position " + position);
        }
        this.fCurrentBuffer[position -= searchPosition] = (byte)(value & 0xFF);
    }

    @Override
    public void reset() {
        this.fBuffers.clear();
        if (this.fCurrentBuffer == null) {
            this.fCurrentBuffer = new byte[this.fBufferSize];
        }
        this.fBufferPosition = 0;
    }

    @Override
    public int size() {
        return this.fBuffers.size() * this.fBufferSize + this.fBufferPosition;
    }

    public void writeTo(OutputStream out) throws IOException {
        for (byte[] buffer : this.fBuffers) {
            int offset = 0;
            while (offset < buffer.length) {
                out.write(buffer, offset, Math.min(sIoChunkSize, buffer.length - offset));
                offset += sIoChunkSize;
            }
        }
        if (this.fBufferPosition > 0) {
            int offset = 0;
            while (offset < this.fBufferPosition) {
                out.write(this.fCurrentBuffer, offset, Math.min(sIoChunkSize, this.fBufferPosition - offset));
                offset += sIoChunkSize;
            }
        }
    }

    @Override
    public int writeTo(DataOutput out) throws IOException {
        if (this.fBuffers.size() > 0) {
            for (byte[] buffer : this.fBuffers) {
                int offset = 0;
                while (offset < buffer.length) {
                    out.write(buffer, offset, Math.min(sIoChunkSize, buffer.length - offset));
                    offset += sIoChunkSize;
                }
            }
        }
        if (this.fBufferPosition > 0) {
            int offset = 0;
            while (offset < this.fBufferPosition) {
                out.write(this.fCurrentBuffer, offset, Math.min(sIoChunkSize, this.fBufferPosition - offset));
                offset += sIoChunkSize;
            }
        }
        return 0;
    }

    public byte[] toByteArray() {
        int size = this.size();
        if (size > 0) {
            byte[] newbuf = new byte[size];
            int destPosition = 0;
            for (byte[] buffer : this.fBuffers) {
                System.arraycopy(buffer, 0, newbuf, destPosition, this.fBufferSize);
                destPosition += this.fBufferSize;
            }
            System.arraycopy(this.fCurrentBuffer, 0, newbuf, destPosition, this.fBufferPosition);
            return newbuf;
        }
        return kEmptyByteArray;
    }

    public int getFreeBytes() {
        return this.fBufferSize - this.fBufferPosition;
    }
}

