/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xml;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.utilities.properties.Messages;
import java.text.MessageFormat;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BasicXMLErrorHandler
implements ErrorHandler {
    private final boolean fIgnoreWarning;
    private final boolean fIgnoreError;
    private final IModuleFeedbackChannel fModuleFeedback;

    public BasicXMLErrorHandler(boolean ignoreWarning, boolean ignoreError, IModuleFeedbackChannel moduleFeedback) {
        this.fIgnoreWarning = ignoreWarning;
        this.fIgnoreError = ignoreError;
        this.fModuleFeedback = moduleFeedback;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (!this.fIgnoreWarning) {
            this.simpleHandleError(Messages.getString("BasicXMLErrorHandler.WarningMsg_Log"), exception);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (!this.fIgnoreError) {
            this.simpleHandleError(Messages.getString("BasicXMLErrorHandler.RecoverableErrorMsg_Log"), exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.simpleHandleError(Messages.getString("BasicXMLErrorHandler.FatalErrorMsg_Log"), exception);
    }

    private void simpleHandleError(String message, SAXParseException exception) throws SAXException {
        if (this.fModuleFeedback != null) {
            String lineNumber = "" + exception.getLineNumber();
            String columnNumber = "" + exception.getColumnNumber();
            this.fModuleFeedback.error(MessageFormat.format(Messages.getString("BasicXMLErrorHandler.XMLParsingError_Log"), lineNumber, columnNumber, exception.getMessage()));
        }
        throw exception;
    }
}

