/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.InvalidIdentifierException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassFileMethodDescriptor;
import com.wily.util.classfile.java.ClassFileValidationUtilities;
import com.wily.util.text.FormattedLocalizableMessage;

public final class MethodName
implements IMethodName {
    private final String fMethodName;
    private final ClassFileMethodDescriptor fMethodDescriptor;

    private MethodName(String methodName, ClassFileMethodDescriptor methodDescriptor) {
        this.fMethodName = methodName;
        this.fMethodDescriptor = methodDescriptor;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public String getNameString() {
        return this.getMethodName();
    }

    public boolean hasMethodDescriptor() {
        return this.getMethodDescriptor() != null;
    }

    public ClassFileMethodDescriptor getMethodDescriptor() {
        return this.fMethodDescriptor;
    }

    public boolean hasSignature() {
        return this.hasMethodDescriptor();
    }

    public IMethodSignature getSignature() {
        return this.getMethodDescriptor();
    }

    public String getNameAndSignatureString() {
        if (this.fMethodDescriptor != null) {
            return this.fMethodName + this.fMethodDescriptor.toString();
        }
        return this.fMethodName;
    }

    public String toString() {
        return this.getNameAndSignatureString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodName) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static MethodName getMethodName(String name) throws InvalidMethodDescriptorException, InvalidMethodNameException {
        return MethodName.parseMethodName(name, false);
    }

    public static MethodName getMethodNameWithDescriptor(String name) throws InvalidMethodDescriptorException, InvalidMethodNameException {
        return MethodName.parseMethodName(name, true);
    }

    private static MethodName parseMethodName(String name, boolean descriptorIsRequired) throws InvalidMethodDescriptorException, InvalidMethodNameException {
        String methodName = name;
        String methodDescriptor = null;
        int separator = name.indexOf(40);
        if (separator != -1) {
            methodName = name.substring(0, separator);
            methodDescriptor = name.substring(separator);
        }
        try {
            ClassFileValidationUtilities.validateRegularOrSpecialJavaMethodName(methodName);
        }
        catch (InvalidIdentifierException iie) {
            throw new InvalidMethodNameException(new FormattedLocalizableMessage("Class_File_Invalid_Method_Name", name), name);
        }
        ClassFileMethodDescriptor descriptor = null;
        if (descriptorIsRequired || methodDescriptor != null) {
            descriptor = new ClassFileMethodDescriptor(methodDescriptor);
        }
        return new MethodName(methodName, descriptor);
    }
}

