/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.IObjectFilter;
import com.wily.util.adt.KeyValueWrapper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class CanonicalObjectPoolWithKey {
    private Entry[] fEntries;
    private int fEntryShiftSize = 2;
    private int fIndexMask = (1 << this.fEntryShiftSize) - 1;
    private int fCleanEntries = 0;
    private int fCount;

    public CanonicalObjectPoolWithKey() {
        this.fEntries = new Entry[1 << this.fEntryShiftSize];
    }

    private void growTable() {
        ++this.fEntryShiftSize;
        this.fIndexMask = (1 << this.fEntryShiftSize) - 1;
        Entry[] oldtable = this.fEntries;
        this.fEntries = new Entry[1 << this.fEntryShiftSize];
        int i = 0;
        while (i < oldtable.length) {
            Entry entry = oldtable[i];
            while (entry != null) {
                Entry origNxtEntry = entry.getNext();
                Object reference = entry.get();
                if (reference != null) {
                    int hashCode = entry.getKey().hashCode();
                    int index = hashCode & this.fIndexMask;
                    entry.setNext(this.fEntries[index]);
                    this.fEntries[index] = entry;
                } else {
                    --this.fCount;
                }
                entry = origNxtEntry;
            }
            ++i;
        }
    }

    private void cleanEntries() {
        int i = 0;
        while (i < this.fEntries.length) {
            Entry prior = null;
            Entry entry = this.fEntries[i];
            while (entry != null) {
                if (entry.get() == null) {
                    entry = this.purgeEntry(i, prior, entry);
                    continue;
                }
                prior = entry;
                entry = entry.getNext();
            }
            ++i;
        }
    }

    public int size() {
        this.cleanEntries();
        return this.fCount;
    }

    public Object getCanonicalObject(Object key) {
        return this.getCanonicalObjectInternal(key, null);
    }

    public Object getCanonicalObject(Object key, Object value) {
        return this.getCanonicalObjectInternal(key, value);
    }

    public KeyValueWrapper getCanonicalObjectWrapper(Object key) {
        return this.getCanonicalObjectWrapperInternal(key, null);
    }

    public KeyValueWrapper getCanonicalObjectWrapper(Object key, Object value) {
        return this.getCanonicalObjectWrapperInternal(key, value);
    }

    private Object getCanonicalObjectInternal(Object key, Object value) {
        int hashCode = key.hashCode();
        int index = hashCode & this.fIndexMask;
        Entry prior = null;
        Entry entry = this.fEntries[index];
        while (entry != null) {
            Object reference = entry.get();
            if (reference == null) {
                entry = this.purgeEntry(index, prior, entry);
                continue;
            }
            Object entryKey = entry.getKey();
            if (entryKey.hashCode() == hashCode && entryKey.equals(key)) {
                return reference;
            }
            prior = entry;
            entry = entry.getNext();
        }
        if (value == null) {
            return null;
        }
        Entry newEntry = new Entry(key, value);
        newEntry.setNext(this.fEntries[index]);
        this.fEntries[index] = newEntry;
        ++this.fCount;
        if (this.fCount >> 2 > this.fIndexMask) {
            this.growTable();
        }
        if ((this.fCleanEntries++ & (this.fIndexMask << 3 | 7)) == (this.fIndexMask << 3 | 7)) {
            this.cleanEntries();
        }
        return value;
    }

    private Entry purgeEntry(int index, Entry prior, Entry entry) {
        entry = entry.getNext();
        if (prior == null) {
            this.fEntries[index] = entry;
        } else {
            prior.setNext(entry);
        }
        --this.fCount;
        return entry;
    }

    private KeyValueWrapper getCanonicalObjectWrapperInternal(Object key, Object value) {
        Object o = this.getCanonicalObject(key, value);
        if (o != null) {
            return new KeyValueWrapper(key, o);
        }
        return null;
    }

    public Object[] toArray(Object[] returnArray) {
        ArrayList results = new ArrayList(this.fCount);
        int i = 0;
        while (i < this.fEntries.length) {
            Entry entry = this.fEntries[i];
            while (entry != null) {
                Object reference = entry.get();
                if (reference != null) {
                    results.add(reference);
                }
                entry = entry.getNext();
            }
            ++i;
        }
        return results.toArray(returnArray);
    }

    public Object[] toArray(IObjectFilter filter, Object[] returnArray) {
        ArrayList results = new ArrayList(this.fCount);
        int i = 0;
        while (i < this.fEntries.length) {
            Entry entry = this.fEntries[i];
            while (entry != null) {
                Object reference = entry.get();
                if (reference != null && filter.matches(reference)) {
                    results.add(reference);
                }
                entry = entry.getNext();
            }
            ++i;
        }
        return results.toArray(returnArray);
    }

    private static class Entry
    extends WeakReference {
        private Entry fNext;
        private final Object fKey;

        public Entry(Object key, Object ref) {
            super(ref);
            this.fKey = key;
        }

        public Entry getNext() {
            return this.fNext;
        }

        public Object getKey() {
            return this.fKey;
        }

        public void setNext(Entry next) {
            this.fNext = next;
        }
    }
}

