/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec;

import com.wily.rave.spec.IContent;
import com.wily.rave.spec.IContentChange;
import com.wily.rave.spec.IContentMetadataItemChange;
import com.wily.rave.spec.InvalidContent;
import com.wily.rave.spec.PropertyContent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PropertyContentChange
implements IContentChange,
Externalizable {
    private static final long serialVersionUID = 1L;
    private PropertyContent previousContent;
    private PropertyContent laterContent;
    private long changeDetectionTime;

    public PropertyContentChange() {
    }

    public PropertyContentChange(long changeDetectionTime, PropertyContent previousContent, PropertyContent laterContent) throws InvalidContent {
        if (!previousContent.getResourceName().equals(laterContent.getResourceName())) {
            throw new InvalidContent("Not same resource! Prior: " + previousContent.getResourceName() + "; later: " + laterContent.getResourceName());
        }
        this.changeDetectionTime = changeDetectionTime;
        this.previousContent = previousContent;
        this.laterContent = laterContent;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(this.previousContent);
        oo.writeObject(this.laterContent);
        oo.writeLong(this.changeDetectionTime);
    }

    @Override
    public void readExternal(ObjectInput oi) throws ClassNotFoundException, IOException {
        this.previousContent = (PropertyContent)oi.readObject();
        this.laterContent = (PropertyContent)oi.readObject();
        this.changeDetectionTime = oi.readLong();
    }

    @Override
    public boolean hasMetadata() {
        return false;
    }

    @Override
    public IContentMetadataItemChange[] getContentMetadataChange() {
        return null;
    }

    @Override
    public IContent getPreviousContent() {
        return this.previousContent;
    }

    @Override
    public IContent getLaterContent() {
        return this.laterContent;
    }

    @Override
    public long getChangeDetectionTime() {
        return this.changeDetectionTime;
    }
}

