/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.classmonitor;

import com.wily.rave.spec.Digest;
import com.wily.rave.spec.IContentMetadataItem;
import com.wily.rave.spec.IContentSummary;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.spec.SimpleContentMetadataItem;
import com.wily.rave.utils.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ClassContentSummary
implements IContentSummary,
Externalizable {
    static final String CLASS_DIGEST = "Class Digest";
    static final String CURRENT_SIZE = "Class Size";
    private static final IContentMetadataItem[] EMPTY_CONTENT_METADATA_ARRAY = new IContentMetadataItem[0];
    private static final long serialVersionUID = 1L;
    private String className;
    private IDataSourceInstance dsInstance;
    private long size;
    private Digest digest;
    private transient IContentMetadataItem[] metadataContent;

    public ClassContentSummary() {
    }

    public ClassContentSummary(String className, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this.className = className;
        this.dsInstance = dsInstance;
        this.size = size;
        this.digest = new Digest(digest);
    }

    @Override
    public long getChangeTimestamp() {
        return -1L;
    }

    @Override
    public String getResourceName() {
        return this.className;
    }

    @Override
    public String getResourceOwner() {
        return null;
    }

    @Override
    public boolean hasMetadata() {
        return true;
    }

    public String getDigestString() {
        return this.digest.toString();
    }

    @Override
    public IContentMetadataItem[] getMetadata() {
        if (this.metadataContent == null) {
            if (this.size < 0L) {
                this.metadataContent = EMPTY_CONTENT_METADATA_ARRAY;
            } else {
                this.metadataContent = new IContentMetadataItem[2];
                this.metadataContent[1] = new SimpleContentMetadataItem(CURRENT_SIZE, Long.toString(this.size));
                this.metadataContent[0] = new SimpleContentMetadataItem(CLASS_DIGEST, this.digest.toString());
            }
        }
        return this.metadataContent;
    }

    @Override
    public IDataSourceInstance getDataSourceInstance() {
        return this.dsInstance;
    }

    public byte[] getDigest() {
        return this.digest.getBytes();
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.className);
        out.writeLong(1L);
        out.writeObject(this.dsInstance);
        out.writeObject(this.digest);
        out.writeLong(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = in.readUTF();
        long oiLong = in.readLong();
        Long object = new Long(oiLong);
        if (object instanceof Long) {
            long serialUID = object;
            if (serialUID != 1L) {
                throw new ClassNotFoundException("Unknown serialVersionUID for ClassContentSummary: " + serialUID);
            }
            this.dsInstance = (IDataSourceInstance)in.readObject();
        } else if (object instanceof IDataSourceInstance) {
            this.dsInstance = (IDataSourceInstance)((Object)object);
        }
        this.digest = (Digest)in.readObject();
        this.size = in.readLong();
    }

    public int hashCode() {
        int code = HashCodeUtils.accumulateHashCode(this.dsInstance.hashCode(), this.className);
        code = HashCodeUtils.accumulateHashCode(code, this.size);
        return code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ClassContentSummary) {
            ClassContentSummary otherClassContentSummary = (ClassContentSummary)other;
            return this.className.equals(otherClassContentSummary.className) && this.dsInstance.equals(otherClassContentSummary.dsInstance) && this.size == otherClassContentSummary.size && this.digest.equals(otherClassContentSummary.digest);
        }
        return false;
    }

    public String getAssemblyPath() {
        return null;
    }

    public String getAssemblyVersion() {
        return null;
    }
}

