/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.filemonitor;

import com.twmacinta.util.MD5;
import com.wily.rave.spec.IContent;
import com.wily.rave.spec.IContentChange;
import com.wily.rave.spec.IContentMetadataItemChange;
import com.wily.rave.spec.InvalidContent;
import com.wily.rave.spec.SimpleContentMetadataItemChange;
import com.wily.rave.spec.ds.filemonitor.FileContent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FileContentChange
implements IContentChange,
Externalizable {
    private static final long serialVersionUID = 1L;
    private FileContent previousContent;
    private FileContent laterContent;
    private transient IContentMetadataItemChange[] metadataChange;
    private long changeDetectionTime;

    public FileContentChange() {
    }

    public FileContentChange(long changeDetectionTime, FileContent previousContent, FileContent laterContent) throws InvalidContent {
        if (!previousContent.getContentSummary().getResourceName().equals(laterContent.getContentSummary().getResourceName())) {
            throw new InvalidContent("Not same resources! Prior: " + previousContent.getContentSummary().getResourceName() + "; Later: " + laterContent.getContentSummary().getResourceName());
        }
        this.previousContent = previousContent;
        this.laterContent = laterContent;
        this.changeDetectionTime = changeDetectionTime;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(this.previousContent);
        oo.writeObject(this.laterContent);
        oo.writeLong(this.changeDetectionTime);
    }

    @Override
    public void readExternal(ObjectInput oi) throws ClassNotFoundException, IOException {
        this.previousContent = (FileContent)oi.readObject();
        this.laterContent = (FileContent)oi.readObject();
        this.changeDetectionTime = oi.readLong();
    }

    @Override
    public boolean hasMetadata() {
        return true;
    }

    @Override
    public IContentMetadataItemChange[] getContentMetadataChange() {
        if (this.metadataChange == null) {
            int numItems = this.previousContent.hasDigest() || this.laterContent.hasDigest() ? 2 : 1;
            this.metadataChange = new IContentMetadataItemChange[numItems];
            this.metadataChange[0] = new SimpleContentMetadataItemChange("File Size", Long.toString(this.previousContent.getSize()), Long.toString(this.laterContent.getSize()));
            if (numItems == 2) {
                String previous = "";
                String later = "";
                if (this.previousContent.hasDigest()) {
                    previous = MD5.asHex(this.previousContent.getDigest());
                }
                if (this.laterContent.hasDigest()) {
                    later = MD5.asHex(this.laterContent.getDigest());
                }
                this.metadataChange[1] = new SimpleContentMetadataItemChange("Digest", previous, later);
            }
        }
        return this.metadataChange;
    }

    @Override
    public IContent getPreviousContent() {
        return this.previousContent;
    }

    @Override
    public IContent getLaterContent() {
        return this.laterContent;
    }

    @Override
    public long getChangeDetectionTime() {
        return this.changeDetectionTime;
    }
}

