/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.utils;

public final class HashCodeUtils {
    private HashCodeUtils() {
    }

    public static int hashBoolean(boolean b) {
        return b ? 0 : 1;
    }

    public static int hashByte(byte input) {
        return input;
    }

    public static int hashChar(char input) {
        return input;
    }

    public static int hashShort(short input) {
        return input;
    }

    public static int hashInt(int input) {
        return input;
    }

    public static int hashLong(long input) {
        return (int)(input ^ input >>> 32);
    }

    public static int hashFloat(float f) {
        return Float.floatToIntBits(f);
    }

    public static int hashDouble(double d) {
        return HashCodeUtils.hashLong(Double.doubleToLongBits(d));
    }

    public static int hashObject(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int accumulateHashCode(int hashSoFar, int newComponent) {
        return 37 * hashSoFar + newComponent;
    }

    public static int accumulateHashCode(int hashSoFar, Object o) {
        return 37 * hashSoFar + HashCodeUtils.hashObject(o);
    }

    public static int accumulateHashCode(int hashSoFar, boolean b) {
        return 37 * hashSoFar + HashCodeUtils.hashBoolean(b);
    }

    public static int accumulateHashCode(int hashSoFar, byte b) {
        return 37 * hashSoFar + HashCodeUtils.hashByte(b);
    }

    public static int accumulateHashCode(int hashSoFar, short s) {
        return 37 * hashSoFar + HashCodeUtils.hashShort(s);
    }

    public static int accumulateHashCode(int hashSoFar, char c) {
        return 37 * hashSoFar + HashCodeUtils.hashChar(c);
    }

    public static int accumulateHashCode(int hashSoFar, long l) {
        return 37 * hashSoFar + HashCodeUtils.hashLong(l);
    }

    public static int accumulateHashCode(int hashSoFar, float f) {
        return 37 * hashSoFar + HashCodeUtils.hashFloat(f);
    }

    public static int accumulateHashCode(int hashSoFar, double d) {
        return 37 * hashSoFar + HashCodeUtils.hashDouble(d);
    }
}

