/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.utils;

import com.wily.rave.utils.CustomClassLoaderObjectInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PersistentState {
    private static final String kWriteExtension = ".tmp";
    private static final String kScratchExtension = ".bak";
    private final String fPath;
    private final String fName;

    public PersistentState(String path, String name, boolean keepNonCommittedWrites) throws IOException {
        this.fPath = path;
        this.fName = name;
        File dataFile = this.getFile();
        File scratchFile = this.getScratchFile();
        File writeFile = this.getWriteFile();
        if (writeFile.exists()) {
            if (scratchFile.exists()) {
                if (!writeFile.delete()) {
                    throw new IOException("Failed deleting file: " + scratchFile.getAbsolutePath());
                }
            } else if (!writeFile.renameTo(scratchFile)) {
                throw new IOException("Failed renaming file: " + writeFile.getAbsolutePath());
            }
        }
        if (scratchFile.exists()) {
            if (dataFile.exists()) {
                if (!keepNonCommittedWrites && !scratchFile.delete()) {
                    throw new IOException("Failed deleting file: " + scratchFile.getAbsolutePath());
                }
            } else if (!scratchFile.renameTo(dataFile)) {
                throw new IOException("Failed renaming file: " + scratchFile.getAbsolutePath());
            }
        } else if (!dataFile.exists() && !dataFile.createNewFile()) {
            throw new IOException("Failed creating empty file: " + dataFile.getCanonicalPath());
        }
    }

    public static boolean exists(String path, String name) {
        return new File(path, name).exists();
    }

    public boolean isDirty() {
        return this.getScratchFile().exists();
    }

    public Serializable read() throws IOException {
        Serializable state;
        File stateFile = this.getFile();
        if (stateFile.length() == 0L) {
            return null;
        }
        FileInputStream fis = new FileInputStream(stateFile);
        try {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(fis);
            }
            catch (EOFException eOFException) {
                fis.close();
                return null;
            }
            try {
                state = (Serializable)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            fis.close();
        }
        return state;
    }

    public Serializable read2(ClassLoader dsCl) throws IOException {
        Serializable state;
        File stateFile = this.getFile();
        if (stateFile.length() == 0L) {
            return null;
        }
        FileInputStream fis = new FileInputStream(stateFile);
        try {
            CustomClassLoaderObjectInputStream pois = null;
            try {
                pois = new CustomClassLoaderObjectInputStream(dsCl, fis);
            }
            catch (EOFException eOFException) {
                fis.close();
                return null;
            }
            try {
                state = (Serializable)pois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            fis.close();
        }
        return state;
    }

    public void rollBack() throws IOException {
        File scratchFile = this.getScratchFile();
        if (scratchFile.exists() && !scratchFile.delete()) {
            throw new IOException("Failed deleting file: " + scratchFile.getAbsolutePath());
        }
        File writeFile = this.getWriteFile();
        if (writeFile.exists() && !writeFile.delete()) {
            throw new IOException("Failed deleting file: " + writeFile.getAbsolutePath());
        }
    }

    public void writeAndCommit(Serializable state) throws IOException {
        this.write(state);
        this.commit();
    }

    public void write(Serializable state) throws IOException {
        File writeFile = this.getWriteFile();
        FileOutputStream fos = new FileOutputStream(this.getWriteFile());
        try {
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(state);
        }
        finally {
            fos.close();
        }
        this.commitFile(this.getScratchFile(), writeFile);
    }

    private void commitFile(File target, File source) throws IOException {
        if (target.exists() && !target.delete()) {
            throw new IOException("Failed deleting file: " + target.getAbsolutePath());
        }
        if (!source.renameTo(target)) {
            throw new IOException("Failed renaming file: " + source.getAbsolutePath());
        }
    }

    public void commit() throws IOException {
        if (!this.isDirty()) {
            throw new IOException("Cannot commit before write!");
        }
        this.commitFile(this.getFile(), this.getScratchFile());
    }

    private File getFile() {
        return new File(this.fPath, this.fName);
    }

    private File getScratchFile() {
        return new File(this.fPath, String.valueOf(this.fName) + kScratchExtension);
    }

    private File getWriteFile() {
        return new File(this.fPath, String.valueOf(this.fName) + kWriteExtension);
    }

    public void destroy() {
        boolean fail;
        boolean bl = fail = !(this.getFile().exists() && !this.getFile().delete() || this.getScratchFile().exists() && !this.getScratchFile().delete() || this.getWriteFile().exists() && !this.getWriteFile().delete());
        if (!fail) {
            throw new RuntimeException("Failed deleting persistent state file(s)");
        }
    }
}

