/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import java.util.Arrays;

public final class WilyStringBuilder {
    private static final int DEFAULT_CAPACITY = 16;
    private static final int NOT_FOUND = -1;
    private char[] contents;
    private int length = 0;

    public WilyStringBuilder() {
        this(16);
    }

    public WilyStringBuilder(int capacity) {
        this.contents = new char[capacity];
    }

    public WilyStringBuilder(String str) {
        this.length = str.length();
        this.contents = new char[this.length + 16];
        str.getChars(0, this.length, this.contents, 0);
    }

    public int capacity() {
        return this.contents.length;
    }

    public WilyStringBuilder append(String str) {
        String stringToAppend = str == null ? "null" : str;
        int nCharsToAppend = stringToAppend.length();
        int newLength = this.length + nCharsToAppend;
        this.ensureCapacity(newLength);
        stringToAppend.getChars(0, nCharsToAppend, this.contents, this.length);
        this.length = newLength;
        return this;
    }

    public WilyStringBuilder append(char c) {
        this.ensureCapacity(this.length + 1);
        this.contents[this.length++] = c;
        return this;
    }

    public WilyStringBuilder append(int i) {
        return this.append(String.valueOf(i));
    }

    public WilyStringBuilder replace(int start, int end, String str) {
        int nCharsToMove;
        if (start < 0) {
            throw new StringIndexOutOfBoundsException("start < 0");
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (start > this.length) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        int nCharsToInsert = str.length();
        int realEnd = Math.min(this.length, end);
        int lengthChange = -(realEnd - start) + nCharsToInsert;
        int newLength = this.length + lengthChange;
        this.ensureCapacity(newLength);
        if (lengthChange != 0 && (nCharsToMove = this.length - realEnd) > 0) {
            System.arraycopy(this.contents, realEnd, this.contents, start + nCharsToInsert, nCharsToMove);
        }
        str.getChars(0, nCharsToInsert, this.contents, start);
        this.length = newLength;
        return this;
    }

    public int length() {
        return this.length;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity <= this.contents.length) {
            return;
        }
        int newCapacity = Math.max(minimumCapacity, this.contents.length * 2 + 2);
        char[] newContents = new char[newCapacity];
        System.arraycopy(this.contents, 0, newContents, 0, this.length);
        this.contents = newContents;
    }

    public void setLength(int newLength) {
        if (newLength > this.length) {
            this.ensureCapacity(newLength);
            Arrays.fill(this.contents, this.length, newLength, '\u0000');
        }
        this.length = newLength;
    }

    public WilyStringBuilder setString(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.length = 0;
        int newLength = str.length();
        this.ensureCapacity(newLength);
        str.getChars(0, newLength, this.contents, 0);
        this.length = newLength;
        return this;
    }

    public int indexOf(char[] str) {
        if (str == null) {
            throw new NullPointerException();
        }
        if (str.length == 0) {
            return 0;
        }
        if (str.length > this.length) {
            return -1;
        }
        int maxIndex = this.length - str.length + 1;
        int i = 0;
        while (i < maxIndex) {
            if (this.contents[i] == str[0]) {
                boolean found = true;
                int j = 1;
                while (j < str.length) {
                    if (this.contents[i + j] != str[j]) {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        return new String(this.contents, 0, this.length);
    }
}

