/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Array;

public class Queue {
    public static final String kQueueLogGrowth = "com.wily.util.adt.Queue.log.growth";
    public static final String kQueueLogShrink = "com.wily.util.adt.Queue.log.shrink";
    private final IModuleFeedbackChannel fFeedback;
    private QueueNode fHead;
    private QueueNode fTail;
    private volatile int fSize;
    private final String fName;
    private QueueNode fFree;
    private static final int kDefaultLogGrowthInterval = 250;
    private static final int kDefaultLogShrinkInterval = 250;
    private boolean fLogGrowthEnabled;
    private int fLogGrowthInterval;
    private String fLogGrowthMessage;
    private int fLogGrowthLastReportedSize;
    private boolean fLogShrinkEnabled;
    private int fLogShrinkInterval;
    private String fLogShrinkMessage;
    private int fLogShrinkLastReportedSize;

    public Queue(String name, IModuleFeedbackChannel feedback) {
        this.fName = name;
        this.fFeedback = feedback;
        this.fLogGrowthEnabled = false;
        this.fLogShrinkEnabled = false;
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public String getName() {
        return this.fName;
    }

    public synchronized boolean enqueue(Object data) {
        QueueNode node = null;
        if (this.fFree != null) {
            node = this.fFree;
            node.fNext = null;
            this.fFree = this.fFree.fNext;
        } else {
            node = new QueueNode(data);
        }
        node.fData = data;
        if (this.fTail != null) {
            this.fTail.fNext = node;
        }
        this.fTail = node;
        ++this.fSize;
        if (this.fHead == null) {
            this.fHead = node;
        }
        if (this.fLogGrowthEnabled) {
            this.logGrowth();
        }
        return true;
    }

    public synchronized Object dequeue() throws InterruptedException {
        if (this.fHead == null) {
            return null;
        }
        Object data = this.fHead.fData;
        this.fHead.fData = null;
        QueueNode temp = this.fHead;
        this.fHead = this.fHead.fNext;
        temp.fNext = this.fFree;
        this.fFree = temp;
        --this.fSize;
        if (this.fHead == null) {
            this.fTail = null;
        }
        if (this.fLogShrinkEnabled) {
            this.logShrink();
        }
        return data;
    }

    public synchronized Object[] dequeueToArray(Object[] candidateArray) {
        Object[] result = (Object[])Array.newInstance(candidateArray.getClass().getComponentType(), this.fSize);
        int index = 0;
        QueueNode tmp = this.fHead;
        QueueNode oldHead = this.fHead;
        while (tmp != null) {
            oldHead = tmp;
            tmp = tmp.fNext;
            result[index++] = oldHead.fData;
            oldHead.fNext = null;
            oldHead.fData = null;
        }
        this.fHead = null;
        this.fTail = null;
        this.fSize = 0;
        return result;
    }

    public synchronized Object peek() {
        if (this.fHead != null) {
            return this.fHead.fData;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.fSize == 0;
    }

    public int size() {
        return this.fSize;
    }

    public synchronized void removeAllElements() {
        QueueNode tmp = this.fHead;
        while (tmp != null) {
            this.fHead = tmp;
            tmp = tmp.fNext;
            this.fHead.fNext = null;
            this.fHead.fData = null;
        }
        this.fHead = null;
        this.fTail = null;
        this.fSize = 0;
    }

    public synchronized void copyInto(Object[] targetArray) {
        int counter = 0;
        QueueNode walker = this.fHead;
        while (walker != null) {
            targetArray[counter++] = walker.fData;
            walker = walker.fNext;
        }
    }

    public synchronized void setDebuggingFeature(String whichFeature, String logMessage, Object parameter) {
        try {
            if (whichFeature.equals(kQueueLogGrowth)) {
                this.setLogGrowth(logMessage, parameter);
            } else if (whichFeature.equals(kQueueLogShrink)) {
                this.setLogShrink(logMessage, parameter);
            }
        }
        catch (Throwable throwable) {}
    }

    private synchronized void setLogGrowth(String message, Object parameter) {
        int growthInterval = (Integer)parameter;
        this.fLogGrowthEnabled = true;
        this.fLogGrowthMessage = message == null ? "growth interval: " : message;
        this.fLogGrowthInterval = growthInterval == 0 ? 250 : growthInterval;
        this.getModuleFeedback().info(String.valueOf(this.getName()) + " configured " + this.fLogGrowthMessage + " to " + this.fLogGrowthInterval);
    }

    private synchronized void setLogShrink(String message, Object parameter) {
        int shrinkInterval = (Integer)parameter;
        this.fLogShrinkEnabled = true;
        this.fLogShrinkMessage = message == null ? "shrink interval: " : message;
        this.fLogShrinkInterval = shrinkInterval == 0 ? 250 : shrinkInterval;
        this.getModuleFeedback().info(String.valueOf(this.getName()) + " configured " + this.fLogShrinkMessage + " to " + this.fLogShrinkInterval);
    }

    private void logGrowth() {
        int currentSize = this.size();
        if (currentSize % this.fLogGrowthInterval == 0 && currentSize != this.fLogGrowthLastReportedSize) {
            this.fLogGrowthLastReportedSize = currentSize;
            this.getModuleFeedback().info(String.valueOf(this.getName()) + " " + this.fLogGrowthMessage + " " + currentSize);
        }
    }

    private void logShrink() {
        int currentSize = this.size();
        if (currentSize % this.fLogShrinkInterval == 0 && currentSize != this.fLogShrinkLastReportedSize) {
            this.fLogShrinkLastReportedSize = currentSize;
            this.getModuleFeedback().info(String.valueOf(this.getName()) + " " + this.fLogShrinkMessage + " " + currentSize);
        }
        if (currentSize == 0) {
            this.fLogGrowthLastReportedSize = 0;
        }
    }

    private static final class QueueNode {
        public Object fData;
        public QueueNode fNext;

        public QueueNode(Object data) {
            this.fData = data;
        }
    }
}

