/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.adt.AttributesStringDictionaryReader;
import com.wily.util.adt.IStringDictionaryReader;
import com.wily.util.extension.AExtension;
import com.wily.util.extension.EagerAllPermissionsClassLoader;
import com.wily.util.extension.ExtensionStringLocalizer;
import com.wily.util.extension.IJarFile;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.JarURLPhysicalModule;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class JarExtension
extends AExtension {
    private static final String kAspectJarDefaultName = "aspect" + File.separatorChar + "WilyPerstAspects.jar";
    private static final Class[] kClassLoaderParameterTypes = new Class[]{URL[].class, ClassLoader.class};
    private final IModuleFeedbackChannel fFeedback;
    private final ExtendedFile fTargetFile;
    private final JarURLPhysicalModule fJarModule;
    private final Attributes fMainAttributes;
    private final IStringDictionaryReader fAttributesReader;
    private ClassLoader fClassLoader;
    private final String fName;
    private String fClassloaderKey;
    private String fType;
    private final List fDependencies;
    private final int fVersion;
    private MultipleResourceBundleStringLocalizer fExtensionLocalizer;
    private final List fPluginList;
    private int fSortRank;

    public JarExtension(String name, String[] dependencies, IModuleFeedbackChannel feedback, ExtendedFile target) throws InvalidExtensionException {
        Assertion.wilyAssert(target != null);
        this.fFeedback = feedback;
        this.fTargetFile = target;
        this.fName = name;
        this.fDependencies = Arrays.asList(dependencies);
        try {
            this.fJarModule = new JarURLPhysicalModule(this.fTargetFile.toURL());
        }
        catch (IOException iOException) {
            throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
        }
        this.fMainAttributes = this.fJarModule.getManifest().getMainAttributes();
        try {
            this.fMainAttributes.putValue("com-wily-Extension-Location", target.getCanonicalPath());
        }
        catch (IOException iOException) {}
        super.initialize(this.fTargetFile.getAbsolutePath(), this.fMainAttributes);
        this.fAttributesReader = new AttributesStringDictionaryReader(this.fMainAttributes);
        this.fClassloaderKey = this.getMainAttributeValue("com-wily-Extension-Classloader-Key");
        try {
            this.fType = this.getMainAttributeValueOrThrow("com-wily-Extension-Type");
        }
        catch (InvalidExtensionException e) {
            boolean eclipsePlugin;
            boolean bl = eclipsePlugin = this.getMainAttributeValue("Bundle-SymbolicName") != null || this.getMainAttributeValue("Bundle-Name") != null;
            if (eclipsePlugin) {
                this.fType = "Eclipse-Plugin";
                if (this.fClassloaderKey == null) {
                    this.fClassloaderKey = this.fName;
                }
            }
            throw e;
        }
        if ("Eclipse-Plugin".equals(this.fType)) {
            this.fVersion = 1;
            this.fPluginList = Collections.EMPTY_LIST;
        } else {
            this.fVersion = this.getValidatedVersion();
            this.fPluginList = this.buildPluginList(this, this.getMainAttributeValueOrThrow("com-wily-Extension-Plugins-List"));
        }
        if (this.fClassloaderKey == null) {
            this.fClassloaderKey = "";
        }
        this.getFeedback().debug("candidate jar file " + this.fTargetFile.getAbsolutePath() + " is an extension");
    }

    private ClassLoader createWeavingClassLoader(ClassLoader parent) throws InvalidExtensionException {
        URL[] classpath;
        String aspectJarLoc = (String)this.fMainAttributes.get("com-wily-Extension-AspectJar");
        File aspectJar = null;
        if (!(aspectJarLoc == null || aspectJarLoc.equals("") || aspectJarLoc.equals("default") || (aspectJar = new File(this.fTargetFile.getParentFile(), aspectJarLoc)).exists())) {
            aspectJar = null;
        }
        if (aspectJar == null) {
            aspectJar = new File(this.fTargetFile.getParentFile(), kAspectJarDefaultName);
        }
        try {
            classpath = new URL[]{aspectJar.toURL(), this.fTargetFile.toURL()};
        }
        catch (IOException iOException) {
            throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
        }
        try {
            Class<?> clsLoader = Class.forName("com.wily.persistence.perst.DelegatingNamedClassLoader");
            Constructor<?> constructor = clsLoader.getConstructor(String.class, URL[].class, ClassLoader.class);
            return (ClassLoader)constructor.newInstance(this.fName, classpath, parent);
        }
        catch (Exception e) {
            this.fFeedback.error("Failed creating weaving classloader!", e);
            throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
        }
    }

    private ClassLoader createClassLoader(URL[] classpath, ClassLoader parent) {
        ClassLoader result = this.createCustomClassLoader(classpath, parent);
        if (result == null) {
            result = new AllPermissionsClassLoader(classpath, parent);
        }
        return result;
    }

    private ClassLoader createEagerClassLoader(URL[] classpath, ClassLoader parent) {
        if (EagerAllPermissionsClassLoader.sIsEagerClassLoaderEnabled) {
            EagerAllPermissionsClassLoader el = new EagerAllPermissionsClassLoader(classpath, parent, this.fTargetFile, this.fFeedback);
            el.preLoadClasses();
            return el;
        }
        return new AllPermissionsClassLoader(classpath, parent);
    }

    private ClassLoader createCustomClassLoader(URL[] classpath, ClassLoader parent) {
        ClassLoader loader = null;
        String loaderPath = System.getProperty("com.wily.extension.classloader", this.getMainAttributeValue("com-wily-Extension-ClassLoader"));
        if (loaderPath != null) {
            try {
                Class<?> loaderClass = Class.forName(loaderPath, true, parent);
                Constructor<?> constructor = loaderClass.getConstructor(kClassLoaderParameterTypes);
                Object[] arguments = new Object[]{classpath, parent};
                loader = (ClassLoader)constructor.newInstance(arguments);
                this.getFeedback().info("Created loader");
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                this.getFeedback().verbose(t);
            }
            catch (Throwable t) {
                this.getFeedback().verbose(t);
            }
        }
        return loader;
    }

    private IJarFile getJarFile() {
        return new IJarFile(){

            @Override
            public InputStream getInputStream(String entryName) throws IOException {
                JarURLConnection connection = (JarURLConnection)JarExtension.this.fJarModule.getURL().openConnection();
                ZipEntry jarEntry = connection.getJarFile().getEntry(entryName);
                if (jarEntry == null) {
                    throw new IOException("Unable to find entry " + entryName);
                }
                return connection.getJarFile().getInputStream(jarEntry);
            }

            @Override
            public Attributes getMainAttributes() {
                return JarExtension.this.fJarModule.getManifest().getMainAttributes();
            }
        };
    }

    @Override
    public void IExtension_setParentClassLoader(ClassLoader parentClassLoader) throws InvalidExtensionException {
        parentClassLoader = JarURLPhysicalModule.getBundleClassLoaders(this.fFeedback, parentClassLoader, this.getJarFile());
        if (this.fMainAttributes.containsKey(new Attributes.Name("com-wily-Extension-AspectJar"))) {
            this.fClassLoader = this.createWeavingClassLoader(parentClassLoader);
        } else {
            URL[] classpathArray = null;
            try {
                classpathArray = this.getRecursiveUniqueClassPath(this.fJarModule.getURL());
            }
            catch (IOException iOException) {
                throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
            }
            String classLoaderString = this.getMainAttributeValue("com-wily-Extension-ClassLoader");
            this.fClassLoader = classLoaderString != null && classLoaderString.equalsIgnoreCase("Eager") ? this.createEagerClassLoader(classpathArray, parentClassLoader) : this.createClassLoader(classpathArray, parentClassLoader);
        }
        this.fExtensionLocalizer = this.buildStringLocalizer(this.fFeedback, this.fClassLoader, this.getMainAttributeValue("com-wily-Extension-Localized-Resource-List"));
    }

    @Override
    public ClassLoader IExtension_getClassLoader() {
        return this.getExtensionClassLoader();
    }

    @Override
    public IPlugin[] IExtension_getFilteredPluginList(String pluginFilter) {
        return this.getFilteredPluginList(this.fPluginList, pluginFilter);
    }

    @Override
    public String IExtension_getName() {
        return this.fName;
    }

    @Override
    public String IExtension_getClassloaderKey() {
        return this.fClassloaderKey;
    }

    @Override
    public int IExtension_getVersion() {
        return this.fVersion;
    }

    @Override
    public String IExtension_getSource() {
        return this.fTargetFile.safeGetCanonicalPath();
    }

    @Override
    public IStringLocalizer IExtension_getStringLocalizer(IStringLocalizer fallback) {
        return new ExtensionStringLocalizer(this.fExtensionLocalizer, fallback);
    }

    @Override
    public String IExtension_getType() {
        return this.fType;
    }

    @Override
    public String[] IExtension_getDependencies() {
        return this.fDependencies.toArray(new String[0]);
    }

    @Override
    public IStringDictionaryReader IExtension_getAttributes() {
        return this.fAttributesReader;
    }

    private IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    Map getMainAttributes() {
        return this.fMainAttributes;
    }

    private ClassLoader getExtensionClassLoader() {
        Assertion.wilyAssert(this.fClassLoader != null);
        return this.fClassLoader;
    }

    private final URL[] getRecursiveUniqueClassPath(URL selfURL) throws IOException, MalformedURLException {
        ArrayList<URL> deepResultList = new ArrayList<URL>();
        Stack<URL> stack = new Stack<URL>();
        stack.push(selfURL);
        while (!stack.empty()) {
            URL jarFile = (URL)stack.pop();
            if (!deepResultList.contains(jarFile)) {
                boolean fileExists = true;
                URL[] cp = null;
                try {
                    cp = new JarURLPhysicalModule(jarFile).getClassPath();
                }
                catch (ZipException zipException) {
                    fileExists = false;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileExists = false;
                }
                if (!fileExists) continue;
                deepResultList.add(jarFile);
                int y = 0;
                while (y < cp.length) {
                    if (!deepResultList.contains(cp[y])) {
                        stack.push(cp[y]);
                    }
                    ++y;
                }
                continue;
            }
            this.fFeedback.warn("Cannot locate manifest class path entry " + jarFile.getFile() + " for extension located at " + this.fTargetFile.getAbsolutePath());
        }
        return deepResultList.toArray(new URL[deepResultList.size()]);
    }

    @Override
    public String ITopologicalSortNode_getId() {
        return this.IExtension_getName();
    }

    @Override
    public String[] ITopologicalSort_getDependencies() {
        return this.IExtension_getDependencies();
    }

    @Override
    public int ITopologicalSort_getRank() {
        return this.fSortRank;
    }

    @Override
    public void ITopologicalSort_setRank(int v) {
        this.fSortRank = v;
    }

    @Override
    public void IExtension_unload() {
        this.unloadPlugins(this.fPluginList);
        this.unload();
        try {
            this.fJarModule.close();
        }
        catch (IOException iOException) {}
        if (this.fClassLoader instanceof Closeable) {
            try {
                this.fFeedback.info("Closing class loader for extension: " + this.IExtension_getName());
                ((Closeable)((Object)this.fClassLoader)).close();
            }
            catch (IOException iOException) {
                this.fFeedback.warn("Cannot close class loader for extension: " + this.IExtension_getName());
            }
        }
        if (this.fClassLoader instanceof EagerAllPermissionsClassLoader) {
            try {
                this.fFeedback.info("Closing eager class loader for extension: " + this.IExtension_getName());
                ((EagerAllPermissionsClassLoader)this.fClassLoader).closeInternal();
            }
            catch (IOException iOException) {
                this.fFeedback.warn("Cannot close eager class loader for extension: " + this.IExtension_getName());
            }
        }
        this.fClassLoader = null;
        System.gc();
    }

    @Override
    public void IExtension_load() {
        this.load();
        this.loadPlugins(this.fPluginList);
    }

    public static class AllPermissionsClassLoader
    extends URLClassLoader {
        public volatile Class hackClass;
        public volatile Class hackClassServlet;
        public volatile Class hackClassServletConfig;
        public volatile Class hackClassServletContext;
        public volatile Class hackHttpSession;
        private volatile WeakReference helperClassLoaderRef = null;
        private static final Permissions permissions = new Permissions();

        static {
            permissions.add(new AllPermission());
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            ClassLoader helper;
            if (name.equals("javax.servlet.http.HttpServletRequest") && this.hackClass != null) {
                return this.hackClass;
            }
            if (name.equals("javax.servlet.Servlet") && this.hackClassServlet != null) {
                return this.hackClassServlet;
            }
            if (name.equals("javax.servlet.ServletConfig") && this.hackClassServletConfig != null) {
                return this.hackClassServletConfig;
            }
            if (name.equals("javax.servlet.ServletContext") && this.hackClassServletContext != null) {
                return this.hackClassServletContext;
            }
            if (name.equals("javax.servlet.http.HttpSession") && this.hackHttpSession != null) {
                return this.hackHttpSession;
            }
            Class<?> clazz = null;
            try {
                clazz = this.findUsingParent(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (clazz != null) {
                return clazz;
            }
            if (this.helperClassLoaderRef != null && (helper = (ClassLoader)this.helperClassLoaderRef.get()) != null && (clazz = helper.loadClass(name)) != null) {
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }

        protected Class findUsingParent(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        public void setHelperClassLoader(ClassLoader helperCL) {
            this.helperClassLoaderRef = new WeakReference<ClassLoader>(helperCL);
        }

        public AllPermissionsClassLoader(URL[] classpath, ClassLoader parent) {
            super(classpath, parent);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            return permissions;
        }
    }
}

