/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.validate;

import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.TextUtilities;
import com.wily.util.validate.IdentifiableObjectValidationException;

public class ValidationInvalidBoundedNumberException
extends IdentifiableObjectValidationException {
    private static final long serialVersionUID = -8939291254089741778L;
    private long fMin;
    private long fMax;

    public ValidationInvalidBoundedNumberException(long min, long max) {
        this.fMin = min;
        this.fMax = max;
    }

    public ValidationInvalidBoundedNumberException(ILocalizableMessage invalidObjectIdentifier, long min, long max) {
        super(invalidObjectIdentifier);
        this.fMin = min;
        this.fMax = max;
    }

    @Override
    public ILocalizableMessage getInvalidObjectRequiredCondition() {
        String minMessage = TextUtilities.getFormattedNumber(this.getMin());
        String maxMessage = TextUtilities.getFormattedNumber(this.getMax());
        return new FormattedLocalizableMessage("Validation_Invalid_Bounded_Long_Condition", minMessage, maxMessage);
    }

    protected long getMin() {
        return this.fMin;
    }

    protected long getMax() {
        return this.fMax;
    }
}

