/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.introscope.agent.environment.IAppserverEnvironmentInfoCallback;
import com.wily.soaextension.tibcobw.BWNameService;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BWAgentNamer
implements ITimestampedRunnable,
IAppserverEnvironmentInfoCallback {
    private final IAgent agent;
    private static boolean agentNameFound = false;
    Module module;
    String newAgentName = "";
    private static final String C_engine = "com.tibco.pe.core.Engine";
    private static final String F_props = "props";
    private static final String M_getString = "getString";
    private static final String P_name = "name";
    private static final String P_domain = "tibco.domain";
    private static final String P_deployment = "tibco.deployment";
    private static final String _seperator = "_";

    public BWAgentNamer(IAgent agent) {
        this.agent = agent;
        this.module = new Module("TibcoBW");
    }

    public void ITimestampedRunnable_execute(long arg0) {
        String domainName = null;
        String argumentName = null;
        String deploymentName = null;
        if (agentNameFound && BWNameService.tibcoNameBehavior != null) {
            this.agent.IAgent_getCommonHeartbeat().removeBehavior(BWNameService.tibcoNameBehavior);
        } else {
            try {
                Class<?> engineClass = Class.forName(C_engine, false, ClassLoader.getSystemClassLoader());
                if (engineClass != null) {
                    Field enginePropertiesField = engineClass.getField(F_props);
                    enginePropertiesField.setAccessible(true);
                    Object engineProperties = enginePropertiesField.get(null);
                    if (engineProperties != null) {
                        Method getProperyMethod = engineProperties.getClass().getMethod(M_getString, String.class);
                        domainName = this.extractDomainName(engineProperties, getProperyMethod);
                        StringBuffer buff = new StringBuffer();
                        if (domainName != null) {
                            buff.append(domainName);
                            argumentName = this.extractNameArgument(engineProperties, getProperyMethod);
                            deploymentName = this.extractDeploymentName(engineProperties, getProperyMethod);
                            if (argumentName != null) {
                                buff.append(_seperator);
                                buff.append(argumentName);
                            } else if (deploymentName != null) {
                                buff.append(_seperator);
                                buff.append(deploymentName);
                            }
                            this.newAgentName = buff.toString();
                        } else {
                            this.agent.IAgent_getModuleFeedback().debug(this.module, "BWAgentNamer - Tibco Domain Name not found.");
                            argumentName = this.extractNameArgument(engineProperties, getProperyMethod);
                            deploymentName = this.extractDeploymentName(engineProperties, getProperyMethod);
                            if (argumentName != null) {
                                buff.append(argumentName);
                            } else if (deploymentName != null) {
                                buff.append(deploymentName);
                            }
                        }
                        this.newAgentName = buff.toString();
                        buff = null;
                        agentNameFound = true;
                        this.agent.IAgent_getModuleFeedback().debug(this.module, "BWAgentNamer - Agent Name Found.");
                    }
                } else {
                    this.agent.IAgent_getModuleFeedback().debug(this.module, "WAITING_FOR_ENGINECLASS");
                }
            }
            catch (Throwable bomb) {
                this.agent.IAgent_getModuleFeedback().error(this.module, "ERROR_IN_BW_DEPLOYMENT_INFO", bomb);
            }
        }
    }

    public String IAppserverEnvironmentInfoCallback_getAgentName() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        this.agent.IAgent_getModuleFeedback().debug(this.module, "BWAgentNamer.getAgentName: " + this.newAgentName);
        return this.newAgentName;
    }

    private String extractNameArgument(Object engineProperties, Method getProperyMethod) throws IllegalAccessException, InvocationTargetException {
        String argumentName = (String)getProperyMethod.invoke(engineProperties, P_name);
        return argumentName;
    }

    private String extractDeploymentName(Object engineProperties, Method getProperyMethod) throws IllegalAccessException, InvocationTargetException {
        String deploymentName = (String)getProperyMethod.invoke(engineProperties, P_deployment);
        return deploymentName;
    }

    private String extractDomainName(Object engineProperties, Method getProperyMethod) throws IllegalAccessException, InvocationTargetException {
        String domainName = (String)getProperyMethod.invoke(engineProperties, P_domain);
        return domainName;
    }
}

