/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.acc.common;

import com.ca.apm.acc.common.ACCMessage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ACCByteMessage
extends ACCMessage
implements Externalizable {
    private byte[] data;
    private String pluginResponseFileName;
    private long pluginResponseFileTime;
    private long pluginResponseFileSize;
    private String pluginEncoding;
    private String pluginException;

    public ACCByteMessage() {
    }

    public ACCByteMessage(byte[] data) {
        this.data = data;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.fetchBodyLength());
        out.write(this.data, 0, this.fetchBodyLength());
        out.writeObject(this.pluginResponseFileName);
        out.writeLong(this.pluginResponseFileTime);
        out.writeLong(this.pluginResponseFileSize);
        out.writeObject(this.pluginEncoding);
        out.writeObject(this.pluginException);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int len = in.readInt();
        this.data = new byte[len];
        in.readFully(this.data, 0, len);
        this.pluginResponseFileName = (String)in.readObject();
        this.pluginResponseFileTime = in.readLong();
        this.pluginResponseFileSize = in.readLong();
        this.pluginEncoding = (String)in.readObject();
        this.pluginException = (String)in.readObject();
    }

    private int fetchBodyLength() {
        int len = 0;
        if (this.data != null) {
            len = this.data.length;
        }
        return len;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getPluginResponseFileName() {
        return this.pluginResponseFileName;
    }

    public void setPluginResponseFileName(String pluginResponseFileName) {
        this.pluginResponseFileName = pluginResponseFileName;
    }

    public long getPluginResponseFileTime() {
        return this.pluginResponseFileTime;
    }

    public void setPluginResponseFileTime(long pluginResponseFileTime) {
        this.pluginResponseFileTime = pluginResponseFileTime;
    }

    public long getPluginResponseFileSize() {
        return this.pluginResponseFileSize;
    }

    public void setPluginResponseFileSize(long pluginResponseFileSize) {
        this.pluginResponseFileSize = pluginResponseFileSize;
    }

    public String getPluginEncoding() {
        return this.pluginEncoding;
    }

    public void setPluginEncoding(String pluginEncoding) {
        this.pluginEncoding = pluginEncoding;
    }

    public String getPluginException() {
        return this.pluginException;
    }

    public void setPluginException(String pluginException) {
        this.pluginException = pluginException;
    }
}

