/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;

public class DGAnnotationClassMatcher
extends AImmutableClassMatcher {
    private final IClassName fClassName;

    public DGAnnotationClassMatcher(IClassName className) {
        this.fClassName = className;
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        boolean result = cls.containsAnnotation(this.fClassName);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setAnnotationName(this.fClassName.getContainerAndPackageAndNameString());
            current.setComment("DGAnnotationClassMatcher detected the annotation name as annotation in the modelled class");
            current.setSkipCause(256);
        }
        return result;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        return false;
    }

    public IClassName getClassName() {
        return this.fClassName;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode(result, this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGAnnotationClassMatcher) {
            DGAnnotationClassMatcher m = (DGAnnotationClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return new String[]{CompilerSettingsUtility.getKeyFromString(this.fClassName.getReflectionFriendlyQualifiedNameString())};
    }
}

