/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.IPlaceHolderResolver;

public class APlaceHolderResolver
implements IPlaceHolderResolver {
    private static String fCachedJVMCompatibleVersionForSocket = null;
    private static APlaceHolderResolver kInstance = new APlaceHolderResolver();

    public static APlaceHolderResolver getInstance() {
        return kInstance;
    }

    public int getPlaceHolderType(String name) {
        if (name.indexOf("${JVMCOMPATIBILITY}") != -1) {
            return 1;
        }
        if (name.indexOf("${JVMVERSION}") != -1) {
            return 2;
        }
        return -1;
    }

    @Override
    public String resolveJVMCompatibility(String name) {
        boolean isSocketRelated = name.toLowerCase().indexOf("socket") != -1;
        String javaVersion = System.getProperty("java.version");
        if (isSocketRelated) {
            return this.resolveJVMCompatibiltyForSocket(javaVersion);
        }
        return this._resolveJVMCompatibilty(javaVersion);
    }

    private String _resolveJVMCompatibilty(String javaVersion) {
        try {
            String[] version = javaVersion.split("\\.");
            if (Integer.parseInt(version[1]) >= 5) {
                return version[1];
            }
            return "6";
        }
        catch (NumberFormatException numberFormatException) {
            return "6";
        }
    }

    private String resolveJVMCompatibiltyForSocket(String javaVersion) {
        if (fCachedJVMCompatibleVersionForSocket == null) {
            String vmName;
            int version = Integer.parseInt(this._resolveJVMCompatibilty(javaVersion));
            fCachedJVMCompatibleVersionForSocket = version >= 7 ? "7" : (version == 6 ? ((vmName = System.getProperty("java.vm.name")).indexOf("OpenJDK") != -1 ? "7" : "6") : "6");
        }
        return fCachedJVMCompatibleVersionForSocket;
    }

    @Override
    public String resolveAppServerType() {
        return null;
    }

    @Override
    public String resolveJVMVersion() {
        return null;
    }

    public String resolvePlaceHolder(int type) {
        return null;
    }

    @Override
    public String resolvePlaceHolder(String name) {
        int placeHolderType = this.getPlaceHolderType(name);
        StringBuilder buffer = new StringBuilder(name);
        if (1 == placeHolderType) {
            int jvmCompatabiltyVersion = name.indexOf("${JVMCOMPATIBILITY}");
            buffer.replace(jvmCompatabiltyVersion, jvmCompatabiltyVersion + "${JVMCOMPATIBILITY}".length(), this.resolveJVMCompatibility(name));
            return buffer.toString();
        }
        return name;
    }
}

