/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.diagnos.cmp.tracer.builder.MethodTracerBuilder;
import com.wily.util.classfile.IMethodName;

public final class TraceOneMethodIfFlaggedDirective
extends ADirective {
    private final FlagName fFlagName;
    private final IMethodName fMethodName;
    private final TracerName fTracerName;
    private final String fNameParameter;

    public TraceOneMethodIfFlaggedDirective(String source, int lineNumber, FlagName flagName, IMethodName methodName, TracerName tracerName, String nameParameter) {
        super(source, lineNumber);
        this.fFlagName = flagName;
        this.fMethodName = methodName;
        this.fTracerName = tracerName;
        this.fNameParameter = nameParameter;
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    private IMethodName getMethodName() {
        return this.fMethodName;
    }

    private TracerName getTracerName() {
        return this.fTracerName;
    }

    private String getNameParameter() {
        return this.fNameParameter;
    }

    @Override
    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder flag = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTracer(new MethodTracerBuilder(this.getSource(), this.getLineNumber(), flag.getClassMatcher(), (IMethodMatcher)new NamedMethodMatcher(this.getMethodName()), this.getTracerName(), this.getNameParameter(), flag));
        flag.setSource(this.getSource());
    }
}

