/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.methodmatcher;

import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.util.Glob;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IModeledMethod;

public class GlobMethodMatcher
implements IMethodMatcher {
    protected final String methodPattern;
    private final Glob glob;

    public GlobMethodMatcher(String pattern) {
        this.methodPattern = pattern;
        this.glob = new Glob(this.methodPattern.trim());
    }

    @Override
    public boolean IMethodMatcher_matches(IModeledMethod method) {
        boolean result = this.matches(method.getMethodName().getNameString());
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(0x200000);
        }
        return result;
    }

    protected boolean matches(String name) {
        return this.glob.matches(name);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.methodPattern + "]";
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode(result, this.glob.getPattern());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GlobMethodMatcher) {
            GlobMethodMatcher other = (GlobMethodMatcher)obj;
            return this.methodPattern.equals(other.methodPattern);
        }
        return false;
    }
}

