/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.bytecode;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.personality.java.classfile.bytecode.DGByteCode;
import com.wily.wilyassert.Assertion;
import java.io.IOException;

public class MethodExitByteCode
extends DGByteCode {
    protected int fLocalThisStorage;
    protected int fCPISetInvocationObject;
    protected int fLocalTracerStorage;
    private boolean fIsConstructor;

    public MethodExitByteCode(int localThisStorage, int cpiSetInvocationObject, int localTracerStorage) throws DGClassModificationException, IOException {
        this.fLocalThisStorage = localThisStorage;
        this.fCPISetInvocationObject = cpiSetInvocationObject;
        this.fLocalTracerStorage = localTracerStorage;
    }

    public void initialize(int exitOpcode, int cpiTracerFinishTrace) throws DGClassModificationException, IOException {
        if (this.fLocalThisStorage != -1) {
            Assertion.wilyAssert(this.fCPISetInvocationObject != -1);
            Assertion.wilyAssert(this.fLocalTracerStorage != -1);
            this.fIsConstructor = true;
        }
        this.insertAdditionalMethodExitByteCode(exitOpcode);
        if (this.fIsConstructor) {
            this.insertConstructorSpecialCode();
        }
        this.write_aload(this.fLocalTracerStorage);
        this.write_invokeinterface(cpiTracerFinishTrace, 1);
    }

    @Override
    public int getMaxStackSlotsUsed() {
        return this.fIsConstructor ? 2 : 1;
    }

    protected void insertAdditionalMethodExitByteCode(int exitOpcode) throws DGClassModificationException, IOException {
    }

    private void insertConstructorSpecialCode() throws DGClassModificationException, IOException {
        this.write_aload(this.fLocalTracerStorage);
        this.write_aload(this.fLocalThisStorage);
        this.write_invokeinterface(this.fCPISetInvocationObject, 2);
    }
}

