/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.compiler;

import com.wily.diagnos.cmp.DGCompilationFailedException;
import com.wily.diagnos.cmp.batch.ABatchCompiler;
import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.classfile.DGClassException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.ui.ICompilerUI;
import com.wily.diagnos.personality.java.compiler.DGStreamSingleCompiler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class DGStreamBatchCompiler
extends ABatchCompiler {
    protected DGStreamBatchCompiler(DGCompilerSettings settings, DGFileSettings fileSettings, ICompilerUI ui, ICompilerLog log) {
        super(settings, fileSettings, ui, log);
    }

    protected void compileClassFile(InputStream classIn, OutputStream classOut, String classFileName) throws DGCompilationFailedException {
        this.updateStatusBar(classFileName);
        try {
            DGStreamSingleCompiler compiler = new DGStreamSingleCompiler(this.fSettings, this.fLog, new BufferedInputStream(classIn, 16384), classOut);
            compiler.compileOneClass();
        }
        catch (DGClassException dgce) {
            this.logException(classFileName, dgce);
            if (this.fProgressUI != null) {
                this.fProgressUI.ICompilerUI_handleExceptionProcessingFile(classFileName, dgce);
            }
            throw new DGCompilationFailedException(10);
        }
        catch (IOException ioe) {
            this.logException(classFileName, ioe);
            if (this.fProgressUI != null) {
                this.fProgressUI.ICompilerUI_handleExceptionProcessingFile(classFileName, ioe);
            }
            throw new DGCompilationFailedException(12);
        }
    }
}

