/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizrecording;

import com.wily.introscope.agent.bizrecording.NullResponseWrapper;
import com.wily.introscope.agent.bizrecording.ResponseWrapper;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.servlet.RequestWrapper;
import com.wily.introscope.agent.trace.servlet.ServletObjectFactory;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.wilyassert.Assertion;
import java.util.Enumeration;
import java.util.Map;

public class BizRecordingDataWrapper {
    private static final String kAcceptLanguageHeaderKey = "Accept-Language";
    private static final int kMaxRequestHeaderLength = Short.MAX_VALUE;
    private static final int kMaxRequestBodyLength = Short.MAX_VALUE;
    private final InvocationData fData;
    private final RequestWrapper fRequest;
    private final Object fResponse;
    private boolean fFilterDataUpdated = false;
    private String fRemoteAddress = null;
    private String fAcceptLanguage = null;
    private boolean fTransactionDataUpdated = false;
    private long fRecordingDate;
    private int fServerPort;
    private String fName;
    private String fPath;
    private String fRequestURI;
    private String fQueryString;
    private String fMethod;
    private String fProtocol;
    private String fServerAddress;
    private String fRequestHeader;
    private String fRequestBody;
    private String fResponseHeader;
    private String fResponseBody;
    private static final ThreadLocal fThreadLocalResponses = new ThreadLocal();
    private static final NullResponseWrapper kNullResponseWrapperInstance = new NullResponseWrapper();

    public BizRecordingDataWrapper(InvocationData data) throws Throwable {
        Assertion.wilyAssert(data != null);
        Assertion.wilyAssert(data.hasInvocationParametersAvailable());
        Assertion.wilyAssert(data.getInvocationParameterCount() > 0);
        Object requestObject = data.getInvocationParameterAsObject(0);
        ServletObjectFactory objectFactory = ServletObjectFactory.getServletObjectFactory(requestObject);
        this.fRequest = objectFactory.getRequestWrapper(requestObject);
        this.fResponse = data.getInvocationParameterAsObject(1);
        BizRecordingDataWrapper.setNewResponseWrapper(this.fResponse);
        this.fData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFilterData() throws Throwable {
        if (!this.fFilterDataUpdated) {
            InvocationData invocationData = this.fData;
            synchronized (invocationData) {
                this.fRemoteAddress = this.fRequest.getRemoteAddress();
                this.fAcceptLanguage = this.fRequest.getHeader(kAcceptLanguageHeaderKey);
            }
            this.fFilterDataUpdated = true;
        }
    }

    public String getRemoteAddress() throws Throwable {
        this.updateFilterData();
        return this.fRemoteAddress;
    }

    public String getAcceptLanguage() throws Throwable {
        this.updateFilterData();
        return this.fAcceptLanguage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransactionData() throws Throwable {
        if (!this.fTransactionDataUpdated) {
            InvocationData invocationData = this.fData;
            synchronized (invocationData) {
                this.fName = this.fRequest.getServletPath();
                this.fPath = this.fRequest.getContextPath();
                this.fRequestURI = this.fRequest.getRequestURI();
                this.fQueryString = this.fRequest.getQueryString();
                this.fMethod = this.fRequest.getMethod();
                this.fProtocol = this.fRequest.getProtocol();
                this.fRecordingDate = System.currentTimeMillis();
                this.fServerAddress = this.fRequest.getLocalAddr();
                this.fServerPort = this.fRequest.getServerPort();
                this.fRequestHeader = this.getRequestHeader_Impl();
                this.fRequestBody = this.getRequestBody_Impl();
                this.fResponseHeader = this.getResponseHeader_Impl();
                this.fResponseBody = null;
            }
            this.fTransactionDataUpdated = true;
        }
    }

    public long getRecordingDate() throws Throwable {
        this.updateTransactionData();
        return this.fRecordingDate;
    }

    public int getServerPort() throws Throwable {
        this.updateTransactionData();
        return this.fServerPort;
    }

    public String getName() throws Throwable {
        this.updateTransactionData();
        return this.fName;
    }

    public String getPath() throws Throwable {
        this.updateTransactionData();
        return this.fPath;
    }

    public String getServerAddress() throws Throwable {
        this.updateTransactionData();
        return this.fServerAddress;
    }

    public String getProtocol() throws Throwable {
        this.updateTransactionData();
        return this.fProtocol;
    }

    public String getRequestHeader() throws Throwable {
        this.updateTransactionData();
        return this.fRequestHeader;
    }

    public String getRequestBody() throws Throwable {
        this.updateTransactionData();
        return this.fRequestBody;
    }

    public String getResponseHeader() throws Throwable {
        this.updateTransactionData();
        return this.fResponseHeader;
    }

    public String getResponseBody() throws Throwable {
        this.updateTransactionData();
        return this.fResponseBody;
    }

    private String getRequestHeader_Impl() throws Throwable {
        StringBuilder builder = new StringBuilder();
        builder.append(this.fMethod).append(" ").append(this.fRequestURI);
        if (this.fQueryString != null) {
            builder.append("?").append(this.fQueryString);
        }
        builder.append(" ").append(this.fProtocol).append("\n");
        Enumeration itr = this.fRequest.getHeaderNames();
        while (itr.hasMoreElements()) {
            String name = (String)itr.nextElement();
            String value = this.fRequest.getHeader(name);
            if (builder.length() + name.length() + value.length() + 3 >= Short.MAX_VALUE) break;
            builder.append(name).append(": ").append(value).append("\n");
        }
        return builder.toString();
    }

    private String getRequestBody_Impl() throws Throwable {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        Map postParams = this.fRequest.getPostParameterMap2();
        for (Map.Entry entry : postParams.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if (first) {
                first = false;
            } else {
                buf.append('&');
            }
            if (val instanceof String) {
                buf.append(key).append('=').append((String)val);
                continue;
            }
            String[] values = (String[])val;
            int i = 0;
            while (i < values.length) {
                buf.append(key).append('=').append(values[i]);
                ++i;
            }
        }
        return buf.toString();
    }

    private String getResponseHeader_Impl() {
        ResponseWrapper response = BizRecordingDataWrapper.popResponseWrapper(this.fResponse);
        StringBuilder buf = new StringBuilder();
        buf.append(this.fProtocol).append(' ').append(response.getStatusCode()).append(' ').append(response.getMessage()).append('\n');
        String contentType = response.getContentType();
        if (contentType != null) {
            buf.append("Content-Type: ").append(contentType).append('\n');
        }
        buf.append(response.getHeader());
        return buf.toString();
    }

    public static void resetThreadLocalData() {
        fThreadLocalResponses.set(null);
    }

    private static ResponseWrapper popResponseWrapper(Object key) {
        WeakIdentityHashMap responseMap = (WeakIdentityHashMap)fThreadLocalResponses.get();
        ResponseWrapper response = null;
        if (responseMap != null) {
            fThreadLocalResponses.set(null);
            response = (ResponseWrapper)responseMap.get(key);
        }
        if (response == null) {
            response = kNullResponseWrapperInstance;
        }
        return response;
    }

    private static ResponseWrapper setNewResponseWrapper(Object key) {
        ResponseWrapper response;
        WeakIdentityHashMap responseMap = (WeakIdentityHashMap)fThreadLocalResponses.get();
        if (responseMap == null) {
            responseMap = new WeakIdentityHashMap();
            fThreadLocalResponses.set(responseMap);
        }
        if ((response = (ResponseWrapper)responseMap.get(key)) == null) {
            response = new ResponseWrapper();
            responseMap.put(key, response);
        }
        return response;
    }

    private static ResponseWrapper getResponseWrapper(Object key) {
        WeakIdentityHashMap responseMap = (WeakIdentityHashMap)fThreadLocalResponses.get();
        if (responseMap == null) {
            return kNullResponseWrapperInstance;
        }
        ResponseWrapper response = (ResponseWrapper)responseMap.get(key);
        if (response == null) {
            return kNullResponseWrapperInstance;
        }
        return response;
    }

    static void setContentType(Object key, String contentType) {
        BizRecordingDataWrapper.getResponseWrapper(key).setContentType(contentType);
    }

    static void setStatusCode(Object key, int sc, String msg) {
        BizRecordingDataWrapper.getResponseWrapper(key).setStatusCode(sc, msg);
    }

    static void setHeader(Object key, String name, String value) {
        BizRecordingDataWrapper.getResponseWrapper(key).setHeader(name, value);
    }

    static void addHeader(Object key, String name, String value) {
        BizRecordingDataWrapper.getResponseWrapper(key).addHeader(name, value);
    }

    static void setCharacterEncoding(Object key, String charEncoding) {
        BizRecordingDataWrapper.getResponseWrapper(key).setCharacterEncoding(charEncoding);
    }
}

