/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.BoundaryBlameStack;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.correlation.ICrossProcessCallback;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.feature.StallPoint;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.remote.RemoteThread;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.AbortedStackElement;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.StartTransactionStackElement;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.automatic.AutoTracingCollectStatus;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IBoundaryBlameStackHelper;
import com.wily.introscope.agent.trace.cas.IBoundaryBlameStackHelperProvider;
import com.wily.introscope.agent.trace.cas.IIntegerFluctuatingCounterDataAccumulatorWrapper;
import com.wily.introscope.agent.trace.cas.INotAnOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IPlaceholderElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.IStallPoint;
import com.wily.introscope.agent.trace.cas.IThreadLocalObjectFactory;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProvider;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProviderFactory;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementCallbackOnRecursion;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceProvider;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.hc2.WilyEndTransactionInstance;
import com.wily.introscope.agent.trace.hc2.WilyStartTransactionInstance;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.transactiontrace.CrossCorrelationStringParameterProvider;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.WilyStringBuilder;
import com.wily.util.adt.CacheHashSet;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.adt.WeakWeakIdentityHashMap;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class VirtualStack
implements IBlameStack,
IBoundaryBlameStackHelperProvider,
ITransactionCacheProvider,
ITransactionCacheProviderFactory {
    private static volatile IAgent fAgent;
    private static final Module kModule;
    private static volatile boolean sIsMixedModeWarningGiven;
    private static final TxnElementRecursionHelper kTxnElementRecusrsionHelper;
    private static final ThreadLocal sStack;
    private static final ThreadLocal sAppMapStack;
    private static volatile boolean sUseExternalThreadId;
    private static final ThreadLocal sExternalThreadId;
    private static final Map sExternalThreadMap;
    public static IStackType kStackType;

    static {
        kModule = new Module("VirtualStack");
        sIsMixedModeWarningGiven = false;
        kTxnElementRecusrsionHelper = new TxnElementRecursionHelper();
        sStack = new ThreadLocal(){

            public VirtualStackCursor initialValue() {
                return new VirtualStackCursor(null);
            }
        };
        sAppMapStack = new ThreadLocal(){

            public AppMapCursor initialValue() {
                return new AppMapCursor();
            }
        };
        sUseExternalThreadId = false;
        sExternalThreadId = new ThreadLocal(){

            public ExternalThreadIdThreadLocal initialValue() {
                return new ExternalThreadIdThreadLocal();
            }
        };
        sExternalThreadMap = new ConcurrentHashMap();
        kStackType = new IStackType(){};
    }

    public VirtualStack(IAgent agent) {
        fAgent = agent;
    }

    private static VirtualStackCursor getStack() {
        if (sUseExternalThreadId) {
            ExternalThreadIdThreadLocal etl = (ExternalThreadIdThreadLocal)sExternalThreadId.get();
            String tid = etl.tid;
            if (tid != null && tid.length() > 0) {
                ExternalThreadMapEntry e = (ExternalThreadMapEntry)sExternalThreadMap.get(tid);
                if (e == null) {
                    e = new ExternalThreadMapEntry();
                    e.thread = new RemoteThread(tid);
                    e.connection = etl.conn;
                    sExternalThreadMap.put(tid, e);
                }
                if (e.vc == null) {
                    e.vc = new VirtualStackCursor(e.thread);
                    e.vc.getCurrentCache().setThread(e.thread);
                }
                return e.vc;
            }
        }
        return (VirtualStackCursor)sStack.get();
    }

    private static AppMapCursor getAppMapStack() {
        if (sUseExternalThreadId) {
            ExternalThreadIdThreadLocal etl = (ExternalThreadIdThreadLocal)sExternalThreadId.get();
            String tid = etl.tid;
            if (tid != null && tid.length() > 0) {
                ExternalThreadMapEntry e = (ExternalThreadMapEntry)sExternalThreadMap.get(tid);
                if (e == null) {
                    e = new ExternalThreadMapEntry();
                    e.thread = new RemoteThread(tid);
                    e.connection = etl.conn;
                    sExternalThreadMap.put(tid, e);
                }
                if (e.ac == null) {
                    e.ac = new AppMapCursor();
                }
                return e.ac;
            }
        }
        return (AppMapCursor)sAppMapStack.get();
    }

    @Override
    public Object getExternalThreadLocalObject(int idx, IThreadLocalObjectFactory factory) {
        ExternalThreadIdThreadLocal etl = (ExternalThreadIdThreadLocal)sExternalThreadId.get();
        String tid = etl.tid;
        if (tid != null && tid.length() > 0) {
            ExternalThreadMapEntry e = (ExternalThreadMapEntry)sExternalThreadMap.get(tid);
            if (e == null) {
                return null;
            }
            if (e.tlo == null) {
                e.tlo = new Object[3];
            }
            if (idx >= e.tlo.length) {
                return null;
            }
            if (e.tlo[idx] == null) {
                e.tlo[idx] = factory.makeNewThreadLocalObject();
            }
            return e.tlo[idx];
        }
        return null;
    }

    @Override
    public void setUseExternalThreadId() {
        sUseExternalThreadId = true;
    }

    @Override
    public boolean isUseExternalThreadId() {
        return sUseExternalThreadId;
    }

    @Override
    public boolean setExternalThreadId(String id, Object conn, boolean createIfNew) {
        boolean retval = true;
        ExternalThreadMapEntry e = (ExternalThreadMapEntry)sExternalThreadMap.get(id);
        if (e == null) {
            if (createIfNew) {
                e = new ExternalThreadMapEntry();
                e.thread = new RemoteThread(id);
                e.connection = conn;
                sExternalThreadMap.put(id, e);
            } else {
                e = new ExternalThreadMapEntry();
                e.thread = new RemoteThread(id);
                ((RemoteThread)e.thread).kill();
                e.connection = null;
                sExternalThreadMap.put(id, e);
                retval = false;
            }
        }
        ExternalThreadIdThreadLocal etl = (ExternalThreadIdThreadLocal)sExternalThreadId.get();
        etl.tid = id;
        etl.conn = conn;
        return retval;
    }

    @Override
    public int getExternalThreadCount() {
        return sExternalThreadMap.size();
    }

    @Override
    public void clearExternalThread() {
        ExternalThreadIdThreadLocal etl = (ExternalThreadIdThreadLocal)sExternalThreadId.get();
        ExternalThreadMapEntry ee = (ExternalThreadMapEntry)sExternalThreadMap.get(etl.tid);
        if (ee != null && ee.vc != null && ee.vc.data != null) {
            WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException(""), ee.vc.data);
        }
        if (ee != null && ee.thread instanceof RemoteThread) {
            ((RemoteThread)ee.thread).kill();
        }
        sExternalThreadMap.remove(etl.tid);
    }

    @Override
    public void invalidateThreadsFromConnection(Object conn) {
        for (Map.Entry e : sExternalThreadMap.entrySet()) {
            ExternalThreadMapEntry ee = (ExternalThreadMapEntry)e.getValue();
            if (ee != null && ee.connection == conn) {
                if (ee.vc != null && ee.vc.data != null) {
                    WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException(""), ee.vc.data);
                } else {
                    VirtualStack.abortTransaction();
                }
            }
            if (ee != null && ee.thread instanceof RemoteThread) {
                ((RemoteThread)ee.thread).kill();
            }
            sExternalThreadMap.remove(e.getKey());
        }
    }

    public static final boolean isParentDummyVirtualElement(InvocationData data) {
        VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
        if (cursor == null) {
            cursor = VirtualStack.getStack();
        }
        return cursor.data != null && cursor.data.getParent() != null && cursor.data.getParent() instanceof DummyVirtualElement;
    }

    private static final IStackElement push(WrappedInvocationData wrappedData) {
        InvocationData data = wrappedData.getInvocationData();
        VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
        if (cursor == null) {
            cursor = VirtualStack.getStack();
        }
        if (cursor.transactionCache.isTransactionAborted()) {
            return AbortedStackElement.getInstance();
        }
        IStackElement previous = cursor.data;
        wrappedData.setParent(previous);
        cursor.data = wrappedData;
        if (WilyTransactionStructure.developmentDebug) {
            fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "WrappedInvocationData " + " Pushed to stack: " + data);
        }
        return previous;
    }

    public static final IStackElement push(InvocationData data) {
        VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
        if (cursor == null) {
            cursor = VirtualStack.getStack();
        }
        if (cursor.transactionCache.isTransactionAborted()) {
            return AbortedStackElement.getInstance();
        }
        IStackElement previous = cursor.data;
        if (previous != data && !data.setParent(previous)) {
            return VirtualStack.push(new WrappedInvocationData(data));
        }
        cursor.data = data;
        if (previous == null) {
            cursor.transactionCache.setRoot(data);
            data.setStartedTransaction();
        }
        if (WilyTransactionStructure.developmentDebug) {
            fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "InvocationData " + " Pushed to stack: " + data);
        }
        return previous == null ? StartTransactionStackElement.getInstance() : previous;
    }

    public static final void pushAppMap(CrossCorrelationStringParameterProvider provider, InvocationData data) {
        AppMapCursor cursor = VirtualStack.getAppMapStack();
        InvocationData previous = cursor.data;
        CrossCorrelationStringParameterProvider previousProvider = cursor.provider;
        if (previous != data) {
            data.setAppMapParent(previousProvider, previous);
        }
        cursor.data = data;
        cursor.provider = provider;
    }

    private static void attemptIBlameStack_tearDown() {
        if (fAgent != null) {
            fAgent.IAgent_getComponentTracer().teardown();
        }
    }

    public static final void tearDown() {
        VirtualStack.tearDownMe();
        VirtualStack.attemptIBlameStack_tearDown();
    }

    private static final void tearDownMe() {
        VirtualStackCursor cursor = VirtualStack.getStack();
        cursor.data = null;
        StallFeatureBase.removeStallPoint(cursor.getCurrentCache().getStallPoint(), cursor.data);
        cursor.decoration.clear();
        cursor.decorationClampHit = false;
        cursor.transactionCache.clear();
        AppMapCursor appCursor = VirtualStack.getAppMapStack();
        appCursor.data = null;
        appCursor.provider = null;
        if (WilyTransactionStructure.developmentDebug) {
            fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Virtual Stack has been reset ");
        }
    }

    public static final void pop(InvocationData data) {
        IStackElement parent = data.getParent();
        if (parent != data) {
            IStackElement element;
            VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
            if (cursor == null) {
                cursor = VirtualStack.getStack();
            }
            if ((element = cursor.data) != null && element instanceof WrappedInvocationData) {
                VirtualStack.pop((WrappedInvocationData)element);
                return;
            }
            cursor.data = parent;
            if (parent != null) {
                parent.setCursor(data.getCursor());
                if (parent.getCursor() instanceof IPlaceholderElement) {
                    VirtualStack.popPlaceholder("end", ((IPlaceholderElement)parent.getCursor()).getProvider());
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "InvocationData " + " Popped from stack: " + data);
            }
        }
    }

    private static final void pop(WrappedInvocationData wrappedData) {
        IStackElement parent = wrappedData.getParent();
        InvocationData data = wrappedData.getInvocationData();
        if (parent != wrappedData) {
            VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
            if (cursor == null) {
                cursor = VirtualStack.getStack();
            }
            cursor.data = parent;
            if (parent != null) {
                parent.setCursor(data.getCursor());
                if (parent.getCursor() instanceof IPlaceholderElement) {
                    VirtualStack.popPlaceholder("end", ((IPlaceholderElement)parent.getCursor()).getProvider());
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "WrappedInvocationData " + " Popped from stack: " + data);
            }
        }
    }

    public static final void popAppMap(InvocationData data) {
        AppMapCursor cursor = VirtualStack.getAppMapStack();
        if (cursor.data == data) {
            cursor.data = data.getAppMapParent();
            cursor.provider = data.getCrossProcessStringParentProvider();
        }
    }

    public static final IStackElement peekIfNew(Object caller) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        if (!((TransactionCache)cursor.getCurrentCache()).hasCallerSeenStackElement(caller, cursor.data)) {
            return cursor.data;
        }
        return null;
    }

    public static final IStackElement peek() {
        return VirtualStack.getStack().data;
    }

    public static final InvocationData peekAppMap() {
        return VirtualStack.getAppMapStack().data;
    }

    private static void addParamToDecoration(IComponentParameterCallback callback, IStackElement newTopElement, VirtualStackCursor cursor) {
        StackDecoration sd = (StackDecoration)cursor.decoration.get(newTopElement);
        if (sd == null) {
            sd = new StackDecoration();
        }
        sd.callbacks.offer(callback);
        VirtualStack.clampDecoration(cursor);
        StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(cursor.data, sd);
        StackDecoration cfr_ignored_0 = (StackDecoration)cursor.decoration.get(cursor.data);
        if (alreadyExisting != null) {
            alreadyExisting.callbacks.offer(callback);
        }
    }

    private static void addParamToDecoration(String paramName, String paramValue, IStackElement newTopElement, VirtualStackCursor cursor) {
        StackDecoration sd = (StackDecoration)cursor.decoration.get(newTopElement);
        if (sd == null) {
            sd = new StackDecoration();
        }
        sd.parameters.put(paramName, paramValue);
        VirtualStack.clampDecoration(cursor);
        StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(cursor.data, sd);
        if (alreadyExisting != null) {
            alreadyExisting.parameters.put(paramName, paramValue);
        }
    }

    private void giveMixedModeWarning() {
        sIsMixedModeWarningGiven = true;
        fAgent.IAgent_getModuleFeedback().warn(kModule, "An agent tracer using legacy APIs has been detected.");
        fAgent.IAgent_getModuleFeedback().warn(kModule, "Running legacy tracers with the agent in new mode is not recommended.");
        fAgent.IAgent_getModuleFeedback().warn(kModule, "Please contact support who can refer you to documentation on how to upgrade your legacy tracers.");
        fAgent.IAgent_getModuleFeedback().warn(kModule, "In the interim, please configure the agent to use legacy mode or use the pre-configured version of the legacy agent package.");
        fAgent.IAgent_getModuleFeedback().warn(kModule, "For example, the legacy package for the Oracle WebLogic agent on UNIX is IntroscopeAgentFiles-Legacy-NoInstallerx.x.x.xweblogic.unix.tar");
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stackTrace.length) {
            fAgent.IAgent_getModuleFeedback().debug(kModule, Thread.currentThread().getStackTrace()[i].toString());
            ++i;
        }
    }

    @Override
    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
        if (!sIsMixedModeWarningGiven) {
            this.giveMixedModeWarning();
        }
        VirtualStack.pushFromOldAPI(component, callback);
    }

    @Override
    public void IBlameStack_addComponent(String component) {
        if (!sIsMixedModeWarningGiven) {
            this.giveMixedModeWarning();
        }
        VirtualStack.pushFromOldAPI(component);
    }

    @Override
    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
        if (!sIsMixedModeWarningGiven) {
            this.giveMixedModeWarning();
        }
        VirtualStack.pushFromOldAPI(component, paramName, paramValue);
    }

    @Override
    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        this.IBlameStack_addExtraParameter(paramName, paramValue, cursor.data);
    }

    public void IBlameStack_addExtraParameter(String paramName, String paramValue, IStackElement stackElement) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        if (cursor.data != null) {
            StackDecoration sd = (StackDecoration)cursor.decoration.get(stackElement);
            if (sd == null) {
                sd = new StackDecoration();
            }
            sd.parameters.put(paramName, paramValue);
            VirtualStack.clampDecoration(cursor);
            StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(stackElement, sd);
            if (alreadyExisting != null) {
                alreadyExisting.parameters.put(paramName, paramValue);
            }
        }
    }

    @Override
    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return null;
    }

    @Override
    public boolean IBlameStack_isEmpty() {
        return VirtualStack.getStack().data == null;
    }

    @Override
    public void IBlameStack_removeComponent(String component) {
        VirtualStack.popFromOldAPI(component);
    }

    @Override
    public void IBlameStack_tearDown() {
        VirtualStack.tearDownMe();
        TransactionCache transactionCache = VirtualStack.getTransactionCache();
        if (transactionCache.isVirtualElementEndedTxn() || transactionCache.isCrossCorrelationElementEndedTxn()) {
            CrossProcessCorrelationAdmin.invalidateCrossProcessDataCache();
            transactionCache.setfVirtualElementEndedTxn(false);
            transactionCache.setfCrossCorrelationElementEndedTxn(false);
        }
    }

    @Override
    public void addMapComponent(IStackType type, String component) {
        if (type == kStackType) {
            this.IBlameStack_addComponent(component);
        }
    }

    @Override
    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
        if (type == kStackType) {
            this.IBlameStack_addComponent(component, paramName, paramVal);
        }
    }

    @Override
    public void addMapComponent(IStackType type, String component, HashMap params) {
        if (type == kStackType) {
            if (!sIsMixedModeWarningGiven) {
                this.giveMixedModeWarning();
            }
            IStackElement newTopElement = VirtualStack.pushFromOldAPI(component);
            VirtualStackCursor cursor = VirtualStack.getStack();
            StackDecoration sd = (StackDecoration)cursor.decoration.get(newTopElement);
            if (sd == null) {
                sd = new StackDecoration();
            }
            sd.parameters.putAll(params);
            VirtualStack.clampDecoration(cursor);
            StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(cursor.data, sd);
            if (alreadyExisting != null) {
                alreadyExisting.parameters.putAll(params);
            }
        }
    }

    private static void clampDecoration(VirtualStackCursor cursor) {
        if (cursor.decoration.size() > VirtualStackCursor.sMaxDecorations && VirtualStackCursor.sMaxDecorations > 0) {
            String msg = "Clearing VirtualStackCursor.decoration which has " + cursor.decoration.size() + " elements, more than max allowed: " + VirtualStackCursor.sMaxDecorations;
            if (!cursor.decorationClampHit) {
                fAgent.IAgent_getModuleFeedback().info(kModule, msg);
                cursor.decorationClampHit = true;
            } else {
                fAgent.IAgent_getModuleFeedback().debug(kModule, msg);
            }
            cursor.decoration.clear();
        }
    }

    @Override
    public void addRootParameter(String key, String value) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        IStackElement dataComponent = cursor.transactionCache.getRoot();
        if (dataComponent != null) {
            StackDecoration sd = (StackDecoration)VirtualStack.getStack().decoration.get(dataComponent);
            if (sd == null) {
                sd = new StackDecoration();
            }
            sd.parameters.put(key, value);
            VirtualStack.clampDecoration(cursor);
            StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(dataComponent, sd);
            if (alreadyExisting != null) {
                alreadyExisting.parameters.put(key, value);
            }
        } else {
            throw new RuntimeException("Cannot add parameter to an empty virtual stack.");
        }
    }

    @Override
    public void endBoundaryPopped(String component) {
    }

    @Override
    public void frontBoundaryPopped(String component) {
    }

    @Override
    public String[] getDefaultBackendData() {
        return null;
    }

    @Override
    public BlameStackSnapshot getDefaultBackendSnapshot() {
        return null;
    }

    @Override
    public boolean getHeadFilteringStatus() {
        return FilterController.canCurrentTransactionBeMarkedForCollection(VirtualStack.getStack().transactionCache);
    }

    @Override
    public boolean hasFrontBoundary() {
        return VirtualStack.getStack().transactionCache.getFrontend() != null;
    }

    public static boolean staticHasFrontBoundary() {
        return VirtualStack.getStack().transactionCache.getFrontend() != null;
    }

    @Override
    public boolean noteBoundaryError() {
        return false;
    }

    @Override
    public void popMapComponent(IStackType stackType, String component) {
        if (stackType == kStackType) {
            this.IBlameStack_removeComponent(component);
        }
    }

    @Override
    public void removeMapComponent(IStackType stackType, String component) {
        if (stackType == kStackType) {
            this.IBlameStack_removeComponent(component);
        }
    }

    @Override
    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
    }

    @Override
    public void setEndBoundary(String component) {
    }

    public static boolean staticHasEndBoundary() {
        return VirtualStack.getStack().transactionCache.getBackend() != null;
    }

    @Override
    public void setFrontBoundary(String component) {
    }

    @Override
    public boolean shouldCurrentTraceBePropagated() {
        return FilterController.shouldCurrentTraceBePropagated(VirtualStack.getStack().transactionCache);
    }

    public static TransactionCollectStatus getTransactionCollectStatus() {
        return VirtualStack.getStack().transactionCache.getTransactionCollectionStatus();
    }

    private static final IStackElement pushFromOldAPI(String component) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        if (cursor != null) {
            if (cursor.transactionCache.isTransactionAborted()) {
                return AbortedStackElement.kInstance;
            }
            IStackElement previous = cursor.data;
            VirtualElement data = new VirtualElement(component, previous, cursor.transactionCache, null, null);
            cursor.data = data;
            try {
                if (previous != null) {
                    ITransactionElement currentCursor = previous.getCursor();
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                } else {
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitStartTransaction((Object)component, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                }
                if (WilyTransactionStructure.fSuggestStallTraceProperty) {
                    StallFeatureBase.putStallPoint(data);
                }
            }
            finally {
                if (previous == null) {
                    cursor.transactionCache.setRoot(data);
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "VirtualElement " + " Pushed on to stack: " + component);
            }
            return previous == null ? StartTransactionStackElement.kInstance : previous;
        }
        return null;
    }

    private static final IStackElement pushFromOldAPI(String component, IComponentParameterCallback callback) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        if (cursor != null) {
            if (cursor.transactionCache.isTransactionAborted()) {
                return AbortedStackElement.kInstance;
            }
            IStackElement previous = cursor.data;
            VirtualElement data = new VirtualElement(component, previous, cursor.transactionCache, null, null);
            cursor.data = data;
            VirtualStack.addParamToDecoration(callback, data, cursor);
            try {
                if (previous != null) {
                    ITransactionElement currentCursor = previous.getCursor();
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                } else {
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitStartTransaction((Object)component, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                }
                if (WilyTransactionStructure.fSuggestStallTraceProperty) {
                    StallFeatureBase.putStallPoint(data);
                }
            }
            finally {
                if (previous == null) {
                    cursor.transactionCache.setRoot(data);
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "VirtualElement " + " Pushed on to stack: " + component);
            }
            return previous == null ? StartTransactionStackElement.kInstance : previous;
        }
        return null;
    }

    private static final IStackElement pushFromOldAPI(String component, String param, String value) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        if (cursor != null) {
            if (cursor.transactionCache.isTransactionAborted()) {
                return AbortedStackElement.kInstance;
            }
            IStackElement previous = cursor.data;
            VirtualElement data = new VirtualElement(component, previous, cursor.transactionCache, null, null);
            cursor.data = data;
            VirtualStack.addParamToDecoration(param, value, data, cursor);
            try {
                if (previous != null) {
                    ITransactionElement currentCursor = previous.getCursor();
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                } else {
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitStartTransaction((Object)component, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                }
                if (WilyTransactionStructure.fSuggestStallTraceProperty) {
                    StallFeatureBase.putStallPoint(data);
                }
            }
            finally {
                if (previous == null) {
                    cursor.transactionCache.setRoot(data);
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "VirtualElement " + " Pushed on to stack: " + component);
            }
            return previous == null ? StartTransactionStackElement.kInstance : previous;
        }
        return null;
    }

    private static final void popFromOldAPI(String component) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        if (cursor != null) {
            boolean bAbortTransaction = false;
            try {
                IStackElement element = cursor.data;
                if (!cursor.transactionCache.isTransactionAborted() && element != null) {
                    ITransactionElement oldTransactionCursor;
                    if (element instanceof DummyVirtualElement) {
                        if ((element = ((DummyVirtualElement)element).getImmediateNonDummyParent()) == null) {
                            bAbortTransaction = true;
                            WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException("The stack is corrupted due to a tracer which removes component but does not add "), cursor.data);
                            return;
                        }
                        cursor.data = element;
                    }
                    if (!VirtualStack.checkStackRobustness(element, oldTransactionCursor = element.getCursor(), component)) {
                        if (VirtualStack.isTxnAbortedDueToInvalidCursor(oldTransactionCursor)) {
                            WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException("The cursor is invalid due to some reason " + element), element);
                        } else {
                            WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException("The stack is corrupted on element " + element), element);
                        }
                        bAbortTransaction = true;
                    } else {
                        ((VirtualElement)element).setWallClockFinishTime(MasterClock.currentTimeMillis());
                        VirtualStack.updateDefaultBackendMetrics(cursor, element);
                        if (cursor.transactionCache.getRoot() == cursor.data) {
                            WilyTransactionStructure.getInstance().submitNextEndTransaction(component, oldTransactionCursor, 0, element, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance, true);
                        } else {
                            ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextEndTransaction((Object)component, oldTransactionCursor, 0, element, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                            element.setCursor(newTransactionCursor);
                        }
                    }
                }
                if (WilyTransactionStructure.developmentDebug) {
                    fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "VirtualElement " + " Popped from stack: " + component);
                }
            }
            finally {
                if (bAbortTransaction || cursor.data != null && cursor.transactionCache.getRoot() == cursor.data) {
                    cursor.data.setCursor(null);
                    if (cursor.transactionCache.isTransactionAborted()) {
                        FilterController.updateTransactionCollectStatus(cursor.data, false, false, 0);
                    }
                    StallFeatureBase.removeStallPoint(cursor.data.getStallPoint(), cursor.data);
                    VirtualStack.tearDownMe();
                    cursor.transactionCache.setfVirtualElementEndedTxn(true);
                } else if (cursor.data != null) {
                    IStackElement parent = cursor.data.getParent();
                    if (parent != null) {
                        parent.setCursor(cursor.data.getCursor());
                    }
                    cursor.data = cursor.data.getParent();
                    if (parent.getCursor() instanceof IPlaceholderElement) {
                        VirtualStack.popPlaceholder("end", ((IPlaceholderElement)parent.getCursor()).getProvider());
                        parent = ((DummyVirtualElement)parent).getImmediateNonDummyParent();
                    }
                    if (parent != null) {
                        StallFeatureBase.putValidParentInStallPoint(cursor.data);
                    }
                }
            }
        }
    }

    private static boolean isTxnAbortedDueToInvalidCursor(ITransactionElement cursor) {
        StackRecursionHelper.staticSafeRecurseAccessParent(cursor, kTxnElementRecusrsionHelper, StackRecursionHelper.kMaxRecursive);
        return VirtualStack.getTransactionCache().isTransactionAborted();
    }

    private static void updateDefaultBackendMetrics(VirtualStackCursor cursor, IStackElement element) {
        Iterator i = cursor.data.getAppMapSocketCursors();
        if (i != null) {
            long elapsed = element.getWallClockElapsedTime();
            long endTime = element.getWallClockFinishTime();
            int hashcode = element.hashCode();
            while (i.hasNext()) {
                SocketTransactionElement socketCursor = (SocketTransactionElement)i.next();
                socketCursor.getTimerRepository().update(UpdaterFactory.getCombiningUpdater(), elapsed, endTime, hashcode);
                socketCursor.getPerIntervalRepository().update(UpdaterFactory.getIncreasingUpdater(), 0L, endTime, hashcode);
            }
        }
    }

    private static final boolean checkStackRobustness(IStackElement element, ITransactionElement oldTransactionCursor, String component) {
        if (element == null || element instanceof InvocationData) {
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Stack is corrupt, element is null or is instance of Invocation data where it is expected to be popped from legacy mode");
            }
            return false;
        }
        if (oldTransactionCursor == null) {
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Stack is corrupt, the element does not have a current transaction cursor");
            }
            return false;
        }
        if (oldTransactionCursor instanceof WilyTransactionElement) {
            boolean result = ((WilyTransactionElement)oldTransactionCursor).getBlameName().equals(component);
            if (WilyTransactionStructure.developmentDebug && !result) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Stack is corrupt, attempting at popping " + component + " where in the stack there is a cursor with name: " + ((WilyTransactionElement)oldTransactionCursor).getBlameName());
            }
            return result;
        }
        if (WilyTransactionStructure.developmentDebug) {
            fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Stack is corrupt, the transaction cursor is not a wily blame cursor but an instance of " + oldTransactionCursor.getClass().getName());
        }
        return false;
    }

    public static TransactionCache getTransactionCache() {
        return VirtualStack.getStack().transactionCache;
    }

    public static void setAborted() {
    }

    public static final IStackElement pushPlaceholder(String component, ITransactionElementProvider provider, ITransactionInstanceProvider instanceProvider) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        if (cursor != null) {
            if (cursor.transactionCache.isTransactionAborted()) {
                return AbortedStackElement.kInstance;
            }
            IStackElement previous = cursor.data;
            if (previous != null) {
                ITransactionElement currentCursor = previous.getCursor();
                DummyVirtualElement data = new DummyVirtualElement(component, previous, cursor.transactionCache);
                ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, 0, (IStackElement)data, provider, instanceProvider);
                cursor.data = data;
                cursor.data.setCursor(newTransactionCursor);
                ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
            } else {
                DummyVirtualElement data = new DummyVirtualElement(component, null, cursor.transactionCache);
                ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitStartTransaction((Object)component, 0, (IStackElement)data, provider, instanceProvider);
                cursor.data = data;
                cursor.transactionCache.setRoot(data);
                cursor.data.setCursor(newTransactionCursor);
                ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "VirtualElement" + "Pushed on to stack by PlaceHolder: " + component);
            }
            cursor.transactionCache.setCorrelationIdWasInvoked();
            return previous;
        }
        return null;
    }

    public static final void popPlaceholder(String component, ITransactionElementProvider provider) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        if (cursor != null) {
            IStackElement element = cursor.data;
            IStackElement parent = null;
            if (element != null && !element.isTransactionAborted()) {
                ((VirtualElement)element).setWallClockFinishTime(MasterClock.currentTimeMillis());
                parent = element.getParent();
                if (parent != null) {
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextEndTransaction(component, element.getCursor(), 0, element, provider);
                    element.setCursor(newTransactionCursor);
                    parent.setCursor(element.getCursor());
                } else {
                    cursor.transactionCache.setfCrossCorrelationElementEndedTxn(true);
                    WilyTransactionStructure.getInstance().submitNextEndTransaction(component, element.getCursor(), 0, element, provider, ADefaultTransactionInstanceProvider.kInstance, true);
                    element.setCursor(null);
                    VirtualStack.tearDown();
                }
            } else if (element != null && element.isTransactionAborted() && (parent = element.getParent()) == null) {
                cursor.transactionCache.setfCrossCorrelationElementEndedTxn(true);
                element.setCursor(null);
                VirtualStack.tearDownMe();
            }
            cursor.data = parent;
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "VirtualElement" + "Popped from stack by PlaceHolder: " + component);
            }
        }
    }

    public static void addParameterCallbacks(Map parameters, IStackElement element) {
        VirtualStackCursor cursor = VirtualStack.getStack();
        StackDecoration sd = (StackDecoration)cursor.decoration.get(element);
        if (sd != null) {
            parameters.putAll(sd.parameters);
            for (IComponentParameterCallback callback : sd.callbacks) {
                callback.IComponentParameterCallback_addParameters(parameters);
            }
        }
    }

    public static void abortTransaction() {
        VirtualStack.getTransactionCache().setAborted();
    }

    @Override
    public IBoundaryBlameStackHelper getCurrentThreadHelper() {
        return VirtualStack.getStack().transactionCache;
    }

    @Override
    public ITransactionCache getCurrentCache() {
        return VirtualStack.getStack().transactionCache;
    }

    @Override
    public ITransactionCacheProvider getProvider() {
        return VirtualStack.getStack();
    }

    @Override
    public IStackElement getTopOfStack() {
        return VirtualStack.getStack().data;
    }

    public static void clear() {
        VirtualStackCursor cursor = VirtualStack.getStack();
        cursor.clear();
        AppMapCursor cursor1 = VirtualStack.getAppMapStack();
        cursor1.clear();
    }

    private static class ADefaultTransactionElementProvider
    implements ITransactionElementProvider {
        static final ADefaultTransactionElementProvider kInstance = new ADefaultTransactionElementProvider();

        private ADefaultTransactionElementProvider() {
        }

        @Override
        public ITransactionElement getElement(Object key, ITransactionElement parent) {
            return null;
        }

        @Override
        public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            return new WilyBridgeTransactionElement(key.toString(), false, parent, null, (IBlameTransactionElement)data.getStartCursorAt(tracerIndex));
        }

        @Override
        public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            return new WilyBridgeTransactionElement(key.toString(), true, parent, BlamePointTracer.getPreviousBlamePoint(parent), null);
        }
    }

    private static class ADefaultTransactionInstanceProvider
    implements ITransactionInstanceProvider {
        static final ADefaultTransactionInstanceProvider kInstance = new ADefaultTransactionInstanceProvider();

        private ADefaultTransactionInstanceProvider() {
        }

        @Override
        public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
            ArrayList current = VirtualStack.getStack().transactionCache.transactionInstanceList;
            int position = data.getStartInstancePositionAt(tracerIndex);
            if (position >= 0) {
                WilyStartTransactionInstance start = (WilyStartTransactionInstance)current.get(position);
                WilyEndTransactionInstance instance = new WilyEndTransactionInstance(data.getWallClockElapsedTime(), newElement, start);
                current.add(instance);
            }
        }

        @Override
        public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
            WilyStartTransactionInstance instance = new WilyStartTransactionInstance(data, newElement);
            ArrayList current = VirtualStack.getStack().transactionCache.transactionInstanceList;
            data.setStartInstancePositionAt(current.size(), tracerIndex);
            current.add(instance);
        }

        @Override
        public void suggestEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
            if (WilyTransactionStructure.getInstance().shouldTraceTransactionInstances(data)) {
                TransactionHarvestHelper.doHarvest(WilyTransactionStructure.getInstance(), data);
            } else {
                TransactionHarvestHelper.submitTransactionToCache(data);
            }
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    public static class AppMapCursor {
        public volatile InvocationData data;
        public CrossCorrelationStringParameterProvider provider;

        public void clear() {
            this.data = null;
            this.provider = null;
        }
    }

    public static class DummyVirtualElement
    extends VirtualElement
    implements INotAnOldModeStallSubscriber {
        private IStackElement immediateNonDummyParent;

        protected DummyVirtualElement(String componentName, IStackElement parent, ITransactionCache cache) {
            super(componentName, parent, cache);
            this.immediateNonDummyParent = parent instanceof DummyVirtualElement ? ((DummyVirtualElement)parent).getImmediateNonDummyParent() : parent;
        }

        public IStackElement getImmediateNonDummyParent() {
            return this.immediateNonDummyParent;
        }
    }

    public static class ExternalThreadIdThreadLocal {
        public String tid;
        public Object conn;
    }

    private static final class ExternalThreadMapEntry {
        public VirtualStackCursor vc;
        public AppMapCursor ac;
        public Runnable thread;
        public Object connection;
        public Object[] tlo;

        private ExternalThreadMapEntry() {
        }
    }

    public static class MaxDecorationsProperty
    extends IntegerConfigurationProperty {
        volatile int value;

        private MaxDecorationsProperty(IAgent agent) {
            super("wily.VirtualStackCursor.maxDecorations", 5000, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            this.value = (Integer)newValue;
        }
    }

    public static class MaxInvocationDatasFromWebServicesProperty
    extends IntegerConfigurationProperty {
        volatile int value;

        private MaxInvocationDatasFromWebServicesProperty(IAgent agent) {
            super("wily.TransactionCache.maxInvocationDatasFromWebServices", 20, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            this.value = (Integer)newValue;
        }
    }

    public static class MaxStackElementsCallerHasSeenProperty
    extends IntegerConfigurationProperty {
        volatile int value;

        private MaxStackElementsCallerHasSeenProperty(IAgent agent) {
            super("wily.TransactionCache.maxCallerHasSeenStackElements", 20, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            this.value = (Integer)newValue;
        }
    }

    static class StackDecoration {
        final ConcurrentHashMap parameters = new ConcurrentHashMap();
        final ConcurrentLinkedQueue callbacks = new ConcurrentLinkedQueue();

        StackDecoration() {
        }
    }

    public static class TransactionCache
    implements ITransactionCache,
    IBoundaryBlameStackHelper {
        static int sMaxDBConnections = 100;
        static int sMaxCallerHasSeenStackElements;
        WeakWeakIdentityHashMap fCallerHasSeenStackElementMap = new WeakWeakIdentityHashMap(4);
        private Runnable fThread;
        private IStackElement fRoot;
        public boolean fHasAlreadyCheckedAppMapLazyName;
        private boolean isDownstreamServletTracing = true;
        private boolean isServletTracingInProgress;
        private int fServletStackDepthValue;
        public final ArrayList transactionInstanceList = new ArrayList(16);
        private final WeakIdentityHashMap fCache = new WeakIdentityHashMap(4);
        private final HashSet fErrorsSeenInThisTxn;
        private IBizTrx fBizTrx;
        private boolean fAborted = false;
        public Object startComponent;
        private ITransactionElement fFirstElement;
        private boolean fVirtualElementEndedTxn = false;
        TransactionCollectStatus tcs;
        private Map.Entry[] fPendingFilterArray = null;
        private Object[] fPendingFilterStatusArray = null;
        private ITransactionTraceFilter[] fTailFilterArray = null;
        private StallPoint fStallPoint;
        private int hashcode;
        private volatile BoundaryBlameStack fBoundaryBlameStack;
        private String fFrontendString;
        private String fBackendString;
        private String fEntryPointString;
        private int fBackendsCount;
        private final InvocationData.InvocationDataThreadLocal fInvocationDataThreadLocal;
        private boolean fCorrelationIdWasInvoked;
        private AutoTracingCollectStatus fAutoTCS;
        static int sMaxInvocationDatasFromWebServices;
        private List fInvocationDatasFromWebServices = new ArrayList(1);
        private InvocationData.ServletSupportClass fServletSupport;
        private boolean fCrossProcessElementEndedTxn = false;
        private boolean fTriggerHeadFilterPass;
        private boolean fMarkedForDiscoveryTrace = false;

        static {
            ConfigurationManager cm = fAgent.IAgent_getConfigurationManager();
            MaxDBConnectionsProperty maxElements = new MaxDBConnectionsProperty(fAgent);
            cm.add(maxElements, true);
            sMaxCallerHasSeenStackElements = TransactionCache.initializeMaxStackElementsCallerHasSeen();
            sMaxInvocationDatasFromWebServices = TransactionCache.initializeMaxInvocationDatasFromWebServices();
        }

        static int initializeMaxStackElementsCallerHasSeen() {
            ConfigurationManager cm = fAgent.IAgent_getConfigurationManager();
            MaxStackElementsCallerHasSeenProperty maxElements = new MaxStackElementsCallerHasSeenProperty(fAgent);
            cm.add(maxElements, true);
            return maxElements.value;
        }

        public TransactionCache(Runnable t) {
            this.fThread = t;
            this.initializeStallPoint();
            this.initializeHashCode();
            this.fInvocationDataThreadLocal = new InvocationData.InvocationDataThreadLocal();
            this.fErrorsSeenInThisTxn = new CacheHashSet(2, ErrorFeature.getMaxErrorCacheSize(fAgent));
        }

        private void initializeHashCode() {
            this.hashcode = this.fThread == null ? Thread.currentThread().hashCode() : this.fThread.hashCode();
        }

        @Override
        public Runnable getThread() {
            return this.fThread;
        }

        @Override
        public void setThread(Runnable t) {
            this.fThread = t;
        }

        private void initializeStallPoint() {
            this.fStallPoint = StallFeatureBase.initializeStallPoint(this.fThread);
        }

        public void clear() {
            this.fHasAlreadyCheckedAppMapLazyName = false;
            this.isDownstreamServletTracing = true;
            this.isServletTracingInProgress = false;
            this.fServletStackDepthValue = 0;
            this.fRoot = null;
            this.fFirstElement = null;
            this.fBizTrx = null;
            this.fCache.clear();
            if (this.fErrorsSeenInThisTxn.size() > 0) {
                this.fErrorsSeenInThisTxn.clear();
            }
            if (this.isTransactionAborted()) {
                this.initializeStallPoint();
            }
            this.setNotAborted();
            TransactionCollectStatus tcs = VirtualStack.getTransactionCollectStatus();
            if (tcs != null) {
                FilterController.resetTransactionCollectStatusValues(tcs, false, false, 0);
            }
            this.transactionInstanceList.clear();
            this.transactionInstanceList.trimToSize();
            this.fFrontendString = null;
            this.fBackendString = null;
            this.fEntryPointString = null;
            this.fBackendsCount = 0;
            this.fServletSupport = null;
            this.fCorrelationIdWasInvoked = false;
            if (this.fInvocationDatasFromWebServices.size() > 0) {
                this.fInvocationDatasFromWebServices.clear();
            }
            this.fTriggerHeadFilterPass = false;
            this.fMarkedForDiscoveryTrace = false;
            this.fCallerHasSeenStackElementMap.clear();
            this.fAutoTCS = null;
        }

        static int initializeMaxInvocationDatasFromWebServices() {
            ConfigurationManager cm = fAgent.IAgent_getConfigurationManager();
            MaxInvocationDatasFromWebServicesProperty maxInvocationDatas = new MaxInvocationDatasFromWebServicesProperty(fAgent);
            cm.add(maxInvocationDatas, true);
            return maxInvocationDatas.value;
        }

        public boolean isfTriggerHeadFilterPass() {
            return this.fTriggerHeadFilterPass;
        }

        public void setfTriggerHeadFilterPass(boolean fTriggerHeadFilterPass) {
            this.fTriggerHeadFilterPass = fTriggerHeadFilterPass;
        }

        public boolean isVirtualElementEndedTxn() {
            return this.fVirtualElementEndedTxn;
        }

        public void setfVirtualElementEndedTxn(boolean virtualElementEndedTxn) {
            this.fVirtualElementEndedTxn = virtualElementEndedTxn;
        }

        public void disableDownstreamServletTracing() {
            this.isDownstreamServletTracing = false;
        }

        public void enableDownstreamServletTracing() {
            this.isDownstreamServletTracing = true;
        }

        public boolean isDownstreamServletTracing() {
            return this.isDownstreamServletTracing;
        }

        public void clearServletTracingInProgress() {
            this.isServletTracingInProgress = false;
        }

        public void setServletTracingInProgress() {
            this.isServletTracingInProgress = true;
        }

        public boolean isServletTracingInProgress() {
            return this.isServletTracingInProgress;
        }

        public int getStackDepthValue() {
            return this.fServletStackDepthValue;
        }

        public void incrementStackDepth() {
            ++this.fServletStackDepthValue;
        }

        public void decrementStackDepth() {
            --this.fServletStackDepthValue;
        }

        public void setRoot(IStackElement fRoot) {
            this.fRoot = fRoot;
        }

        public IStackElement getRoot() {
            return this.fRoot;
        }

        public IBizTrx getBizTrx() {
            return this.fBizTrx;
        }

        public void setBizTrx(IBizTrx bizTrx) {
            this.fBizTrx = bizTrx;
        }

        @Override
        public HashSet getErrorsSeenInThisTxn() {
            return this.fErrorsSeenInThisTxn;
        }

        @Override
        public List getTransactionInstanceList() {
            return this.transactionInstanceList;
        }

        @Override
        public boolean isTransactionAborted() {
            return this.fAborted;
        }

        public void setAborted() {
            this.fAborted = true;
        }

        public void setNotAborted() {
            this.fAborted = false;
        }

        @Override
        public boolean isMarkedForDiscoveryTrace() {
            return this.fMarkedForDiscoveryTrace;
        }

        @Override
        public void setMarkedForDiscoveryTrace(boolean setDiscoveryTrace) {
            this.fMarkedForDiscoveryTrace = setDiscoveryTrace;
        }

        @Override
        public Object putInCache(Object key, Object value) {
            if (sMaxDBConnections <= 0) {
                return value;
            }
            if (this.fCache.size() >= sMaxDBConnections) {
                if (fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                    fAgent.IAgent_getModuleFeedback().debug(kModule, "Clearing TransactionCache.fCache which has " + this.fCache.size() + " elements. Maximum number of connections cached are: " + sMaxDBConnections);
                }
                this.fCache.clear();
            }
            return this.fCache.put(key, value);
        }

        @Override
        public Object getFromCache(Object key) {
            return this.fCache.get(key);
        }

        @Override
        public TransactionCollectStatus getTransactionCollectionStatus() {
            return this.tcs;
        }

        @Override
        public void setTransactionCollectStatus(TransactionCollectStatus tcs) {
            tcs.setTransactionCache(this);
            this.tcs = tcs;
        }

        @Override
        public void setStartTransactionElement(ITransactionElement fFirstElement) {
            this.fFirstElement = fFirstElement;
        }

        @Override
        public ITransactionElement getStartTransactionElement() {
            return this.fFirstElement;
        }

        @Override
        public Map.Entry[] getPendingFilterArray() {
            return this.fPendingFilterArray;
        }

        @Override
        public Object[] getPendingFilterStatusArray() {
            return this.fPendingFilterStatusArray;
        }

        @Override
        public void setPendingFilterArray(Map.Entry[] pendingFilterArray, Object[] pendingFilterStatusArray) {
            this.fPendingFilterArray = pendingFilterArray;
            this.fPendingFilterStatusArray = pendingFilterStatusArray;
        }

        @Override
        public ITransactionTraceFilter[] getfTailFilterArray() {
            return this.fTailFilterArray;
        }

        @Override
        public void setfTailFilterArray(ITransactionTraceFilter[] fTailFilterArray) {
            this.fTailFilterArray = fTailFilterArray;
        }

        @Override
        public IStallPoint getStallPoint() {
            return this.fStallPoint;
        }

        @Override
        public int getThreadHashCode() {
            return this.hashcode;
        }

        @Override
        public void setBoundaryBlameStack(BoundaryBlameStack boundaryBlameStack) {
            this.fBoundaryBlameStack = boundaryBlameStack;
        }

        @Override
        public void signalNewFrontend(String fHeadNode) {
            this.fFrontendString = fHeadNode;
        }

        @Override
        public void signalNewBackend(String fEndNode) {
            this.fBackendString = fEndNode;
        }

        @Override
        public void setFrontBoundary(String frontend) {
            if (this.fBoundaryBlameStack != null) {
                this.fBoundaryBlameStack.setFrontBoundary(frontend);
                if (frontend.equals(this.fFrontendString)) {
                    this.fBoundaryBlameStack.addVetoedFrontendInErrors(frontend);
                }
            } else {
                this.fFrontendString = frontend;
            }
        }

        @Override
        public void setEndBoundary(String backend) {
            if (this.fBoundaryBlameStack != null) {
                this.fBoundaryBlameStack.setEndBoundary(backend);
                if (backend.equals(this.fBackendString)) {
                    this.fBoundaryBlameStack.addVetoedBackendInErrors(backend);
                }
            } else {
                this.fBackendString = backend;
            }
        }

        @Override
        public void setEntryPointBoundary(String entryPoint) {
            this.fEntryPointString = entryPoint;
        }

        @Override
        public void unsetFrontBoundary(String frontend) {
            if (this.fBoundaryBlameStack != null) {
                this.fBoundaryBlameStack.unsetFrontBoundary(frontend);
                if (this.fFrontendString == null) {
                    this.fBoundaryBlameStack.removeVetoedFrontendInErrors();
                }
            } else {
                this.fFrontendString = null;
            }
        }

        @Override
        public void unsetEndBoundary(String backend) {
            if (this.fBoundaryBlameStack != null) {
                this.fBoundaryBlameStack.unsetEndBoundary(backend);
                if (this.fBackendString == null) {
                    this.fBoundaryBlameStack.removeVetoedBackendInErrors();
                }
            } else {
                this.fBackendString = null;
            }
        }

        @Override
        public void unsetEntryPointBoundary(String entryPoint) {
            this.fEntryPointString = null;
        }

        @Override
        public String getFrontend() {
            return this.fFrontendString;
        }

        @Override
        public String getBackend() {
            return this.fBackendString;
        }

        @Override
        public String getEntryPoint() {
            return this.fEntryPointString;
        }

        @Override
        public void signalFrontendPopped(String fHeadNode) {
            this.fFrontendString = null;
        }

        @Override
        public void signalBackendPopped(String fEndNode) {
            this.fBackendString = null;
        }

        @Override
        public boolean isInBackend() {
            return this.fBackendString != null;
        }

        @Override
        public int incrementAndGetBackendsCount() {
            return ++this.fBackendsCount;
        }

        @Override
        public int decrementAndGetBackendsCount() {
            return --this.fBackendsCount;
        }

        public int getBackendsCount() {
            return this.fBackendsCount;
        }

        @Override
        public void incrementErrorMetric() {
            if (this.fBoundaryBlameStack != null) {
                this.fBoundaryBlameStack.noteBoundaryError();
            }
        }

        public void setCorrelationIdWasInvoked() {
            this.fCorrelationIdWasInvoked = true;
        }

        @Override
        public boolean isCorrelationIdWasInvoked() {
            return this.fCorrelationIdWasInvoked;
        }

        @Override
        public void addStackElementForNotificationOnCrossCorrelation(InvocationData data) {
            if (this.fInvocationDatasFromWebServices.size() > sMaxInvocationDatasFromWebServices && sMaxInvocationDatasFromWebServices > 0) {
                fAgent.IAgent_getModuleFeedback().debug(kModule, "Clearing TransactionCache.fInvocationDatasFromWebServices which has " + this.fInvocationDatasFromWebServices.size() + " elements, more than max allowed: " + sMaxInvocationDatasFromWebServices);
                this.fInvocationDatasFromWebServices.clear();
            }
            this.fInvocationDatasFromWebServices.add(data);
        }

        @Override
        public void notifyStackElementOfNewCrossCorrelation(Object key) {
            for (IStackElement element : this.fInvocationDatasFromWebServices) {
                if (!(element instanceof InvocationData)) continue;
                ((InvocationData)element).setHasNewCursor();
            }
            this.fInvocationDatasFromWebServices.clear();
            ((ArrayList)this.fInvocationDatasFromWebServices).trimToSize();
        }

        @Override
        public InvocationData.InvocationDataThreadLocal getInvocationDataThreadLocal() {
            return this.fInvocationDataThreadLocal;
        }

        public boolean isCrossCorrelationElementEndedTxn() {
            return this.fCrossProcessElementEndedTxn;
        }

        public void setfCrossCorrelationElementEndedTxn(boolean crossCorrelationElementEndedTxn) {
            this.fCrossProcessElementEndedTxn = crossCorrelationElementEndedTxn;
        }

        public boolean hasCallerSeenStackElement(Object caller, IStackElement data) {
            if (data == null) {
                return false;
            }
            if (this.fCallerHasSeenStackElementMap.size() > sMaxCallerHasSeenStackElements && sMaxCallerHasSeenStackElements > 0) {
                fAgent.IAgent_getModuleFeedback().debug(kModule, "Clearing TransactionCache.fCallerHasSeenStackElementMap which has " + this.fCallerHasSeenStackElementMap.size() + " elements, more than max allowed: " + sMaxCallerHasSeenStackElements);
                this.fCallerHasSeenStackElementMap.clear();
            }
            return data == (IStackElement)this.fCallerHasSeenStackElementMap.put(caller, data);
        }

        public int getSizeOfCallerHasSeenStackElementMap() {
            return this.fCallerHasSeenStackElementMap.size();
        }

        @Override
        public void setServletSupport(InvocationData.ServletSupportClass servletSupport) {
            if (this.fServletSupport == null) {
                this.fServletSupport = servletSupport;
            }
        }

        @Override
        public InvocationData.ServletSupportClass getServletSupport() {
            return this.fServletSupport;
        }

        @Override
        public AutoTracingCollectStatus getAutoTracingCollectStatus() {
            return this.fAutoTCS;
        }

        @Override
        public void setAutoTracingCollectStatus(AutoTracingCollectStatus aTCS) {
            this.fAutoTCS = aTCS;
        }

        static class MaxDBConnectionsProperty
        extends PositiveIntegerConfigurationProperty {
            private MaxDBConnectionsProperty(IAgent agent) {
                super("wily.TransactionCache.maxDBConnections", 100, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
            }

            @Override
            public void set(Object newValue) {
                int value = (Integer)newValue;
                if (value < 0) {
                    fAgent.IAgent_getModuleFeedback().debug("Invalid value set for the property wily.TransactionCache.maxDBConnections. Hence ignoring the value");
                    return;
                }
                sMaxDBConnections = value;
            }
        }
    }

    private static final class TxnElementRecursionHelper
    implements ITransactionElementCallbackOnRecursion {
        private TxnElementRecursionHelper() {
        }

        @Override
        public boolean doOnElement(ITransactionElement pivot) {
            if (pivot == null) {
                return true;
            }
            if (pivot.isNotValid()) {
                VirtualStack.abortTransaction();
                return true;
            }
            return false;
        }
    }

    public static class VirtualElement
    implements IStackElement,
    IOldModeStallSubscriber {
        private long fWallClockElapsedTime;
        private long fWallClockFinishTime;
        private final long fWallClockStartTime;
        private long fWallClockStartTransactionTime;
        private final IStackElement fParent;
        private final String fComponentName;
        private final Runnable fThread;
        private String fstallDefaultBackendComponentName;
        private ITransactionElement fStartCursor;
        private volatile ITransactionElement fCursor;
        private volatile boolean fIsStalled;
        private IInvocationDataParameterCallback fCallback;
        private int position;
        private final ITransactionCache fCache;
        private Set fSocketSet;
        private final BlameStackSnapshot snap;
        private volatile BlameStackSnapshot fUsedForStall;
        private Map fDataStorage = new HashMap(4);

        private VirtualElement(String componentName, IStackElement parent, ITransactionCache cache) {
            this.fComponentName = componentName;
            this.fParent = parent;
            this.fCache = cache;
            if (this.fParent == null) {
                this.fThread = Thread.currentThread();
            } else {
                Runnable t = this.fParent.getMyThread();
                if (t == null) {
                    t = Thread.currentThread();
                }
                this.fThread = t;
                this.fCursor = this.fParent.getCursor();
            }
            this.fWallClockStartTime = MasterClock.currentTimeMillis();
            this.fWallClockStartTransactionTime = -1L;
            this.fWallClockFinishTime = -1L;
            this.fWallClockElapsedTime = -1L;
            this.snap = this.computeSnapshot();
        }

        private BlameStackSnapshot computeSnapshot() {
            BlameStackSnapshot result = BlameStackSnapshot.kEmptyBlameStackSnapshot;
            if (this.fCache.getFrontend() != null) {
                result = BlameStackSnapshot.getBlameStackSnapshot(BlameStackSnapshot.kEmptyBlameStackSnapshot, this.fCache.getFrontend());
            }
            return result;
        }

        @Override
        public Object get(String name) {
            return this.fDataStorage.get(name);
        }

        @Override
        public Object put(String name, Object value) {
            return this.fDataStorage.put(name, value);
        }

        @Override
        public String getComponentName() {
            return this.fComponentName;
        }

        @Override
        public ITransactionElement getCursor() {
            return this.fCursor;
        }

        @Override
        public Iterator getStartCursorsIterator() {
            return Arrays.asList(this.fStartCursor).iterator();
        }

        @Override
        public Runnable getMyThread() {
            return this.fThread;
        }

        @Override
        public IStackElement getParent() {
            return this.fParent;
        }

        @Override
        public ITransactionElement getStartCursorAt(int j) {
            return this.fStartCursor;
        }

        @Override
        public int getStartCursorsCount() {
            return 1;
        }

        @Override
        public long getWallClockElapsedTime() {
            if (this.fWallClockElapsedTime < 0L) {
                this.fWallClockElapsedTime = this.getWallClockFinishTime() - this.getWallClockStartTime();
            }
            return this.fWallClockElapsedTime;
        }

        @Override
        public long getWallClockFinishTime() {
            if (this.fWallClockFinishTime < 0L) {
                this.setWallClockFinishTime(MasterClock.currentTimeMillis());
            }
            return this.fWallClockFinishTime;
        }

        @Override
        public long getWallClockStartTime() {
            return this.fWallClockStartTime;
        }

        public void setWallClockFinishTime(long value) {
            this.fWallClockFinishTime = value;
        }

        @Override
        public boolean hasInvocationThrownException() {
            return false;
        }

        @Override
        public boolean isStalled() {
            return this.fIsStalled;
        }

        @Override
        public void unsetStalled() {
            this.fIsStalled = false;
        }

        public void setEndCursor(ITransactionElement cursor) {
        }

        @Override
        public void setParameterCallback(IInvocationDataParameterCallback invocationDataCallback) {
            if (invocationDataCallback instanceof ICrossProcessCallback) {
                this.fCallback = invocationDataCallback;
            }
        }

        @Override
        public void setStalled() {
            this.fIsStalled = true;
        }

        @Override
        public void addParameterCallbacks(Map parameters) {
            if (this.fCallback != null) {
                ICrossProcessCallback callback = (ICrossProcessCallback)((Object)this.fCallback);
                callback.IInvocationDataParameterCallback_addParameters(this, parameters);
            }
        }

        @Override
        public void setCursor(ITransactionElement cursor) {
            this.fCursor = cursor;
        }

        public void setStartCursor(ITransactionElement cursor) {
            this.fStartCursor = cursor;
        }

        @Override
        public void markStartTransaction() {
            if (this.fWallClockStartTransactionTime < 0L) {
                this.fWallClockStartTransactionTime = MasterClock.currentTimeMillis();
            }
        }

        @Override
        public boolean hasFrontBoundary() {
            return this.fCache.getFrontend() != null;
        }

        @Override
        public ITransactionElement getLastFrontendCursor() {
            return null;
        }

        @Override
        public void setLastFrontendCursor(ITransactionElement frontendCursor) {
        }

        @Override
        public void setStartInstancePositionAt(int pos, int tracerIndex) {
            this.position = pos;
        }

        @Override
        public int getStartInstancePositionAt(int tracerIndex) {
            return this.position;
        }

        @Override
        public Map getParameterCallbacks(Map parameters) {
            this.addParameterCallbacks(parameters);
            return parameters;
        }

        @Override
        public List getTransactionInstanceList() {
            return VirtualStack.getStack().transactionCache.transactionInstanceList;
        }

        @Override
        public boolean isTransactionAborted() {
            if (this.fCache == null) {
                if (this.fCursor == null) {
                    return false;
                }
                return this.fCursor.isNotValid();
            }
            if (this.fCache.isTransactionAborted()) {
                return true;
            }
            if (this.fCursor == null) {
                return false;
            }
            return this.fCursor.isNotValid();
        }

        @Override
        public TransactionCollectStatus getTransactionCollectionStatus() {
            return this.fCache.getTransactionCollectionStatus();
        }

        @Override
        public void setTransactionCollectStatus(TransactionCollectStatus tcs) {
            this.fCache.setTransactionCollectStatus(tcs);
        }

        @Override
        public ITransactionElement getStartTransactionElement() {
            return this.fCache.getStartTransactionElement();
        }

        @Override
        public void setStartTransactionElement(ITransactionElement element) {
            this.fCache.setStartTransactionElement(element);
        }

        @Override
        public IStallPoint getStallPoint() {
            return this.fCache.getStallPoint();
        }

        public BlameStackSnapshot getBlameSnapshot() {
            if (this.fUsedForStall == null) {
                this.fUsedForStall = this.computeStallSnapshot();
            }
            return this.fUsedForStall;
        }

        @Override
        public IIntegerFluctuatingCounterDataAccumulatorWrapper getSubscriptionStallAccumulator(boolean isStalledItself) {
            final BlameStackSnapshot fUsedForStallLocal = this.computeStallSnapshot();
            if (isStalledItself) {
                if (this.fstallDefaultBackendComponentName != null) {
                    return new IIntegerFluctuatingCounterDataAccumulatorWrapper(){

                        @Override
                        public IIntegerFluctuatingCounterDataAccumulator getAccumulator() {
                            return fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(VirtualElement.this.fstallDefaultBackendComponentName);
                        }

                        @Override
                        public BlameStackSnapshot getSnapshot() {
                            return fUsedForStallLocal;
                        }
                    };
                }
                return new IIntegerFluctuatingCounterDataAccumulatorWrapper(){

                    @Override
                    public IIntegerFluctuatingCounterDataAccumulator getAccumulator() {
                        return fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(VirtualElement.this.getStallComponentName());
                    }

                    @Override
                    public BlameStackSnapshot getSnapshot() {
                        return fUsedForStallLocal;
                    }
                };
            }
            if (this.fComponentName.equals(this.fCache.getFrontend()) || this.fComponentName.equals(this.fCache.getBackend())) {
                return new IIntegerFluctuatingCounterDataAccumulatorWrapper(){

                    @Override
                    public IIntegerFluctuatingCounterDataAccumulator getAccumulator() {
                        return fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(VirtualElement.this.getStallComponentName());
                    }

                    @Override
                    public BlameStackSnapshot getSnapshot() {
                        return fUsedForStallLocal;
                    }
                };
            }
            if (this.fstallDefaultBackendComponentName != null) {
                return new IIntegerFluctuatingCounterDataAccumulatorWrapper(){

                    @Override
                    public IIntegerFluctuatingCounterDataAccumulator getAccumulator() {
                        return fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(VirtualElement.this.fstallDefaultBackendComponentName);
                    }

                    @Override
                    public BlameStackSnapshot getSnapshot() {
                        return fUsedForStallLocal;
                    }
                };
            }
            return null;
        }

        private String getStallComponentName() {
            return new WilyStringBuilder(128).append(this.fComponentName).append(":").append("Stall Count").toString();
        }

        private BlameStackSnapshot computeStallSnapshot() {
            if (this.snap == BlameStackSnapshot.kEmptyBlameStackSnapshot) {
                return this.snap;
            }
            if (this.fComponentName.equals(this.fCache.getBackend()) || this.fstallDefaultBackendComponentName != null) {
                return this.snap;
            }
            return BlameStackSnapshot.kEmptyBlameStackSnapshot;
        }

        @Override
        public void addAppMapSocketCursor(ITransactionElement result) {
            if (this.fSocketSet == null) {
                this.fSocketSet = new HashSet(2);
            }
            this.fSocketSet.add(result);
            this.fstallDefaultBackendComponentName = String.valueOf(((SocketTransactionElement)result).getComponentName()) + ":" + "Stall Count";
        }

        @Override
        public Iterator getAppMapSocketCursors() {
            if (this.fSocketSet != null) {
                return this.fSocketSet.iterator();
            }
            return null;
        }

        @Override
        public void notifyStackElementOfNewCrossCorrelation(Object key) {
            this.fCache.notifyStackElementOfNewCrossCorrelation(key);
        }

        @Override
        public boolean isFinished() {
            return false;
        }

        @Override
        public void setFinished(boolean finished) {
        }

        @Override
        public void setMarkedForDiscoveryTrace(boolean discoveryTrace) {
            this.fCache.setMarkedForDiscoveryTrace(discoveryTrace);
        }

        @Override
        public boolean isMarkedForDiscoveryTrace() {
            return this.fCache.isMarkedForDiscoveryTrace();
        }

        /* synthetic */ VirtualElement(String string, IStackElement iStackElement, ITransactionCache iTransactionCache, VirtualElement virtualElement, VirtualElement virtualElement2) {
            this(string, iStackElement, iTransactionCache);
        }
    }

    static class VirtualStackCursor
    implements ITransactionCacheProvider {
        public volatile boolean isCurrent;
        volatile boolean decorationClampHit;
        volatile IStackElement data;
        final ConcurrentHashMap decoration = new ConcurrentHashMap();
        final TransactionCache transactionCache;
        static int sMaxDecorations = VirtualStackCursor.initializeMaxDecorations();

        private VirtualStackCursor(Runnable t) {
            this.transactionCache = new TransactionCache(t);
        }

        @Override
        public ITransactionCache getCurrentCache() {
            return this.transactionCache;
        }

        @Override
        public IStackElement getTopOfStack() {
            return this.data;
        }

        public void clear() {
            this.isCurrent = false;
            this.decorationClampHit = false;
            this.data = null;
            this.decoration.clear();
            this.transactionCache.clear();
        }

        static int initializeMaxDecorations() {
            ConfigurationManager cm = fAgent.IAgent_getConfigurationManager();
            MaxDecorationsProperty maxDecorations = new MaxDecorationsProperty(fAgent);
            cm.add(maxDecorations, true);
            return maxDecorations.value;
        }
    }

    private static class WilyBridgeTransactionElement
    extends WilyTransactionElement {
        private WilyBridgeTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository timerDataStructure, IRepository perIntervalDataStructure, IRepository concurrentInvocationDataStructure, IRepository errorsDataStructure, IRepository stallsDataStructure, ProbeInformation info, String nodeType, String ownerType, String appMapName, String btcMapName, String nodeLevel, String boundaryType) {
            super(key, componentName, blameStatus, isStartTrace, parent, previous, start, agentMetrics, timerDataStructure, perIntervalDataStructure, concurrentInvocationDataStructure, errorsDataStructure, stallsDataStructure, info, false, false, Long.MAX_VALUE);
        }

        public WilyBridgeTransactionElement(String component, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start) {
            this(component, component, 0, isStartTrace, parent, previous, start, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

