/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IMetricHolder;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.properties.AttributeListing;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ASingleMetricTracerFactory
extends ASingleInstanceTracerFactoryHC
implements ITransactionElementProvider {
    private static final String kHighConcurrency = "highconcurrency";
    private final ReentrancyLevel fReentrancyLevel;
    protected final boolean fHighConcurrency;
    private final boolean fUseBlame;
    private final AtomicReference fPrivateMetrics = new AtomicReference<Object>(null);

    public ASingleMetricTracerFactory(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
        this.fUseBlame = this.calculateUseBlame(false);
        this.fHighConcurrency = this.calculateBooleanParameter(kHighConcurrency, false);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (this.useBlame() || !this.canUseCaching()) {
            if (data.getMyThread() == null) {
                data.setMyThread(Thread.currentThread());
            }
            this.submitToTransactionStructureOnStartTrace(tracerIndex, data, this);
        } else {
            try {
                ASingleSharedMetricHolder mh = (ASingleSharedMetricHolder)this.fPrivateMetrics.get();
                if (mh == null) {
                    if (this.fShouldUseSharedMetrics) {
                        mh = new ASingleSharedMetricHolder();
                        this.getRepository(data, mh);
                    } else {
                        mh = new ASinglePrivateMetricHolder();
                        this.getRepository(data, mh);
                    }
                    boolean succededSet = this.fPrivateMetrics.compareAndSet(null, mh);
                    if (!this.fShouldUseSharedMetrics && succededSet) {
                        this.getWilyTransactionStructureInstance().privateMetricHolder.add(mh);
                    }
                }
                this.doOnStartTrace(tracerIndex, (IStackElement)data, mh);
            }
            catch (TransactionTransitionException e) {
                this.getAgent().IAgent_getModuleFeedback().debug(e);
            }
        }
    }

    protected abstract IRepository getRepository(InvocationData var1, ISharedMetricHolder var2);

    protected abstract void doOnStartTrace(int var1, IStackElement var2, ISingleMetricHolder var3);

    protected abstract void doOnEndTrace(int var1, IStackElement var2, ISingleMetricHolder var3);

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.useBlame() || !this.canUseCaching()) {
            this.submitToTransactionStructureOnEndTrace(tracerIndex, data, this);
        } else {
            try {
                this.doOnEndTrace(tracerIndex, (IStackElement)data, (ISingleMetricHolder)this.fPrivateMetrics.get());
            }
            catch (TransactionTransitionException e) {
                this.getAgent().IAgent_getModuleFeedback().debug(e);
            }
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        IRepository rep;
        ASingleSharedMetricHolder mh = (ASingleSharedMetricHolder)this.fPrivateMetrics.get();
        if (mh != null && (rep = mh.getRepository()) != null) {
            return rep.isShutOff();
        }
        return false;
    }

    protected boolean useBlame() {
        return this.fUseBlame;
    }

    @Override
    public ITransactionElement getElement(Object key, ITransactionElement parent) {
        return this.getElementOnStartTrace(key, 0, null, parent);
    }

    @Override
    public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement stackElement, ITransactionElement parent) {
        if (stackElement instanceof InvocationData) {
            InvocationData data = (InvocationData)stackElement;
            BlameTransactionElement result = null;
            if (this.fShouldUseSharedMetrics) {
                ASingleSharedMetricHolder mh = new ASingleSharedMetricHolder();
                this.getRepository(data, mh);
                IMetricHolder correspondingMetricHolderForBlameElement = mh.getCorrespondingMetricHolder();
                result = new BlameTransactionElement(this.getComponentName(data), true, 0, parent, null, null, correspondingMetricHolderForBlameElement);
            } else {
                ASinglePrivateMetricHolder mh = new ASinglePrivateMetricHolder();
                this.getRepository(data, mh);
                result = new BlameTransactionElement(this.getComponentName(data), true, 0, parent, null, null, mh);
            }
            data.setStartCursorAt(result, tracerIndex);
            return result;
        }
        throw new TransactionTransitionException("Element is not a invocation data");
    }

    @Override
    public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
        BlameTransactionElement startTrace = (BlameTransactionElement)data.getStartCursorAt(tracerIndex);
        BlameTransactionElement result = new BlameTransactionElement(startTrace.getComponentName(), false, 0, parent, null, (IBlameTransactionElement)startTrace, startTrace.getMetricHolder());
        return result;
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
        ((InvocationData)data).setStartCursorAt(element, tracerIndex);
        this.doOnStartTrace(tracerIndex, data, (ISingleMetricHolder)((Object)((BlameTransactionElement)element).getMetricHolder()));
    }

    @Override
    public void doOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
        this.doOnEndTrace(tracerIndex, data, (ISingleMetricHolder)((Object)((BlameTransactionElement)element).getMetricHolder()));
    }

    @Override
    public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
        if (this.useBlame()) {
            super.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, newElement);
        }
    }

    @Override
    public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
        if (this.useBlame()) {
            super.offerNewTransactionInstanceElementOnEndTrace(tracerIndex, data, newElement);
        }
    }

    @Override
    protected void doOnAbortedTransactionEndTrace(int tracerIndex, IStackElement data) {
    }

    class ASinglePrivateMetricHolder
    extends ASingleSharedMetricHolder
    implements IMetricHolder {
        ASinglePrivateMetricHolder() {
        }

        @Override
        public Iterator getMetrics() {
            return new ASinglePrivateMetricHolderIterator(this);
        }
    }

    static class ASinglePrivateMetricHolderIterator
    implements Iterator {
        ASinglePrivateMetricHolder holder;
        boolean hasNext = true;

        ASinglePrivateMetricHolderIterator(ASinglePrivateMetricHolder hol) {
            this.holder = hol;
        }

        @Override
        public boolean hasNext() {
            if (this.holder.metric == null) {
                return false;
            }
            return this.hasNext;
        }

        public Object next() {
            if (this.holder.metric == null) {
                return null;
            }
            this.hasNext = false;
            return new Map.Entry(){

                public Object getKey() {
                    return ASinglePrivateMetricHolderIterator.this.holder.rep;
                }

                public Object getValue() {
                    return ASinglePrivateMetricHolderIterator.this.holder.metric.getMetrics();
                }

                public Object setValue(Object value) {
                    return ASinglePrivateMetricHolderIterator.this.holder.metric.getMetrics();
                }
            };
        }

        @Override
        public void remove() {
        }
    }

    class ASingleSharedMetricHolder
    implements ISharedMetricHolder,
    ISingleMetricHolder {
        AAgentMetricArray metric;
        IRepository rep;

        ASingleSharedMetricHolder() {
        }

        @Override
        public AgentMetric getSingleMetric() {
            if (this.metric == null) {
                return null;
            }
            return (AgentMetric)this.metric.getMetrics()[0];
        }

        @Override
        public void addMetric(AgentMetric addedMetric, IRepository structure) {
            this.rep = structure;
            this.metric = AAgentMetricArray.getInstance(addedMetric);
        }

        @Override
        public void addMetric(AgentMetric[] addedMetric, IRepository structure) {
            this.rep = structure;
            this.metric = AAgentMetricArray.getInstance(addedMetric);
        }

        @Override
        public IRepository getRepository() {
            return this.rep;
        }

        public IMetricHolder getCorrespondingMetricHolder() {
            return new ASingleSharedMetricMetricHolder(this);
        }
    }

    class ASingleSharedMetricMetricHolder
    extends ASingleSharedMetricHolder
    implements IMetricHolder {
        ASingleSharedMetricMetricHolder(ASingleSharedMetricHolder seed) {
            this.addMetric(seed.getSingleMetric(), seed.rep);
        }

        @Override
        public Iterator getMetrics() {
            return Collections.EMPTY_MAP.entrySet().iterator();
        }
    }

    public static interface ISingleMetricHolder {
        public AgentMetric getSingleMetric();

        public IRepository getRepository();
    }
}

