/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.automatic.AutoTracingCollectStatus;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.agent.beans.autotracing.AgentMetricThresholdTrigger;
import com.wily.introscope.spec.agent.beans.autotracing.IAutoTracingTrigger;
import com.wily.introscope.spec.metric.AgentMetric;

public class AutoTracingHelper {
    public static boolean sAutoTracingEnabled = true;

    public static boolean checkForAutoTracing() {
        boolean isLocalAutoTraceMarked;
        return sAutoTracingEnabled && (isLocalAutoTraceMarked = AutoTracingHelper.checkLocalAutoTraceTrigger());
    }

    public static void markForAutoTracingInternal(InvocationData data, String reason, String component) {
        if (!sAutoTracingEnabled) {
            return;
        }
        AutoTracingHelper.markForLocalAutoTraceTrigger(data, reason, component);
    }

    public static void clearAutoTracingInternal(InvocationData data) {
        AutoTracingHelper.clearLocalAutoTraceTrigger(data);
    }

    private static boolean checkLocalAutoTraceTrigger() {
        AutoTracingCollectStatus aTCS = VirtualStack.getTransactionCache().getAutoTracingCollectStatus();
        return aTCS != null && aTCS.shouldTrace();
    }

    private static boolean checkAndPropagateCrossProcessAutoTraceTrigger() {
        String AutoTracedParam;
        SharedCrossProcessData cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        if (cache != null && (AutoTracedParam = cache.getStringParamIn("IsAutoTraced")) != null && AutoTracedParam.equals("1")) {
            AutoTracingCollectStatus status = VirtualStack.getTransactionCache().getAutoTracingCollectStatus();
            if (status == null) {
                status = new AutoTracingCollectStatus();
                VirtualStack.getTransactionCache().setAutoTracingCollectStatus(status);
            }
            status.addTraceComponent("Cross Process Trigger");
            return true;
        }
        return false;
    }

    private static void markForLocalAutoTraceTrigger(InvocationData data, String reason, String component) {
        AutoTracingCollectStatus status = data.getAutoTracingCollectStatus();
        if (status == null) {
            status = new AutoTracingCollectStatus();
            data.setAutoTracingCollectStatus(status);
        }
        status.addTraceComponent(reason, component);
    }

    private static void markForCrossProcessAutoTraceTrigger(InvocationData data) {
        SharedCrossProcessData cache = data.getSharedCrossProcessData();
        if (cache == null) {
            data.ensureCrossProcessCache();
            cache = data.getSharedCrossProcessData();
        }
        cache.addParamOut("IsAutoTraced", "1");
    }

    private static void clearLocalAutoTraceTrigger(InvocationData data) {
        AutoTracingCollectStatus aTCS = data.getAutoTracingCollectStatus();
        if (aTCS != null) {
            aTCS.clear();
        }
    }

    private static void clearCrossProcessAutoTraceTrigger(InvocationData data) {
        SharedCrossProcessData cache = data.getSharedCrossProcessData();
        if (cache.getStringParamOut("IsAutoTraced") != null) {
            cache.addParamOut("IsAutoTraced", "0");
        }
    }

    public static boolean setAutoTracingTriggers(IAutoTracingTrigger[] triggers, String metricPrefix) {
        if (triggers.length > 0 && triggers[0] instanceof AgentMetricThresholdTrigger) {
            AgentMetricThresholdTrigger[] thresholds = new AgentMetricThresholdTrigger[triggers.length];
            int i = 0;
            while (i < triggers.length) {
                if (triggers[i] instanceof AgentMetricThresholdTrigger) {
                    AgentMetricThresholdTrigger trigger = (AgentMetricThresholdTrigger)triggers[i];
                    if (metricPrefix != null) {
                        trigger = new AgentMetricThresholdTrigger(new AgentMetric.AgentMetricKey(String.valueOf(metricPrefix) + trigger.getMetricKey().getAttributeURL(), trigger.getMetricKey().getAttributeType()), trigger.getElapsedTimeThreshold());
                    }
                    thresholds[i] = trigger;
                }
                ++i;
            }
            return WilyTransactionStructure.getInstance().setElapsedTimeAutoTracingThresholds(thresholds);
        }
        return false;
    }

    public static boolean clearAutoTracingTriggers(IAutoTracingTrigger[] triggers, String metricPrefix) {
        if (triggers.length > 0 && triggers[0] instanceof AgentMetricThresholdTrigger) {
            AgentMetricThresholdTrigger[] thresholds = new AgentMetricThresholdTrigger[triggers.length];
            int i = 0;
            while (i < triggers.length) {
                if (triggers[i] instanceof AgentMetricThresholdTrigger) {
                    AgentMetricThresholdTrigger trigger = (AgentMetricThresholdTrigger)triggers[i];
                    if (metricPrefix != null) {
                        trigger = new AgentMetricThresholdTrigger(new AgentMetric.AgentMetricKey(String.valueOf(metricPrefix) + trigger.getMetricKey().getAttributeURL(), trigger.getMetricKey().getAttributeType()), trigger.getElapsedTimeThreshold());
                    }
                    thresholds[i] = trigger;
                }
                ++i;
            }
            return WilyTransactionStructure.getInstance().clearElapsedTimeAutoTracingThresholds(thresholds);
        }
        return false;
    }

    public static boolean clearAllAutoTracingTriggers() {
        WilyTransactionStructure.getInstance().clearAllElapsedTimeAutoTracingThresholds();
        return true;
    }
}

