/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.IntegerConfigurationProperty;

public class CrossProcessAutoTracingConfiguration {
    private static final Module kModule = Logger.getModule();
    private static volatile boolean fCrossProcessAutoTracingEnabled = true;
    private static volatile int fCrossProcessDownstreamClampMultiplier = 10;
    private static int fCrossProcessCacheUserPercent = 50;

    public static void init(IAgent agent) {
        CrossProcessAutoTracingConfiguration.initializeCrossProcessAutoTracingEnabled(agent);
        CrossProcessAutoTracingConfiguration.initializeCrossProcessDownstreamClampMultiplier(agent);
    }

    private static void initializeCrossProcessAutoTracingEnabled(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        BooleanConfigurationProperty crossProcessAutoTracingDetectionEnabledProperty = new BooleanConfigurationProperty("introscope.agent.deep.automatic.trace.crossprocess.enabled", true, "Enables/Disables Cross Process Auto Trace Feature", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object newValue) {
                CrossProcessAutoTracingConfiguration.setCrossProcessAutoTracingEnabled((Boolean)this.convert(newValue.toString().trim()));
            }
        };
        configManager.add(crossProcessAutoTracingDetectionEnabledProperty, true);
    }

    public static void setCrossProcessAutoTracingEnabled(boolean fCrossProcessAutoTracingEnabled) {
        CrossProcessAutoTracingConfiguration.fCrossProcessAutoTracingEnabled = fCrossProcessAutoTracingEnabled;
    }

    public static boolean isCrossProcessAutoTracingEnabled() {
        return fCrossProcessAutoTracingEnabled;
    }

    private static void initializeCrossProcessDownstreamClampMultiplier(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty crossProcessDownstreamClampMultiplierProperty = new IntegerConfigurationProperty("introcosope.agent.deep.automatic.trace.crossprocess.downstream.clamp.multiplier", 10, "Enables/Disables Cross Process Auto Trace Feature", "", false, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object newValue) {
                CrossProcessAutoTracingConfiguration.setCrossProcessDownstreamClampMultiplier((Integer)newValue);
            }
        };
        configManager.add(crossProcessDownstreamClampMultiplierProperty, true);
    }

    private static void initializeCrossProcessCacheUsePercent(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty crossProcessCacheUsePercent = new IntegerConfigurationProperty("introcosope.agent.deep.automatic.trace.crossprocess.downstream.cache.percent", 50, "Cross Process Auto Trace Cache Percent", "", false, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object newValue) {
                CrossProcessAutoTracingConfiguration.setCrossProcessCacheUsePercent((Integer)newValue);
            }
        };
        configManager.add(crossProcessCacheUsePercent, true);
    }

    public static void setCrossProcessDownstreamClampMultiplier(int multiplier) {
        fCrossProcessDownstreamClampMultiplier = multiplier;
    }

    public static void setCrossProcessCacheUsePercent(int percent) {
        fCrossProcessCacheUserPercent = percent;
    }

    public static int getCrossProcessDownstreamClampMultiplier() {
        return fCrossProcessDownstreamClampMultiplier;
    }

    public static int getCrossProcessCacheUsePercent() {
        return fCrossProcessCacheUserPercent;
    }
}

