/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.IIntelligentInstrumentationStackElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.intelligent.CrossProcessLogger;
import com.wily.introscope.agent.trace.intelligent.DownStreamListenerService;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentStackHelper;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.IntelligentInstrumentationThreadLocalObject;
import com.wily.introscope.agent.trace.intelligent.IntelligentTransactionHarvesterHelper;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.util.HashMap;

public class DownstreamTransactionHarvester {
    private HighPerformanceTransactionCache highPerformanceCache = HighPerformanceTransactionCache.getInstance();
    private boolean shouldAbort = false;

    public void setAbort(boolean flag) {
        this.shouldAbort = flag;
    }

    public void sendTrace(String transactionGUID) {
        HashMap TcdHash = new HashMap();
        this.createAndSendTCD(TcdHash, transactionGUID);
    }

    public static void validateTransactionFromIntelligentInstrumentation(TransactionComponentData root, TransactionComponentData parent) {
        int numChildren;
        if (parent != null) {
            root.fixTimingData(parent);
        }
        if (root.getParameterValue("Total Methods") != null) {
            root.getParameters().remove("Total Methods");
        }
        if ((numChildren = root.getSubNodeCount()) > 0) {
            TransactionComponentData[] children = root.getSubNodes();
            int i = 0;
            while (i < numChildren) {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(children[i], root);
                ++i;
            }
        }
    }

    private void createAndSendTCD(HashMap TcdHash, String transactionGUID) {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] deepStacks = this.highPerformanceCache.getForTransactionTrace(transactionGUID);
        if (deepStacks == null) {
            SustainabilityMetricsHelper.reportNumberOfTracesMissedInCacheMetric(1);
            return;
        }
        boolean success = false;
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] highPerformanceIntelligenceStackElementVirtualStackArray = deepStacks;
        int n = deepStacks.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack highPerformanceIntelligenceStackElementVirtualStack = highPerformanceIntelligenceStackElementVirtualStackArray[n2];
                try {
                    if (this.shouldAbort) {
                        return;
                    }
                    if (!highPerformanceIntelligenceStackElementVirtualStack.hasTraceBeenSent()) {
                        TcdHash.clear();
                        success = this.createAndSendTCDHelper(TcdHash, transactionGUID, highPerformanceIntelligenceStackElementVirtualStack);
                        highPerformanceIntelligenceStackElementVirtualStack.setTraceSent();
                    }
                    highPerformanceIntelligenceStackElementVirtualStack.trySetInUse(false);
                }
                catch (Exception exception) {
                    highPerformanceIntelligenceStackElementVirtualStack.trySetInUse(false);
                    if (!CrossProcessLogger.isDebugEnabled()) break block7;
                    CrossProcessLogger.logDebugMessage("Transaction trace from cache had a failure for : " + transactionGUID);
                }
            }
            ++n2;
        }
        if (success) {
            this.highPerformanceCache.addUpstreamGUID(transactionGUID);
        }
    }

    private boolean createAndSendTCDHelper(HashMap TcdHash, String transactionGUID, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
        int stackElements = deepStack.getStackElementCount();
        int i = 2;
        while (i <= stackElements) {
            IIntelligentInstrumentationStackElement stackElement = deepStack.getElementAt(i);
            IntelligentTransactionHarvesterHelper.createTcd(stackElement);
            ++i;
        }
        IntelligentInstrumentationThreadLocalObject tlObj = deepStack.sIntelligentThreadLocalObject;
        HashMap normalTcdHash = tlObj.fTopTCDElements;
        IIntelligentInstrumentationStackElement topElement = deepStack.getElementAt(1);
        int topElementInvID = topElement.getInvocationId();
        if (topElementInvID != -1) {
            TransactionComponentData normalRootElement = (TransactionComponentData)normalTcdHash.get(topElementInvID);
            deepStack.getElementAt(1).setTransactionComponentData(normalRootElement);
            TransactionComponentData bizDefComponent = null;
            if (!normalRootElement.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(normalRootElement)) != null) {
                HighPerformanceIntelligentStackHelper.realizeSubcomponent(bizDefComponent);
                bizDefComponent.getParameters().put("Trace Type", "Normal");
            }
            IntelligentTransactionHarvesterHelper.joinTCDSubTrees(deepStack);
            if (CrossProcessLogger.isDebugEnabled()) {
                CrossProcessLogger.logDebugMessage("Downstream agent sent the TT for: " + transactionGUID);
            }
            if (bizDefComponent != null) {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(bizDefComponent, null);
                bizDefComponent.getParameters().put("Autotrace Trigger Criteria", "Cross Process Trigger");
                HighPerformanceIntelligenceStackElement.getAgent().IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(bizDefComponent);
            } else {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(normalRootElement, null);
                normalRootElement.getParameters().put("Autotrace Trigger Criteria", "Cross Process Trigger");
                HighPerformanceIntelligenceStackElement.getAgent().IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(normalRootElement);
            }
            SustainabilityMetricsHelper.reportNumberOfTracesFromCacheMetric(1);
            DownStreamListenerService.tracesPerIntervalCount.getAndIncrement();
            return true;
        }
        return false;
    }

    public boolean hasBeenAborted() {
        return this.shouldAbort;
    }
}

