/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.io.ASocketCounter;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public abstract class SocketPerIntervalCounter
extends ASocketCounter {
    protected final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    @Override
    protected abstract ILongIntervalCounterDataAccumulator createDataAccumulator(InvocationData var1);

    public SocketPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected final ILongIntervalCounterDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.isSocketRequired() && !data.hasInvocationThrownException()) {
            SocketFormatMetricsCache cache = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
            if (cache != null) {
                if (cache.getAccumulators(4) == null) {
                    this.getAccumulator(data);
                }
                this.increaseCacheQuantity(cache);
            } else {
                Assertion.wilyAssert("Cache should not be null if socket is required! Invocation is " + data.getInvocationObject() + " and method is " + data.getProbeInformation().getProbeIdentification().getRuntimeFullClassName() + ";" + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + data.getProbeInformation().getProbeIdentification().getProbeMethodDescriptor());
            }
        }
    }

    protected abstract void increaseCacheQuantity(SocketFormatMetricsCache var1);

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }
}

