/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.servlet.RequestWrapper;
import com.wily.introscope.agent.trace.servlet.ServletObjectFactory;
import com.wily.introscope.agent.trace.servlet.ServletWrapper;

public class ServletInvocationDataHelper {

    public static abstract class SafeExecuteOnInvocationDataWithThrottling {
        protected abstract int getErrorCount();

        protected abstract void increaseErrorCount();

        protected abstract int getMaxErrors();

        protected abstract boolean isShutoff();

        protected abstract void setShutoff();

        protected abstract boolean execute(InvocationData var1) throws Throwable;

        protected abstract void onMaxErrorLimitReached();

        protected abstract void onError(Throwable var1);

        public boolean executeSafe(InvocationData data) {
            block9: {
                if (!this.isShutoff()) {
                    try {
                        return this.execute(data);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            this.onError(t);
                        }
                        catch (ThreadDeath td2) {
                            throw td2;
                        }
                        catch (Throwable throwable) {}
                        this.increaseErrorCount();
                        if (this.getMaxErrors() < this.getErrorCount()) {
                            this.setShutoff();
                        }
                        break block9;
                    }
                }
                this.onMaxErrorLimitReached();
                return false;
            }
            return false;
        }
    }

    static abstract class SafeGetServletWrappers
    extends SafeExecuteOnInvocationDataWithThrottling {
        SafeGetServletWrappers() {
        }

        protected abstract boolean doWithWrappers(InvocationData var1, RequestWrapper var2, ServletWrapper var3) throws Throwable;

        protected Object getRequestFromData(InvocationData data) {
            Object request = data.getInvocationParameterAsObject(0);
            return request;
        }

        @Override
        public boolean execute(InvocationData data) throws Throwable {
            Object request;
            if (data.getInvocationParameterCount() > 0 && (request = this.getRequestFromData(data)) != null) {
                ServletObjectFactory objectFactory = ServletObjectFactory.getServletObjectFactory(request);
                RequestWrapper requestWrapper = objectFactory.getRequestWrapper(request);
                ServletWrapper servletWrapper = objectFactory.getServletWrapper(data.getInvocationObject());
                return this.doWithWrappers(data, requestWrapper, servletWrapper);
            }
            return false;
        }
    }

    public static abstract class ServletParameterErrorCounterDelegate
    extends SafeGetServletWrappers {
        private static int sErrorCount = 0;
        private static boolean sHaveGivenUp = false;

        @Override
        protected int getErrorCount() {
            return sErrorCount;
        }

        @Override
        protected int getMaxErrors() {
            return 100;
        }

        @Override
        protected void increaseErrorCount() {
            ++sErrorCount;
        }

        @Override
        protected boolean isShutoff() {
            return sHaveGivenUp;
        }

        @Override
        protected void setShutoff() {
            sHaveGivenUp = true;
        }

        protected void resetErrorCount() {
            sErrorCount = 0;
        }
    }
}

