/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.extension;

import com.wily.introscope.extension.IPluginLoaderCallback;
import com.wily.introscope.extension.PlatformCheckUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;

public class PluginLoader {
    public static void loadPlugins(String extensionPoint, IPluginLoaderCallback pluginLoaderCallback) {
        PluginLoader.loadPlugins(extensionPoint, "class", pluginLoaderCallback);
    }

    public static void loadPlugins(String extensionPoint, String classParameter, final IPluginLoaderCallback pluginLoaderCallback) {
        if (!PlatformCheckUtil.getInstance().isOsgiEnvironment()) {
            return;
        }
        final IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPoint);
        try {
            int i = 0;
            while (i < config.length) {
                final int j = i;
                final Object o = config[i].createExecutableExtension(classParameter);
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        System.out.println("Exception in client");
                    }

                    public void run() throws Exception {
                        pluginLoaderCallback.onExtensionFound(config[j], o);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                ++i;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static interface IPluginLoadCallback {
        public void onExtentionFound(IConfigurationElement var1, Object var2) throws Exception;
    }
}

