/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.http.client;

import com.wily.isengard.postofficehub.link.http.HttpTransportAdapter;
import com.wily.isengard.postofficehub.link.http.client.CommonsHttpTunnelingClient;
import com.wily.isengard.postofficehub.link.http.client.HTTPNotRunningException;
import com.wily.isengard.postofficehub.link.http.client.IHttpTunnelingClient;
import com.wily.isengard.postofficehub.link.http.client.ProxyConfiguration;
import com.wily.isengard.util.thread.AThreadedExecutable;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;

public class HttpTunnelingClientLifecycleManager
extends AThreadedExecutable {
    private static final boolean kSetStatsOn = false;
    private static Module sModule = new Module("HttpTunnelingClient");
    private final HttpTransportAdapter fTransportAdapter;
    private final IHttpTunnelingClient fTunnelingClient;
    private final IModuleFeedbackChannel fFeedback;
    private long fTotalNumberOfServerPolls;
    private long fTotalNumberOfExplicitRequests;
    private long fCurrentNumberOfRequestBytes;
    private long fCurrentNumberOfResponseBytes;
    private long fTotalNumberOfExplicitRequestsEndingInAResponse;
    private long fTotalNumberOfServerPollsEndingInAResponse;
    private long fTotalNumberOfExplicitRequestsEndingInNoResponse;
    private long fTotalNumberOfServerPollsEndingInNoResponse;

    public HttpTunnelingClientLifecycleManager(HttpTransportAdapter transportAdapter, IModuleFeedbackChannel feedback) throws HTTPNotRunningException, IOException {
        this.fTransportAdapter = transportAdapter;
        this.fFeedback = feedback;
        String hostName = transportAdapter.getRemoteHostName();
        int port = transportAdapter.getRemotePort();
        int socketSendBufferSize = transportAdapter.getSocketSendBufferSize();
        int socketReceiveBufferSize = transportAdapter.getSocketReceiveBufferSize();
        SSLContext context = transportAdapter.getSSLContext();
        String[] cipherSuites = transportAdapter.getCipherSuites();
        String[] protocols = transportAdapter.getProtocols();
        this.fTunnelingClient = new CommonsHttpTunnelingClient(hostName, port, socketSendBufferSize, socketReceiveBufferSize, context, cipherSuites, protocols, feedback);
        ProxyConfiguration config = ProxyConfiguration.newInstance(transportAdapter.getSocketProperties(), this.getFeedbackChannel(), sModule);
        if (config != null) {
            try {
                this.getFeedbackChannel().verbose(sModule, "Pinging PROXY server " + config.getHostName() + " at port " + config.getPort());
                config.pingProxy();
            }
            catch (IOException iOException) {
                this.getFeedbackChannel().verbose(sModule, "Proxy server " + config.getHostName() + " cannot be reached");
                this.getFeedbackChannel().verbose(sModule, "Attempting a direction connection to " + hostName);
                config = null;
            }
        }
        if (config == null) {
            this.pingHost(hostName, port);
        }
        this.fTunnelingClient.connect(config);
    }

    @Override
    protected void doTask() {
        block13: {
            HttpTransportAdapter transportAdapter = this.fTransportAdapter;
            IHttpTunnelingClient tunnelingClient = this.fTunnelingClient;
            try {
                try {
                    int counter = 0;
                    while (this.isExecuting()) {
                        byte[] clientRequest = transportAdapter.retrieveOutgoingHttpPayloadFromTransport();
                        if (clientRequest.length > 0 || counter == 50) {
                            byte[] serverResponse = tunnelingClient.transfer(clientRequest);
                            transportAdapter.postHttpPayloadToTransport(serverResponse);
                            counter = 0;
                        }
                        Thread.sleep(20L);
                        ++counter;
                    }
                }
                catch (Throwable e) {
                    this.getFeedbackChannel().debug(sModule, "Client will disconnect from server due to error encountered while transfering data: ", e);
                    try {
                        tunnelingClient.disconnect();
                        this.getFeedbackChannel().debug(sModule, "Disconnecting http tunneling client.");
                    }
                    catch (Exception exception) {}
                    transportAdapter.close();
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    tunnelingClient.disconnect();
                    this.getFeedbackChannel().debug(sModule, "Disconnecting http tunneling client.");
                }
                catch (Exception exception) {}
                transportAdapter.close();
                throw throwable;
            }
            try {
                tunnelingClient.disconnect();
                this.getFeedbackChannel().debug(sModule, "Disconnecting http tunneling client.");
            }
            catch (Exception exception) {}
            transportAdapter.close();
        }
    }

    private void pingHost(String hostName, int remotePort) throws IOException {
        Socket socket = null;
        try {
            InetAddress[] addresses = new InetAddress[]{};
            try {
                addresses = InetAddress.getAllByName(hostName);
            }
            catch (UnknownHostException unknownHostException) {}
            if (addresses.length < 1) {
                socket = new Socket(hostName, remotePort);
            } else {
                IOException thrownException = null;
                int i = 0;
                while (i < addresses.length) {
                    try {
                        socket = new Socket(addresses[i], remotePort);
                        thrownException = null;
                        break;
                    }
                    catch (IOException e) {
                        thrownException = e;
                        ++i;
                    }
                }
                if (thrownException != null) {
                    throw thrownException;
                }
            }
        }
        catch (Throwable throwable) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    private void updateClientRequestStats(byte[] clientRequest) {
        if (clientRequest.length > 0) {
            this.fCurrentNumberOfRequestBytes += (long)clientRequest.length;
            ++this.fTotalNumberOfExplicitRequests;
        } else {
            ++this.fTotalNumberOfServerPolls;
        }
    }

    private void updateServerResponseStats(byte[] clientRequest, byte[] serverResponse) {
        int requestSize = clientRequest.length;
        int responseSize = serverResponse.length;
        if (requestSize > 0) {
            if (responseSize > 0) {
                ++this.fTotalNumberOfExplicitRequestsEndingInAResponse;
            } else {
                ++this.fTotalNumberOfExplicitRequestsEndingInNoResponse;
            }
        } else if (responseSize > 0) {
            ++this.fTotalNumberOfServerPollsEndingInAResponse;
        } else {
            ++this.fTotalNumberOfServerPollsEndingInNoResponse;
        }
        this.fCurrentNumberOfResponseBytes += (long)responseSize;
    }
}

