/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.http.client;

import com.wily.org.apache.commons.httpclient.ConnectTimeoutException;
import com.wily.org.apache.commons.httpclient.params.HttpConnectionParams;
import com.wily.org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TrustingSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private final SSLContext fContext;
    private final String[] fCipherSuites;
    private final String[] fProtocols;

    public TrustingSSLProtocolSocketFactory(SSLContext context, String[] cipherSuites, String[] protocols) {
        this.fContext = context;
        this.fCipherSuites = cipherSuites == null ? new String[]{} : cipherSuites;
        this.fProtocols = protocols == null ? new String[]{} : protocols;
    }

    private SSLContext getSSLContext() {
        return this.fContext;
    }

    private String[] getCipherSuites() {
        return this.fCipherSuites;
    }

    private String[] getProtocols() {
        return this.fProtocols;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        if (this.getCipherSuites().length > 0) {
            socket.setEnabledCipherSuites(this.getCipherSuites());
        }
        if (this.getProtocols().length > 0) {
            socket.setEnabledProtocols(this.getProtocols());
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket socket;
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            socket = (SSLSocket)socketfactory.createSocket(host, port, localAddress, localPort);
        } else {
            socket = (SSLSocket)socketfactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
        }
        if (this.getCipherSuites().length > 0) {
            socket.setEnabledCipherSuites(this.getCipherSuites());
        }
        if (this.getProtocols().length > 0) {
            socket.setEnabledProtocols(this.getProtocols());
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port);
        if (this.getCipherSuites().length > 0) {
            socket.setEnabledCipherSuites(this.getCipherSuites());
        }
        if (this.getProtocols().length > 0) {
            socket.setEnabledProtocols(this.getProtocols());
        }
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket socket2 = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        if (this.getCipherSuites().length > 0) {
            socket2.setEnabledCipherSuites(this.getCipherSuites());
        }
        if (this.getProtocols().length > 0) {
            socket2.setEnabledProtocols(this.getProtocols());
        }
        return socket2;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(TrustingSSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return TrustingSSLProtocolSocketFactory.class.hashCode();
    }
}

