/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.InvalidFieldDescriptorException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.text.FormattedLocalizableMessage;
import java.lang.reflect.Method;

public abstract class MethodDescriptorUtilities {
    public static final String kByteType = "B";
    public static final String kCharType = "C";
    public static final String kDoubleType = "D";
    public static final String kFloatType = "F";
    public static final String kIntegerType = "I";
    public static final String kLongType = "J";
    public static final String kShortType = "S";
    public static final String kBooleanType = "Z";
    public static final String kReferenceType = "L";
    public static final String kReferenceTypeSuffix = ";";
    public static final String kArrayType = "[";
    public static final String kStringParameterType = "Ljava/lang/String;";
    public static final String kObjectParameterType = "Ljava/lang/Object;";
    protected static final String kVoidType = "V";
    public static final char kEndParameterListType = ')';
    public static final char kStartParameterListType = '(';
    public static final char kClassSeparator = '.';
    public static final char kClassSeparatorSubstitute = '/';
    private static final String kByteTypeString = "byte";
    private static final String kCharTypeString = "char";
    private static final String kDoubleTypeString = "double";
    private static final String kFloatTypeString = "float";
    private static final String kIntegerTypeString = "int";
    private static final String kLongTypeString = "long";
    private static final String kShortTypeString = "short";
    private static final String kBooleanTypeString = "boolean";
    private static final String kVoidTypeString = "void";

    public static String getMethodDescriptor(Method methodName) throws InvalidMethodDescriptorException {
        if (methodName == null) {
            throw new NullPointerException();
        }
        StringBuilder methodDescriptorNameBuffer = new StringBuilder();
        try {
            Class<?>[] paramClasses = methodName.getParameterTypes();
            Class<?> returnClass = methodName.getReturnType();
            if (paramClasses == null || returnClass == null) {
                throw new NullPointerException();
            }
            methodDescriptorNameBuffer.append('(');
            String paramDescriptor = null;
            int i = 0;
            while (i < paramClasses.length) {
                paramDescriptor = MethodDescriptorUtilities.getParamDescriptor(paramClasses[i]);
                methodDescriptorNameBuffer.append(paramDescriptor);
                ++i;
            }
            methodDescriptorNameBuffer.append(')');
            String returnDescriptor = MethodDescriptorUtilities.getReturnDescriptor(returnClass);
            methodDescriptorNameBuffer.append(returnDescriptor);
        }
        catch (InvalidFieldDescriptorException invalidFieldDescriptorException) {
            throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Parsing_Invalid_Descriptor", methodDescriptorNameBuffer.toString()), methodDescriptorNameBuffer.toString());
        }
        return methodDescriptorNameBuffer.toString();
    }

    public static String getParamDescriptor(Class className) throws InvalidFieldDescriptorException {
        if (MethodDescriptorUtilities.isPrimitive(className)) {
            return MethodDescriptorUtilities.getPrimitiveDescriptor(className);
        }
        return MethodDescriptorUtilities.getObjectDescriptor(className);
    }

    public static String getReturnDescriptor(Class className) throws InvalidFieldDescriptorException {
        if (MethodDescriptorUtilities.isPrimitive(className)) {
            return MethodDescriptorUtilities.getPrimitiveDescriptor(className);
        }
        if (className.getName().trim().toLowerCase().equals(kVoidTypeString)) {
            return kVoidType;
        }
        return MethodDescriptorUtilities.getObjectDescriptor(className);
    }

    public static String getObjectDescriptor(Class className) {
        if (className == null) {
            throw new NullPointerException();
        }
        String classString = className.getName();
        classString = classString.replace('.', '/');
        if (className.isArray()) {
            return classString;
        }
        return kReferenceType + classString + kReferenceTypeSuffix;
    }

    public static String getPrimitiveDescriptor(Class className) throws InvalidFieldDescriptorException {
        if (className == null) {
            throw new NullPointerException();
        }
        return MethodDescriptorUtilities.getPrimitiveDescriptor(className.getName());
    }

    public static String getPrimitiveDescriptor(String className) throws InvalidFieldDescriptorException {
        if ((className = className.trim().toLowerCase()).equals(kByteTypeString)) {
            return kByteType;
        }
        if (className.equals(kCharTypeString)) {
            return kCharType;
        }
        if (className.equals(kDoubleTypeString)) {
            return kDoubleType;
        }
        if (className.equals(kFloatTypeString)) {
            return kFloatType;
        }
        if (className.equals(kIntegerTypeString)) {
            return kIntegerType;
        }
        if (className.equals(kLongTypeString)) {
            return kLongType;
        }
        if (className.equals(kShortTypeString)) {
            return kShortType;
        }
        if (className.equals(kBooleanTypeString)) {
            return kBooleanType;
        }
        if (className.equals(kVoidTypeString)) {
            return kVoidType;
        }
        throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Invalid_Character", "Base Type", className), className);
    }

    public static boolean isPrimitive(Class className) {
        if (className != null) {
            return className.isPrimitive();
        }
        return false;
    }
}

