/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.v7;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.PlaceHolder;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueUtils;

public class CAMQ7QueueSession
extends PlaceHolder {
    @Override
    public String getHostName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqSessionClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7QueueSession:getHostName:mqSessionClass: " + mqSessionClass.getName());
        try {
            this.hostname = CAMQUtils.getJMSObjectProperty(mqObject, "XMSC_WMQ_HOST_NAME");
            if ((this.hostname == null || this.hostname.equals("")) && CAMQUtils.getJMSObjectProperty(mqObject, "XMSC_WMQ_CONNECTION_MODE").equals("0")) {
                this.hostname = "localhost";
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQ7QueueSession:getHostName:Exception:" + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7QueueSession:getHostName:Host Name: " + this.hostname);
        return this.hostname;
    }

    @Override
    public String getQueueManagerName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqSessionClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7QueueSession:getQueueManagerName:mqSessionClass: " + mqSessionClass.getName());
        try {
            this.qmname = CAMQUtils.getJMSObjectProperty(mqObject, "XMSC_WMQ_QUEUE_MANAGER");
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQ7QueueSession:getQueueManagerName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7QueueSession:getQueueManagerName:Queue Manager Name: " + this.qmname);
        return this.qmname;
    }

    @Override
    public String getQueueName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqSessionClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7QueueSession:getQueueName:mqSessionClass: " + mqSessionClass.getName());
        try {
            Object listenerDestination = CAMQUtils.getMQJMSListenerDestination(mqObject);
            if (listenerDestination != null) {
                Class<?> listenerDestinationClass = listenerDestination.getClass();
                String listenerDestinationClassName = listenerDestinationClass.getName();
                if (listenerDestinationClassName.equals("com.ibm.msg.client.jms.admin.JmsDestinationImpl") || listenerDestinationClassName.equals("com.ibm.mq.jms.MQDestination")) {
                    this.queuename = CAQueueUtils.getDestinationQueueName(listenerDestination);
                } else if (listenerDestinationClassName.equals("com.ibm.mq.jms.MQQueue")) {
                    this.queuename = CAQueueUtils.getJMSBaseQueueName(listenerDestination);
                }
            } else {
                this.queuename = CAQueueUtils.getActivationSpecDestinationQueueName(mqObject);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQ7QueueSession:getQueueName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7QueueSession:getQueueName:Queue Name: " + this.queuename);
        return this.queuename;
    }
}

