/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.helper;

import com.wily.introscope.agent.IAgent;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.helper.RuleContainer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationProperty;
import java.util.StringTokenizer;

public class PatternMatcherHandler {
    private final IModuleFeedbackChannel feedback;
    private static final Module module = new Module("PatternMatcherHandler");
    public static final String JMS_DYN_DEST_PATTERN_KEY = "jms.temporaryDestination.names";
    private volatile RuleContainer patternsRuleContainer;

    public PatternMatcherHandler(IAgent agent) {
        this.feedback = agent.IAgent_getModuleFeedback();
        agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new TempQueueNamingPatternProperty(agent), true);
    }

    public void initializeNamingPatterns(String patterns) {
        try {
            RuleContainer container = new RuleContainer();
            if (patterns != null && patterns.length() > 0) {
                StringTokenizer strtok = new StringTokenizer(patterns, ",", false);
                while (strtok.hasMoreTokens()) {
                    String pattern = strtok.nextToken().trim();
                    if (pattern != null && pattern.length() > 0) {
                        container.add(pattern);
                        continue;
                    }
                    this.feedback.warn("Mis-configured agent properties: jms.temporaryDestination.names has value " + patterns + " .(it must be non-null and non-empty)");
                }
            }
            this.patternsRuleContainer = container;
        }
        catch (Exception e) {
            try {
                this.feedback.error(module, "Could not initialize temporary destination name patterns");
                this.feedback.verbose((Throwable)e);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean matches(String name) {
        if (this.patternsRuleContainer != null) {
            return this.patternsRuleContainer.matches(name);
        }
        return false;
    }

    final class TempQueueNamingPatternProperty
    extends ConfigurationProperty {
        private TempQueueNamingPatternProperty(IAgent agent) {
            super(PatternMatcherHandler.JMS_DYN_DEST_PATTERN_KEY, (Object)"", agent.IAgent_getModuleFeedback(), module, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            PatternMatcherHandler.this.initializeNamingPatterns((String)newValue);
        }
    }
}

