/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.Kconstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.finder.CompoundResourceFinder;
import com.wily.util.finder.FileResourceFinder;
import com.wily.util.finder.IResourceFinder;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.finder.WilyDirectoryResourceFinder;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;

public class MQPPLog
implements Kconstants {
    private static final Module kModule = new Module("MQNameFormatter");
    private static final String kLineSeparatorPropertyName = "line.separator";
    private static ProtectedLogger sLogger = new ProtectedLogger();
    private static GUIDGenerator sGlobalIDGenerator = GUIDGenerator.getInstance();

    public static Module getModule() {
        return kModule;
    }

    public static Object invokeMethodOnObject(Object object, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        Method method = clazz.getMethod(methodName, parameterTypes);
        return method.invoke(object, args);
    }

    public static Object invokeMethodOnObject(Object object, String methodName) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return MQPPLog.invokeMethodOnObject(object, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethodOnClass(Class clazz, String methodName) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return MQPPLog.invokeMethodOnClass(clazz, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethodOnClass(Class clazz, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getMethod(methodName, parameterTypes);
        return method.invoke(null, args);
    }

    public static Method getMethodForObject(Object object, String methodName, Class[] paramTypes) throws NoSuchMethodException, SecurityException, IllegalArgumentException {
        Class<?> clazz = object.getClass();
        return clazz.getMethod(methodName, paramTypes);
    }

    public static Object getField(Object object, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        return field.get(object);
    }

    public static void handleError(IAgent agent, String localizedKey, Throwable t) {
        if (agent.IAgent_getModuleFeedback().isVerboseEnabled()) {
            agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey), t);
        } else {
            agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey));
        }
    }

    public static IndexedProperties getConfiguration(IModuleFeedbackChannel logger, IStringLocalizer localizer) {
        IndexedProperties props = new IndexedProperties();
        CompoundResourceFinder finder = new CompoundResourceFinder();
        finder.addResourceFinder((IResourceFinder)new FileResourceFinder("com.wily.powerpack.wsm.agentProfile", "WSM Agent Profile"));
        finder.addResourceFinder((IResourceFinder)new WilyDirectoryResourceFinder("wily", "WSMAgent.profile", "WSM Agent Profile"));
        IResource resource = finder.IResourceFinder_findResource((IResourceFinderFeedback)new WSMFinderFeedback(logger, localizer));
        if (resource != null) {
            try {
                props.load(resource.IResource_getContents());
            }
            catch (Exception bomb) {
                logger.warn("error loading WSM configuration properties, " + bomb.toString());
            }
        }
        return props;
    }

    public static void handleError(IAgent agent, String localizedKey) {
        agent.IAgent_getModuleFeedback().warn(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString(localizedKey));
    }

    public static IAgent getAgent() throws AgentNotAvailableException {
        return AgentShim.getAgent();
    }

    public static IModuleFeedbackChannel getAgentLogger() throws AgentNotAvailableException {
        return MQPPLog.getAgent().IAgent_getModuleFeedback();
    }

    public static IStringLocalizer getAgentStringLocalizer() throws AgentNotAvailableException {
        return MQPPLog.getAgent().IAgent_getStringLocalizer();
    }

    public static IndexedProperties getAgentConfiguration() throws AgentNotAvailableException {
        return MQPPLog.getAgent().IAgent_getIndexedProperties();
    }

    public static IModuleFeedbackChannel getLogger() {
        return sLogger;
    }

    public static String getGlobalUniqueID() {
        return sGlobalIDGenerator.generateKey();
    }

    public static void getKeyAndValue(String context, StringBuffer key, StringBuffer value) {
        int equals = context.indexOf("=");
        if (equals != -1) {
            key.append(context.substring(0, equals));
            value.append(context.substring(equals + 1));
        }
    }

    public static String dumpStackTrace(Throwable bomb) {
        StackTracePrintStream stack = new StackTracePrintStream((OutputStream)new ByteArrayOutputStream(), 1024);
        bomb.printStackTrace(stack);
        return stack.getString();
    }

    private static class ProtectedLogger
    implements IModuleFeedbackChannel {
        static IModuleFeedbackChannel MQPPLogger = null;
        private static boolean isMQPPDebugEnabled = false;
        private static boolean isMQPPVerboseEnabled = false;
        private static boolean isMQPPTraceEnabled = false;

        static {
            try {
                Timer timer = new Timer(true);
                timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            MQPPLogger = MQPPLog.getAgentLogger();
                            if (MQPPLogger != null) {
                                isMQPPDebugEnabled = MQPPLogger.isDebugEnabled();
                                isMQPPVerboseEnabled = MQPPLogger.isVerboseEnabled();
                                isMQPPTraceEnabled = MQPPLogger.isTraceEnabled();
                            }
                        }
                        catch (AgentNotAvailableException agentNotAvailableException) {}
                    }
                }, 0L, 60000L);
            }
            catch (Exception exception) {}
        }

        private ProtectedLogger() {
        }

        private synchronized IModuleFeedbackChannel getFeedbackChannel() {
            IModuleFeedbackChannel channel = null;
            try {
                channel = MQPPLog.getAgentLogger();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            return channel;
        }

        public boolean isVerboseEnabled() {
            return isMQPPVerboseEnabled || isMQPPDebugEnabled;
        }

        public boolean isDebugEnabled() {
            return isMQPPVerboseEnabled || isMQPPDebugEnabled;
        }

        public boolean isTraceEnabled() {
            return isMQPPTraceEnabled;
        }

        public boolean isErrorEnabled(Module module) {
            boolean error = false;
            if (MQPPLogger != null) {
                error = MQPPLogger.isErrorEnabled(module);
            }
            return error;
        }

        public boolean isWarningEnabled(Module module) {
            boolean warn = false;
            if (MQPPLogger != null) {
                warn = MQPPLogger.isWarningEnabled(module);
            }
            return warn;
        }

        public boolean isInfoEnabled(Module module) {
            boolean info = false;
            if (MQPPLogger != null) {
                info = MQPPLogger.isInfoEnabled(module);
            }
            return info;
        }

        public boolean isVerboseEnabled(Module module) {
            boolean verbose = false;
            if (MQPPLogger != null) {
                verbose = MQPPLogger.isVerboseEnabled(module);
            }
            return verbose;
        }

        public boolean isDebugEnabled(Module module) {
            boolean debug = false;
            if (MQPPLogger != null) {
                debug = MQPPLogger.isDebugEnabled(module);
            }
            return debug;
        }

        public boolean isTraceEnabled(Module module) {
            boolean trace = false;
            if (MQPPLogger != null) {
                trace = MQPPLogger.isTraceEnabled(module);
            }
            return trace;
        }

        public boolean isLogEnabled(SeverityLevel severityLevel, Module module) {
            boolean log = false;
            if (MQPPLogger != null) {
                log = MQPPLogger.isLogEnabled(severityLevel, module);
            }
            return log;
        }

        public void error(String string) {
            if (MQPPLogger != null) {
                MQPPLogger.error(string);
            }
        }

        public void error(String string, Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.error(string, throwable);
            }
        }

        public void warn(String string) {
            if (MQPPLogger != null) {
                MQPPLogger.warn(string);
            }
        }

        public void warn(String string, Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.warn(string, throwable);
            }
        }

        public void info(String string) {
            if (MQPPLogger != null) {
                MQPPLogger.info(string);
            }
        }

        public void info(String string, Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.info(string, throwable);
            }
        }

        public void verbose(String string) {
            if (MQPPLogger != null && this.isVerboseEnabled()) {
                MQPPLogger.verbose(string);
            }
        }

        public void verbose(String string, Throwable throwable) {
            if (MQPPLogger != null && this.isVerboseEnabled()) {
                MQPPLogger.verbose(string, throwable);
            }
        }

        public void debug(String string) {
            if (MQPPLogger != null && this.isDebugEnabled()) {
                MQPPLogger.debug(string);
            }
        }

        public void debug(String string, Throwable throwable) {
            if (MQPPLogger != null && this.isDebugEnabled()) {
                MQPPLogger.debug(string, throwable);
            }
        }

        public void log(SeverityLevel severityLevel, String string) {
            if (MQPPLogger != null) {
                MQPPLogger.log(severityLevel, string);
            }
        }

        public void log(SeverityLevel severityLevel, String string, Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.log(severityLevel, string, throwable);
            }
        }

        public void error(Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.error(throwable);
            }
        }

        public void verbose(Throwable throwable) {
            if (MQPPLogger != null && this.isVerboseEnabled()) {
                MQPPLogger.verbose(throwable);
            }
        }

        public void debug(Throwable throwable) {
            if (MQPPLogger != null && this.isDebugEnabled()) {
                MQPPLogger.debug(throwable);
            }
        }

        public void error(Module module, String string) {
            if (MQPPLogger != null) {
                MQPPLogger.error(module, string);
            }
        }

        public void error(Module module, String string, Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.error(module, string, throwable);
            }
        }

        public void warn(Module module, String string) {
            if (MQPPLogger != null) {
                MQPPLogger.warn(module, string);
            }
        }

        public void warn(Module module, String string, Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.warn(module, string, throwable);
            }
        }

        public void info(Module module, String string) {
            if (MQPPLogger != null) {
                MQPPLogger.info(module, string);
            }
        }

        public void info(Module module, String string, Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.info(module, string, throwable);
            }
        }

        public void verbose(Module module, String string) {
            if (MQPPLogger != null && this.isVerboseEnabled()) {
                MQPPLogger.verbose(module, string);
            }
        }

        public void verbose(Module module, String string, Throwable throwable) {
            if (MQPPLogger != null && this.isVerboseEnabled()) {
                MQPPLogger.verbose(module, string, throwable);
            }
        }

        public void debug(Module module, String string) {
            if (MQPPLogger != null && this.isDebugEnabled()) {
                MQPPLogger.debug(module, string);
            }
        }

        public void debug(Module module, String string, Throwable throwable) {
            if (MQPPLogger != null && this.isDebugEnabled()) {
                MQPPLogger.debug(module, string, throwable);
            }
        }

        public void trace(Module module, String string) {
            if (MQPPLogger != null && this.isTraceEnabled()) {
                MQPPLogger.trace(module, string);
            }
        }

        public void trace(Module module, String string, Throwable throwable) {
            if (MQPPLogger != null && this.isTraceEnabled()) {
                MQPPLogger.trace(module, string, throwable);
            }
        }

        public void log(SeverityLevel severityLevel, Module module, String string) {
            if (MQPPLogger != null) {
                MQPPLogger.log(severityLevel, module, string);
            }
        }

        public void log(SeverityLevel severityLevel, Module module, String string, Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.log(severityLevel, module, string, throwable);
            }
        }

        public void logImmediate(SeverityLevel severityLevel, Module module, String string) {
            if (MQPPLogger != null) {
                MQPPLogger.logImmediate(severityLevel, module, string);
            }
        }

        public void logImmediate(SeverityLevel severityLevel, Module module, String string, Throwable throwable) {
            if (MQPPLogger != null) {
                MQPPLogger.logImmediate(severityLevel, module, string, throwable);
            }
        }

        public String getApplicationName() {
            String appName = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                appName = channel.getApplicationName();
            }
            return appName;
        }

        public String getModuleName() {
            String name = null;
            IModuleFeedbackChannel channel = this.getFeedbackChannel();
            if (channel != null) {
                name = channel.getModuleName();
            }
            return name;
        }

        public void trace(String arg0) {
        }

        public void setLevel(SeverityLevel arg0, Module arg1) {
        }

        public SeverityLevel getLevel(Module arg0) {
            return null;
        }

        public SeverityLevel getEffectiveLevel(Module arg0) {
            return null;
        }
    }

    private static class StackTracePrintStream
    extends PrintStream {
        private final char[] fLineSeparator = System.getProperty("line.separator").toCharArray();
        private int fCursor = 0;
        private char[] fChars;
        private int fCharCount;

        public StackTracePrintStream(OutputStream dummy, int initialSize) {
            super(dummy);
            this.fChars = new char[initialSize];
            this.fCharCount = initialSize;
        }

        @Override
        public synchronized void print(char[] data) {
            while (this.fCursor + data.length > this.fCharCount) {
                this.growBuffer();
            }
            System.arraycopy(data, 0, this.fChars, this.fCursor, data.length);
            this.fCursor += data.length;
        }

        @Override
        public synchronized void print(String s) {
            if (s == null) {
                s = "null";
            }
            int length = s.length();
            while (this.fCursor + length > this.fCharCount) {
                this.growBuffer();
            }
            s.getChars(0, length, this.fChars, this.fCursor);
            this.fCursor += length;
        }

        @Override
        public synchronized void print(Object obj) {
            this.print(String.valueOf(obj));
        }

        @Override
        public synchronized void println(char[] data) {
            this.print(data);
            this.printSeparator();
        }

        @Override
        public synchronized void println(String s) {
            this.print(s);
            this.printSeparator();
        }

        @Override
        public synchronized void println(Object obj) {
            this.print(obj);
            this.printSeparator();
        }

        @Override
        public synchronized void println() {
            this.printSeparator();
        }

        private void printSeparator() {
            this.print(this.fLineSeparator);
        }

        private void growBuffer() {
            int newSize = this.fCharCount * 2;
            char[] newBuffer = new char[newSize];
            System.arraycopy(this.fChars, 0, newBuffer, 0, this.fCharCount);
            this.fCharCount = newSize;
            this.fChars = newBuffer;
        }

        public String getString() {
            return new String(this.fChars, 0, this.fCursor);
        }

        public void reset() {
            this.fCursor = 0;
        }

        @Override
        public void flush() {
        }
    }

    private static class WSMFinderFeedback
    implements IResourceFinderFeedback {
        IModuleFeedbackChannel fLogger;
        IStringLocalizer fLocalizer;

        public WSMFinderFeedback(IModuleFeedbackChannel logger, IStringLocalizer localizer) {
            this.fLogger = logger;
            this.fLocalizer = localizer;
        }

        public IStringLocalizer IResourceFinderFeedback_getStringLocalizer() {
            return this.fLocalizer;
        }

        public void IResourceFinderFeedback_feedbackStatus(String message) {
            this.fLogger.info(message);
        }

        public void IResourceFinderFeedback_feedbackFailure(String message) {
            this.fLogger.error(message);
        }

        public void IResourceFinderFeedback_feedbackSuccess(String message) {
            this.fLogger.info(message);
        }
    }
}

