/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.trace.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.Kconstants;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.MonitoredClassFactory;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.PlaceHolder;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.MQClassLoaderUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ANameFormatter
implements INameFormatter {
    public static final int HOST_MARKER = 1;
    public static final int QM_MARKER = 2;
    public static final int QUEUE_MARKER = 4;

    public ANameFormatter(IAgent agent) {
    }

    public String replaceString(String source, String replaceTarget, String replacement) {
        StringBuffer sbSource = new StringBuffer(source);
        char startChar = replaceTarget.charAt(0);
        int i = 0;
        while (i < sbSource.length()) {
            String compare;
            if (sbSource.charAt(i) == startChar && replaceTarget.equals(compare = sbSource.substring(i, i + replaceTarget.length()))) {
                sbSource.replace(i, i + replaceTarget.length(), replacement);
                break;
            }
            ++i;
        }
        return sbSource.toString();
    }

    public String replaceStringAll(String source, int replacementMarker, int offset, String[] values) {
        String compare;
        int i;
        StringBuilder sbSource = new StringBuilder(source);
        char startChar = "{hostname}".charAt(0);
        int length = sbSource.length();
        if ((replacementMarker & 1) == 1) {
            i = offset;
            while (i < length) {
                if (sbSource.charAt(i) == startChar && "{hostname}".equals(compare = sbSource.substring(i, i + "{hostname}".length()))) {
                    sbSource.replace(i, i + "{hostname}".length(), values[0]);
                    replacementMarker &= 6;
                    offset = i + values[0].length() + 1;
                    break;
                }
                ++i;
            }
        }
        if ((replacementMarker & 2) == 2) {
            startChar = "{queuemanager}".charAt(0);
            length = sbSource.length();
            i = offset;
            while (i < length) {
                if (sbSource.charAt(i) == startChar && "{queuemanager}".equals(compare = sbSource.substring(i, i + "{queuemanager}".length()))) {
                    sbSource.replace(i, i + "{queuemanager}".length(), values[1]);
                    replacementMarker &= 4;
                    offset = i + values[1].length() + 1;
                    break;
                }
                ++i;
            }
        }
        if ((replacementMarker & 4) == 4) {
            startChar = "{queue}".charAt(0);
            length = sbSource.length();
            i = offset;
            while (i < length) {
                if (sbSource.charAt(i) == startChar && "{queue}".equals(compare = sbSource.substring(i, i + "{queue}".length()))) {
                    sbSource.replace(i, i + "{queue}".length(), values[2]);
                    replacementMarker = 0;
                    break;
                }
                ++i;
            }
        }
        return sbSource.toString();
    }

    public String getlocalhost() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "ANameFormatter:getlocalhost:UnknownHostException: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        return addr.getHostName();
    }

    public String gethostname() {
        String hostName = Kconstants.HOST_UNKNOWN;
        try {
            if (MQClassLoaderUtil.CLS_MQEnvironment != null) {
                hostName = (String)MQClassLoaderUtil.fMQEnvironment_hostname.get(null);
                MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:gethostname:MQEnvironment hostname: " + hostName);
            }
        }
        catch (Exception e1) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "ANameFormatter:getHostName:Exception: " + e1.getMessage());
            MQPPLog.getLogger().debug((Throwable)e1);
        }
        if (hostName == null || (hostName = hostName.trim()).length() == 0 || hostName.equalsIgnoreCase(Kconstants.HOST_UNKNOWN)) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:gethostname:missing host information");
            hostName = Kconstants.HOST_UNKNOWN;
        } else if (hostName.equals("localhost") || hostName.equals("127.0.0.1")) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:getHostName:hostname NULL getting localhost name");
            hostName = this.getlocalhost();
        }
        return hostName;
    }

    public String INameFormatter_format(String name, InvocationData iData) {
        block22: {
            MonitoredClassFactory monclass = null;
            PlaceHolder pholderobj = null;
            int replacementMarker = 0;
            int offset = 0;
            String qManagerName = Kconstants.QM_UNKNOWN;
            String qName = Kconstants.QUEUE_UNKNOWN;
            String hostName = Kconstants.HOST_UNKNOWN;
            String className = Kconstants.CLASS_UNKNOWN;
            try {
                Object invocationObject = iData.getInvocationObject();
                if (invocationObject != null) {
                    Class<?> objcls = invocationObject.getClass();
                    MonitoredClassFactory.defineVersion(invocationObject);
                    className = objcls.getName();
                    MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:InvocationObjectClass: " + className);
                    MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:Metric Path: " + name);
                    monclass = new MonitoredClassFactory();
                    pholderobj = monclass.getMonitoredClass(className);
                }
                if (name == null) break block22;
                offset = name.indexOf("{hostname}", 0);
                if (offset >= 0) {
                    hostName = (String)iData.get("{hostname}");
                    if (hostName == null || hostName.equals(Kconstants.HOST_UNKNOWN)) {
                        try {
                            if (pholderobj != null) {
                                hostName = pholderobj.getHostName(iData);
                                MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:after pholderobj.getHostName:Host Name: " + hostName);
                            } else {
                                hostName = this.gethostname();
                            }
                            if (hostName == null || (hostName = hostName.trim()).length() == 0 || hostName.equalsIgnoreCase(Kconstants.HOST_UNKNOWN)) {
                                MQPPLog.getLogger().debug(MQPPLog.getModule(), "Object:" + className + " missing hostname: " + hostName);
                                hostName = Kconstants.HOST_UNKNOWN;
                            } else {
                                hostName = hostName.toLowerCase().trim();
                                hostName = hostName.replace(':', '.');
                            }
                            if (hostName.equals("localhost") || hostName.equals("127.0.0.1")) {
                                hostName = this.getlocalhost();
                            }
                        }
                        catch (Exception e) {
                            MQPPLog.getLogger().warn(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:Exception: " + e.getMessage());
                            MQPPLog.getLogger().debug((Throwable)e);
                            hostName = Kconstants.HOST_UNKNOWN;
                        }
                        iData.put("{hostname}", (Object)hostName);
                    }
                    replacementMarker |= 1;
                }
                if (name.indexOf("{queuemanager}", 0) >= 0) {
                    qManagerName = (String)iData.get("{queuemanager}");
                    if (qManagerName == null || qManagerName.equals(Kconstants.QM_UNKNOWN)) {
                        try {
                            MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:Inside QManager");
                            if (pholderobj != null) {
                                qManagerName = pholderobj.getQueueManagerName(iData);
                                MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:after pholderobj.getQueueManagerName:Queue Manager Name: " + qManagerName);
                            }
                            if (qManagerName == null || (qManagerName = qManagerName.trim()).length() == 0) {
                                MQPPLog.getLogger().debug(MQPPLog.getModule(), "Object:" + className + " missing QueueManager name: " + qManagerName);
                                qManagerName = Kconstants.QM_UNKNOWN;
                            }
                        }
                        catch (Exception e) {
                            MQPPLog.getLogger().warn(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:QueueManagerPlaceholder: " + e.getMessage());
                            MQPPLog.getLogger().debug((Throwable)e);
                            qManagerName = Kconstants.QM_UNKNOWN;
                        }
                        iData.put("{queuemanager}", (Object)qManagerName);
                    }
                    replacementMarker |= 2;
                }
                if (name.indexOf("{queue}", 0) >= 0) {
                    qName = (String)iData.get("{queue}");
                    if (qName == null || qName.equals(Kconstants.QUEUE_UNKNOWN)) {
                        if (pholderobj != null) {
                            qName = pholderobj.getQueueName(iData);
                            MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:after pholderobj.getQueueName:Queue Name: " + qName);
                        }
                        if (qName == null || (qName = qName.trim()).length() == 0) {
                            MQPPLog.getLogger().debug(MQPPLog.getModule(), "Object:" + className + " missing Queue name: " + qName);
                            qName = Kconstants.QUEUE_UNKNOWN;
                        }
                        iData.put("{queue}", (Object)qName);
                    }
                    replacementMarker |= 4;
                }
                String[] values = new String[]{hostName, qManagerName, qName};
                name = this.replaceStringAll(name, replacementMarker, offset, values);
                return name;
            }
            catch (Exception e) {
                MQPPLog.getLogger().warn(MQPPLog.getModule(), "ANameFormatter:INameFormatter_format:Exception: " + e.getMessage());
                MQPPLog.getLogger().debug((Throwable)e);
                return name;
            }
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "ANameFormatter:Resolved Metric Path: " + name);
        return name;
    }
}

