/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.MQClassLoaderUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JMSReceiveCorrelationTracer
extends ASingleMetricTracerFactory {
    private IModuleFeedbackChannel fLogger = MQPPLog.getLogger();
    public static final Module kModule = new Module("JMSReceiveCorrelationTracer");

    static {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        MQClassLoaderUtil.initialize(classloader);
        Reflection.initialise(classloader);
    }

    public JMSReceiveCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.fLogger.debug(kModule, "Inside JMSReceiveCorrelationTracer consutructor");
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        if (TraceProperties.shouldReadFromMQHeader()) {
            String incomingNodeID = this.getComponentTracer().getCrossProcessDataCache().getIncomingCalledByNodeId();
            if (incomingNodeID == null || incomingNodeID.trim().length() == 0) {
                String correlationString = null;
                Object messageObject = data.getInvocationReturnValueAsObject();
                if (messageObject == null && data.getProbeInformation().getProbeIdentification().getProbeMethodName().equals("onMessage")) {
                    messageObject = data.getInvocationParameterAsObject(0);
                }
                if (messageObject != null) {
                    Class<?> messageObjectClass = messageObject.getClass();
                    String jmsMessageClassName = messageObjectClass.getName();
                    String jmsMessageSuperClassName = messageObjectClass.getSuperclass().getName();
                    String jmsMessageSuper2ClassName = messageObjectClass.getSuperclass().getSuperclass().getName();
                    this.fLogger.debug(kModule, "JMS Message Object Class " + messageObjectClass.getName());
                    try {
                        if (jmsMessageClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuperClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuper2ClassName.equals("com.ibm.jms.JMSMessage")) {
                            correlationString = (String)MQClassLoaderUtil.mJMSMessage_getStringProperty.invoke(messageObject, "CorIDForSOAPInvocation");
                        } else if (jmsMessageClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuperClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuper2ClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                            correlationString = (String)MQClassLoaderUtil.mJmsMessageImpl_getStringProperty.invoke(messageObject, "CorIDForSOAPInvocation");
                        } else {
                            Method mGetStringProperty = messageObjectClass.getMethod("getStringProperty", String.class);
                            correlationString = (String)mGetStringProperty.invoke(messageObject, "CorIDForSOAPInvocation");
                        }
                    }
                    catch (InvocationTargetException e) {
                        this.fLogger.debug(kModule, "No correaltion property is set up in the message" + e.getMessage());
                    }
                    catch (Exception e) {
                        this.fLogger.debug(kModule, "Cannot get the correlation property " + e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (correlationString == null || correlationString.trim().length() == 0) {
                            this.fLogger.debug(kModule, "No correlation id in JMS Message");
                            new CorrelationId();
                        } else {
                            new CorrelationId(correlationString, true);
                        }
                    }
                    catch (Exception e) {
                        this.fLogger.warn(kModule, "Exception while setting CorrelationString " + e.getMessage(), (Throwable)e);
                        this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
                    }
                    this.fLogger.debug(kModule, "JMS Receive CorrelationString = " + correlationString);
                }
            } else {
                this.fLogger.debug(kModule, "Existing Incoming NodeID = " + incomingNodeID);
            }
        }
    }
}

