/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake;

import com.wily.powerpack.websphereMQ.agent.extensions.metrics.ActivityReportMetric;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeNotifier;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakePacket;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeQM;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.MQMonitorAgentsMonitor;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.IOException;

public final class HandshakeReader
extends Thread
implements HandshakeConstants {
    private static IModuleFeedbackChannel logger = null;
    private static String queuename = TraceProperties.HANDSHAKE_QUEUE_NAME_VALUE;
    private static Integer OPEN_READ_OPTIONS = new Integer(8226);
    private MQMonitorAgentsMonitor mqMonitorAgents = null;
    private HandshakePacket packet = null;
    private String agentName = null;
    private static Object readQueue = null;

    public HandshakeReader(String agentName, String threadName, IModuleFeedbackChannel feedback) {
        super(threadName);
        logger = feedback;
        this.agentName = agentName;
        HandshakeQM.setIModuleFeedbackChannel(logger);
        this.mqMonitorAgents = MQMonitorAgentsMonitor.getInstance(logger);
        this.packet = HandshakePacket.getInstance(agentName, logger);
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
        this.packet.setAgentName(agentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        HandshakeReader.logger.info(HandshakeReader.handshakeModule, "Started the handshake reader thread ");
        handshakeQM = null;
        while (true) lbl-1000:
        // 8 sources

        {
            if (handshakeQM != null) {
                try {
                    HandshakeReader.logger.debug(HandshakeReader.handshakeModule, "Closing old handshake queuemanager connection for reader. ");
                    Reflection.closeMQQueueManager(handshakeQM);
                    this.mqMonitorAgents.setAllMQMonitored(false, ActivityReportMetric.VALUE_STATUS_MESSAGE_CONNECTION_FAILURE);
                    HandshakeReader.logger.info(HandshakeReader.handshakeModule, "Setting the ALLMQMONITOR flag to False since connection is not there hence cannot monitor health of MQMonitor agents now. ");
                }
                catch (Exception v0) {}
            }
            if (MQMonitorAgentsMonitor.isMQMonitorAgentNamesEmpty()) {
                while (true) {
                    try {
                        var2_2 = HandshakeNotifier.LOCKOBJECT;
                        synchronized (var2_2) {
                            if (MQMonitorAgentsMonitor.isMQMonitorAgentNamesEmpty()) {
                                HandshakeNotifier.LOCKOBJECT.wait();
                                HandshakeReader.logger.info(HandshakeReader.handshakeModule, "MQMonitor name provided in the list. Continuing with the handshake reader process");
                            }
                        }
                    }
                    catch (InterruptedException v2) {
                        if (MQMonitorAgentsMonitor.isMQMonitorAgentNamesEmpty()) continue;
                        HandshakeReader.logger.info(HandshakeReader.handshakeModule, "MQMonitor name provided in the list. Continuing with the handshake reader process");
                    }
                    break;
                }
            }
            if ((handshakeQM = HandshakeQM.establishHandshakeQM()) == null) continue;
            HandshakeReader.readQueue = HandshakeReader.createQueueHandle(handshakeQM);
            if (HandshakeReader.readQueue != null) {
                this.mqMonitorAgents.computeAllQMMonitoredFlag();
                try {
                    while (true) {
                        if (MQMonitorAgentsMonitor.isMQMonitorAgentNamesEmpty()) ** GOTO lbl-1000
                        message = null;
                        try {
                            message = this.readMessage(HandshakeReader.readQueue);
                        }
                        catch (Exception e) {
                            mqExceptionObj = e.getCause();
                            iAmMQException = Reflection.getClassMQException().isInstance(mqExceptionObj);
                            if (iAmMQException) {
                                reasonCode = Reflection.getReasonCodeField().getInt(mqExceptionObj);
                                completionCode = Reflection.getCompletionCodeField().getInt(mqExceptionObj);
                                if (completionCode == 2 && reasonCode == 2016) {
                                    try {
                                        Thread.sleep(60000L);
                                    }
                                    catch (InterruptedException v3) {
                                        HandshakeReader.logger.debug(HandshakeReader.handshakeModule, "Handshake reader thread is interrupted in sleep. Shouldn't have happened, though no problem because of this. ");
                                    }
                                    Reflection.closeMQQueue(HandshakeReader.readQueue);
                                    HandshakeReader.readQueue = HandshakeReader.createQueueHandle(handshakeQM);
                                }
                                throw e;
                            }
                            throw e;
                        }
                        if (message == null) continue;
                        HandshakeReader.logger.debug(HandshakeReader.handshakeModule, "A Message read from handshake queue: " + HandshakeReader.queuename);
                        try {
                            this.processMessage(message);
                        }
                        catch (IOException v4) {
                            HandshakeReader.logger.warn(HandshakeReader.handshakeModule, "Wrong type of message received from queue: " + HandshakeReader.queuename + " for handshake. Skipping the message." + " Make sure that no other application other the " + "CA Introscope uses the queue.");
                        }
                    }
                }
                catch (Exception v5) {
                    if (HandshakeReader.readQueue == null) ** GOTO lbl-1000
                    try {
                        Reflection.closeMQQueue(HandshakeReader.readQueue);
                    }
                    catch (Exception v6) {}
                }
                continue;
            }
            HandshakeReader.logger.warn(HandshakeReader.handshakeModule, "Problem in getting queue connection for reading from handshake queue: " + TraceProperties.HANDSHAKE_QUEUE_NAME_VALUE + " but, queue manager connection was fine. " + "Check if the queue exist in the queuemanager or queuename given " + "in the property files is correct. " + " Going to sleep for " + 60000 + " milliseconds before trying again.");
            try {
                HandshakeReader.sleep(60000L);
                continue;
            }
            catch (InterruptedException v7) {
                HandshakeReader.logger.debug(HandshakeReader.handshakeModule, "Handshake reader thread is interrupted in sleep. Shouldn't have happened, though no problem because of this. ");
                continue;
            }
            break;
        }
    }

    private void processMessage(Object message) throws IOException {
        String text = Reflection.readLine(message);
        if (text != null) {
            String[] mqMonitorAgentInfo = this.packet.extractMQMonitorInformation(text);
            if (mqMonitorAgentInfo != null) {
                String mqMonitorAgentName = mqMonitorAgentInfo[HandshakePacket.MQMONITOR_AGENTNAME];
                String mqMonitorAgentStatusMsg = mqMonitorAgentInfo[HandshakePacket.MQMONITOR_MESSAGE];
                this.mqMonitorAgents.setMQMonitorAgentStatus(mqMonitorAgentName, mqMonitorAgentStatusMsg);
            } else {
                logger.warn(handshakeModule, "Wrong type of message received from queue: " + queuename + " for handshake. Skipping the message." + " Make sure that no other application is using the queue");
            }
        }
    }

    private static Object createQueueHandle(Object handshakeQM) {
        Object handshakeQueueReader = null;
        try {
            handshakeQueueReader = Reflection.createMQQueueGet(handshakeQM, queuename, OPEN_READ_OPTIONS);
            logger.info(handshakeModule, "Successful read connection to queue: " + queuename + " for handshake");
            return handshakeQueueReader;
        }
        catch (Exception e) {
            logger.warn(handshakeModule, "Problem in creating connection to queue: " + queuename + " for handshake. " + e.getMessage());
            logger.debug((Throwable)e);
            return null;
        }
    }

    private Object readMessage(Object queue) throws Exception {
        try {
            Object message = Reflection.createMyMessage(this.agentName);
            Object gmo = Reflection.getGMO();
            boolean flag = Reflection.getMessageFromQueue(queue, message, gmo);
            if (flag) {
                return message;
            }
            return null;
        }
        catch (Exception e) {
            logger.warn(handshakeModule, "Problem in reading from queue: " + queuename + " for handshake");
            logger.debug((Throwable)e);
            throw e;
        }
    }

    public static Object getReadQueue() {
        return readQueue;
    }
}

