/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake;

import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MQClassConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.QueuePacket;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeConstants;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public final class Reflection
implements MQClassConstants,
HandshakeConstants {
    private static Class class_MQQueueManager = null;
    private static Class class_MQMessage = null;
    private static Class class_MQQueue = null;
    private static Class class_MQMD = null;
    private static Class class_MQGetMessageOptions = null;
    private static Class class_MQPutMessageOptions = null;
    private static Class class_MQException = null;
    private static Constructor qmConstructor = null;
    private static Method mqClose = null;
    private static Method mqDisconnect = null;
    private static Method accessQueue = null;
    private static Method mqQueueClose = null;
    private static Method mGet = null;
    private static Method mPut = null;
    private static Method readLine = null;
    private static Field messageId = null;
    private static Field format = null;
    private static Field messageType = null;
    private static Field expiry = null;
    private static Field report = null;
    private static Field waitInterval = null;
    private static Field options = null;
    private static Field reasonCodeField = null;
    private static Field completionCodeField = null;
    private static Field persistence = null;
    private static volatile boolean discoveryAccess = false;
    private static boolean loadSuccess = false;

    public static void initialise(ClassLoader classloader) {
        if (!loadSuccess) {
            try {
                class_MQQueueManager = Class.forName("com.ibm.mq.MQQueueManager", false, classloader);
                class_MQQueue = Class.forName("com.ibm.mq.MQQueue", false, classloader);
                class_MQMessage = Class.forName("com.ibm.mq.MQMessage", false, classloader);
                class_MQMD = class_MQMessage.getSuperclass();
                class_MQGetMessageOptions = Class.forName("com.ibm.mq.MQGetMessageOptions", false, classloader);
                class_MQPutMessageOptions = Class.forName("com.ibm.mq.MQPutMessageOptions", false, classloader);
                class_MQException = Class.forName("com.ibm.mq.MQException", false, classloader);
                qmConstructor = class_MQQueueManager.getConstructor(String.class, Hashtable.class);
                mqClose = class_MQQueueManager.getMethod("close", new Class[0]);
                mqDisconnect = class_MQQueueManager.getMethod("disconnect", new Class[0]);
                accessQueue = class_MQQueueManager.getMethod("accessQueue", String.class, Integer.TYPE);
                mqQueueClose = class_MQQueue.getMethod("close", new Class[0]);
                mGet = class_MQQueue.getMethod("get", class_MQMessage, class_MQGetMessageOptions);
                mPut = class_MQQueue.getMethod("put", class_MQMessage, class_MQPutMessageOptions);
                readLine = class_MQMessage.getMethod("readLine", new Class[0]);
                messageId = class_MQMD.getField("messageId");
                format = class_MQMD.getField("format");
                messageType = class_MQMD.getField("messageType");
                expiry = class_MQMD.getField("expiry");
                report = class_MQMD.getField("report");
                persistence = class_MQMD.getField("persistence");
                waitInterval = class_MQGetMessageOptions.getField("waitInterval");
                options = class_MQGetMessageOptions.getField("options");
                reasonCodeField = class_MQException.getDeclaredField("reasonCode");
                completionCodeField = class_MQException.getDeclaredField("completionCode");
                loadSuccess = true;
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(handshakeModule, "Reflection " + e.getMessage());
                loadSuccess = false;
            }
        }
    }

    public static Object createMQQueueManager(String qmgrName, Hashtable props) throws Exception {
        Object qm = null;
        try {
            qm = qmConstructor.newInstance(qmgrName, props);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(handshakeModule, "Exception in creating creating MQQueueManager object");
            MQPPLog.getLogger().debug(handshakeModule, e.getMessage(), (Throwable)e);
            throw e;
        }
        return qm;
    }

    public static Object createMQQueueGet(Object qmgr, Object queuename, Integer options) throws Exception {
        Object queue = null;
        try {
            queue = accessQueue.invoke(qmgr, queuename.toString(), options);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(handshakeModule, "Exception in creating creating accessQueue for get");
            MQPPLog.getLogger().debug(handshakeModule, e.getMessage(), (Throwable)e);
            throw e;
        }
        return queue;
    }

    public static Object createMQQueuePut(Object qmgr, Object queuename, Integer options) throws Exception {
        Object queue = null;
        try {
            queue = accessQueue.invoke(qmgr, queuename.toString(), options);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(handshakeModule, "Exception in creating creating accessQueue for put");
            MQPPLog.getLogger().debug(handshakeModule, e.getMessage(), (Throwable)e);
            throw e;
        }
        return queue;
    }

    public static String readLine(Object mqMessage) {
        String text = null;
        try {
            text = (String)readLine.invoke(mqMessage, new Object[0]);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(handshakeModule, "Exception in creating creating accessQueue for put");
            MQPPLog.getLogger().debug((Throwable)e);
        }
        return text;
    }

    public static Object createMessageForMQMonitorAgent(String mqMonitorAgentName, String agentName) {
        Object dummyMQMessage = null;
        try {
            dummyMQMessage = class_MQMessage.newInstance();
            messageId.set(dummyMQMessage, mqMonitorAgentName.getBytes());
            format.set(dummyMQMessage, "MQSTR   ");
            messageType.setInt(dummyMQMessage, 8);
            expiry.setInt(dummyMQMessage, 3000);
            int reportV = report.getInt(dummyMQMessage);
            report.setInt(dummyMQMessage, reportV | 0x8000000);
            Method mWriteString = class_MQMessage.getMethod("writeString", String.class);
            mWriteString.invoke(dummyMQMessage, "MQCLIENT_AGENT_START_STRING-|-" + agentName);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(handshakeModule, "Exception in creating MQMessage");
            MQPPLog.getLogger().debug(handshakeModule, e.getMessage(), (Throwable)e);
        }
        return dummyMQMessage;
    }

    public static Object createMessageForMQMonitorAgent(QueuePacket queuePacket, String agentName) {
        Object dummyMQMessage = null;
        try {
            dummyMQMessage = class_MQMessage.newInstance();
            messageId.set(dummyMQMessage, agentName.getBytes());
            messageType.setInt(dummyMQMessage, 8);
            expiry.setInt(dummyMQMessage, 36000);
            int reportV = report.getInt(dummyMQMessage);
            report.setInt(dummyMQMessage, reportV | 0x8000000);
            Method mWriteObject = class_MQMessage.getMethod("writeObject", Object.class);
            mWriteObject.invoke(dummyMQMessage, queuePacket);
        }
        catch (Exception e) {
            MQPPLog.getLogger().error(MQDiscoveryConstants.discoveryModule, "Exception in creating MQMessage");
            MQPPLog.getLogger().debug(MQDiscoveryConstants.discoveryModule, e.getMessage(), (Throwable)e);
        }
        return dummyMQMessage;
    }

    public static Object createMyMessage(String mqClientAgentName) {
        Object dummyMQMessage = null;
        try {
            dummyMQMessage = class_MQMessage.newInstance();
            messageId.set(dummyMQMessage, mqClientAgentName.getBytes());
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(handshakeModule, "Exception in creating MQMessage");
            MQPPLog.getLogger().debug(handshakeModule, e.getMessage(), (Throwable)e);
        }
        return dummyMQMessage;
    }

    public static void closeMQQueue(Object mqQueue) {
        try {
            mqQueueClose.invoke(mqQueue, new Object[0]);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(handshakeModule, "closeQueue(Object) ", (Throwable)e);
        }
    }

    public static void closeMQQueueManager(Object mqQmgr) {
        try {
            mqDisconnect.invoke(mqQmgr, new Object[0]);
            mqClose.invoke(mqQmgr, new Object[0]);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(handshakeModule, "closeQueueManager(Object) ", (Throwable)e);
        }
    }

    public static Object getGMO() {
        Object dummyGMO = null;
        try {
            dummyGMO = class_MQGetMessageOptions.newInstance();
            waitInterval.setInt(dummyGMO, 300000);
            int optionsV = options.getInt(dummyGMO);
            options.setInt(dummyGMO, optionsV | 1 | 0x2000);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(handshakeModule, "Exception in getGMO");
            MQPPLog.getLogger().debug(handshakeModule, e.getMessage(), (Throwable)e);
        }
        return dummyGMO;
    }

    public static Object getPMO() {
        Object dummyPMO = null;
        try {
            dummyPMO = class_MQPutMessageOptions.newInstance();
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(handshakeModule, "Exception in getGMO");
            MQPPLog.getLogger().debug(handshakeModule, e.getMessage(), (Throwable)e);
        }
        return dummyPMO;
    }

    public static boolean getMessageFromQueue(Object mqQueue, Object mqMessage, Object gmo) throws Exception {
        try {
            mGet.invoke(mqQueue, mqMessage, gmo);
            MQPPLog.getLogger().debug(handshakeModule, "getMessageFromQueue exit");
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable mqExceptionObj = e.getCause();
            boolean iAmMQException = class_MQException.isInstance(mqExceptionObj);
            if (iAmMQException) {
                int reasonCode = reasonCodeField.getInt(mqExceptionObj);
                int completionCode = completionCodeField.getInt(mqExceptionObj);
                if (completionCode == 2 && reasonCode == 2033) {
                    return false;
                }
                if (completionCode == 2 && reasonCode == 2016) {
                    MQPPLog.getLogger().warn(handshakeModule, "Handshake queue " + TraceProperties.HANDSHAKE_QUEUE_NAME_VALUE + " is get inhibited. Not able to read the handshake message." + " Ensure that the queue attribute 'Get Messages' is set to value 'Allowed'." + " Going to suspend the reading for " + 60000 + " milliseconds.");
                    MQPPLog.getLogger().debug(handshakeModule, e.getMessage(), (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                    throw e;
                }
                throw e;
            }
            throw e;
        }
    }

    public static boolean putMessageToQueue(Object mqQueue, Object mqMessage, Object pmo) throws Exception {
        try {
            mPut.invoke(mqQueue, mqMessage, pmo);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable mqExceptionObj = e.getCause();
            boolean iAmMQException = class_MQException.isInstance(mqExceptionObj);
            if (iAmMQException) {
                int reasonCode = reasonCodeField.getInt(mqExceptionObj);
                int completionCode = completionCodeField.getInt(mqExceptionObj);
                if (completionCode == 2 && reasonCode == 2051) {
                    if (discoveryAccess) {
                        MQPPLog.getLogger().warn(MQDiscoveryConstants.discoveryModule, "MQ Auto Discovery queue " + TraceProperties.MQ_DISCOVERY_QUEUE_NAME_VALUE + " is put inhibited. Not able to write the discovery message." + " Ensure that the queue attribute 'Put Messages' is set to value 'Allowed'. ");
                        discoveryAccess = false;
                    } else {
                        MQPPLog.getLogger().warn(handshakeModule, "Handshake queue " + TraceProperties.HANDSHAKE_QUEUE_NAME_VALUE + " is put inhibited. Not able to write the handshake message." + " Ensure that the queue attribute 'Put Messages' is set to value 'Allowed'. ");
                    }
                    return false;
                }
                throw e;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static void setDiscoveryAccess(boolean discoveryAccess) {
        Reflection.discoveryAccess = discoveryAccess;
    }

    public static Class getClassMQException() {
        return class_MQException;
    }

    public static Field getReasonCodeField() {
        return reasonCodeField;
    }

    public static Field getCompletionCodeField() {
        return completionCodeField;
    }
}

