/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.format;

import com.wily.utilities.properties.Messages;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class ByteSizeFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    NumberFormat formatDelegate;
    static final long pivotMB = 1000000L;
    static final long pivotGB = 0x40000000L;
    static final long pivotKB = 9900L;

    public ByteSizeFormat(Locale locale) {
        this.formatDelegate = NumberFormat.getNumberInstance(locale);
        this.formatDelegate.setMaximumFractionDigits(1);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number >= 1.073741824E9) {
            this.formatDelegate.format(number /= 1.073741824E9, toAppendTo, pos);
            toAppendTo.append("GB");
            pos.setEndIndex(pos.getEndIndex() + 1);
        } else if (number >= 1000000.0) {
            this.formatDelegate.format(number /= 1048576.0, toAppendTo, pos);
            toAppendTo.append("MB");
            pos.setEndIndex(pos.getEndIndex() + 1);
        } else if (number >= 9900.0) {
            this.formatDelegate.format(number /= 1024.0, toAppendTo, pos);
            toAppendTo.append("K");
            pos.setEndIndex(pos.getEndIndex() + 1);
        } else {
            this.formatDelegate.format(number, toAppendTo, pos);
        }
        return toAppendTo;
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)number, toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        throw new UnsupportedOperationException(Messages.getString("ByteSizeFormat.UnsupportedOperationError_Log"));
    }

    @Override
    public int getMaximumFractionDigits() {
        return this.formatDelegate.getMaximumFractionDigits();
    }

    @Override
    public int getMaximumIntegerDigits() {
        return this.formatDelegate.getMaximumIntegerDigits();
    }

    @Override
    public int getMinimumFractionDigits() {
        return this.formatDelegate.getMinimumFractionDigits();
    }

    @Override
    public int getMinimumIntegerDigits() {
        return this.formatDelegate.getMinimumIntegerDigits();
    }

    @Override
    public void setGroupingUsed(boolean newValue) {
        this.formatDelegate.setGroupingUsed(newValue);
    }

    @Override
    public void setMaximumFractionDigits(int newValue) {
        this.formatDelegate.setMaximumFractionDigits(newValue);
    }

    @Override
    public void setMaximumIntegerDigits(int newValue) {
        this.formatDelegate.setMaximumIntegerDigits(newValue);
    }

    @Override
    public void setMinimumFractionDigits(int newValue) {
        this.formatDelegate.setMinimumFractionDigits(newValue);
    }

    @Override
    public void setMinimumIntegerDigits(int newValue) {
        this.formatDelegate.setMinimumIntegerDigits(newValue);
    }
}

