/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class WSClient65NameFormatter
implements ICacheableBlameKeyNameFormatter {
    private IAgent fAgent;

    public WSClient65NameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
            String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
            if (wsname == null || operation == null) {
                String[] wsnames = this.getWSNames(data);
                wsname = wsnames[0];
                operation = wsnames[1];
                WMUtils.getLogger().debug("WSClient65NameFormatter Client::WebService Namespace:" + wsname);
                WMUtils.getLogger().debug("WSClient65NameFormatter Client::WebService Operation:" + operation);
                data.put("com.wily.soaextension.webmethods.webservices.NamespaceKey", (Object)wsname);
                data.put("com.wily.soaextension.webmethods.webservices.OperationNameKey", (Object)operation);
            }
            if (name.indexOf("{namespace}", 0) >= 0) {
                wsname = WMUtils.formatToBeResourceSafe(wsname);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)wsname);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                operation = WMUtils.formatToBeResourceSafe(operation);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operation);
            }
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", e);
            WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
        }
        return name;
    }

    private String[] getWSNames(InvocationData data) {
        String wsname = null;
        String operation = null;
        try {
            Object idataObj = data.getInvocationParameterAsObject(0);
            Class idataClazz = WMUtils.getIDataClass();
            Class[] classArray = new Class[]{idataClazz, String.class};
            Object[] objArr = new Object[]{idataObj, "method"};
            Object methodObj = WMUtils.invokeGetOnValuesEmulator(objArr);
            Object[] objArr1 = new Object[]{methodObj, "namespaceName"};
            Object[] objArr2 = new Object[]{methodObj, "localName"};
            wsname = WMUtils.invokeGetStringOnValuesEmulator(objArr1);
            operation = WMUtils.invokeGetStringOnValuesEmulator(objArr2);
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
        }
        if (wsname == null || wsname.equals("")) {
            wsname = "UnknownService";
        }
        if (operation == null || operation.equals("")) {
            operation = "UnknownOperation";
        }
        return new String[]{wsname, operation};
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
        String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
        if (wsname == null || operation == null) {
            String[] wsnames = this.getWSNames(data);
            wsname = wsnames[0];
            operation = wsnames[1];
            data.put("com.wily.soaextension.webmethods.webservices.NamespaceKey", (Object)wsname);
            data.put("com.wily.soaextension.webmethods.webservices.OperationNameKey", (Object)operation);
        }
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, "WebServices", "Client", wsname, operation});
        }
        catch (Exception e) {
            imodulefeedbackchannel.error(e.getMessage());
            return null;
        }
    }
}

