/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.hc2.BackendTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class JMSBackendTracer
extends BackendTracer
implements IInvocationDataParameterCallback,
BackendProtocolsConstants {
    private static final Module ModuleName = new Module("JMSBackendTracer");
    protected final IModuleFeedbackChannel feedback;

    public JMSBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (JMSHelper.shouldRunProducerTracers(data, this.feedback)) {
            data.setParameterCallback((IInvocationDataParameterCallback)this);
            super.ITracer_startTrace(tracerIndex, data);
        } else {
            JMSHelper.debug(ModuleName, "failed to run JMSBackendTracer.ITracer_startTrace possibly because the destination was not found in the Map");
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (JMSHelper.shouldRunProducerTracers(data, this.feedback)) {
            super.ITracer_finishTrace(tracerIndex, data);
        } else {
            JMSHelper.debug(ModuleName, "failed to run JMSBackendTracer.ITracer_finishTrace possibly because the destination was not found in the Map");
        }
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map params) {
        if (JMSHelper.isCachedDestTypeAQueue(data)) {
            params.put("Queue Name", JMSHelper.getCachedDestinationName(data));
        } else if (JMSHelper.isCachedDestTypeATopic(data)) {
            params.put("Topic Name", JMSHelper.getCachedDestinationName(data));
        }
    }
}

