/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.correlation.http;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public class HttpURLConnectionCorrelationTracer
extends ASingleInstanceTracerFactory {
    private static Module sModule = new Module("HttpURLConnectionCorrelationTracer");
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    protected IModuleFeedbackChannel logger = null;
    private static final boolean developmentDebug = false;

    public HttpURLConnectionCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        block4: {
            try {
                HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
                if (connection.getRequestProperty("CorID") == null) {
                    connection.setRequestProperty("CorID", new CorrelationId().getOutgoingCorrelationIdStrippedForHeader());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable error) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.processException(data, error);
            }
        }
    }

    private void processException(InvocationData data, Throwable invocationException) {
        String className = "<NULL>";
        if (data.getInvocationObject() != null) {
            className = data.getInvocationObject().getClass().getName();
        }
        if (invocationException.getClass() == IllegalStateException.class || invocationException.getClass() == IllegalAccessError.class) {
            Boolean expected;
            if (this.logger.isDebugEnabled() && !(expected = Boolean.valueOf(this.processErrorScenario(data))).booleanValue()) {
                this.logger.error(sModule, "ITracer_startTrace unable to execute setRequestProperty on " + className + " (1) : " + invocationException.getMessage());
            }
        } else {
            this.logger.error(sModule, "ITracer_startTrace unable to execute setRequestProperty on " + className + " (2) : " + invocationException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processErrorScenario(InvocationData data) {
        try {
            Object dataObject = data.getInvocationObject();
            Class<?> actualClass = dataObject.getClass();
            Class<URLConnection> baseClass = URLConnection.class;
            if (!baseClass.isAssignableFrom(actualClass)) {
                this.logger.debug(sModule, "ITracer_startTrace " + actualClass.getName() + " is not a sub class of java.net.URLConnection");
                return false;
            }
            Object connected = ReflectionUtils.getFieldValueOfObject(baseClass, (Object)dataObject, (String)"connected");
            if (connected == null) {
                this.logger.debug(sModule, "ITracer_startTrace java.net.URLConnection.connected is null");
                return false;
            }
            if (connected.getClass() != Boolean.class) {
                this.logger.debug(sModule, "ITracer_startTrace java.net.URLConnection.connected is not a Boolean");
                return false;
            }
            Boolean isConnected = (Boolean)connected;
            try {
                Object connecting = ReflectionUtils.getFieldValueOfObject(actualClass, (Object)dataObject, (String)"connecting");
                if (connecting != null && connecting.getClass() == Boolean.class) {
                    Boolean isConnecting = (Boolean)connecting;
                    if (isConnected.booleanValue() || isConnecting.booleanValue()) {
                        return true;
                    }
                    this.logger.debug(sModule, "ITracer_startTrace java.net.URLConnection.connected = " + isConnected + ", " + actualClass.getName() + ".connecting = " + isConnecting);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            if (isConnected.booleanValue()) {
                return true;
            }
            this.logger.debug(sModule, "ITracer_startTrace java.net.URLConnection.connected is false");
            return false;
        }
        catch (Exception e) {
            this.logger.debug(sModule, "ITracer_startTrace processErrorScenario " + e);
            return false;
        }
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        new CorrelationId().decrementCorrelationCount();
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

