/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.frontend.jms;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.hc2.MethodThrewErrorReportingTracer;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;
import java.util.Map;

public class JMSReceiveFrontendErrorTracer
extends MethodThrewErrorReportingTracer
implements BackendProtocolsConstants {
    protected final IModuleFeedbackChannel feedback;

    public JMSReceiveFrontendErrorTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
    }

    protected void constructAndSendErrorSnapshot(InvocationData data, String errMsg) {
        this.constructAndSendErrorSnapshot((IStackElement)data, null, errMsg);
    }

    protected void createOwnErrorMetric(InvocationData data) {
        String resourceName = this.formatParameterizedResource(data);
        this.createAggregatedMetric(resourceName);
        super.createOwnErrorMetric(data);
    }

    private void createAggregatedMetric(String resourceName) {
        try {
            int index = resourceName.lastIndexOf("|");
            if (index != -1) {
                String aggregatedMetricname = resourceName.substring(0, index);
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(String.valueOf(aggregatedMetricname) + ":Errors Per Interval").ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
        }
        catch (ESEException eSEException) {
            Assertion.wilyFail((String)"Metric type conflict");
        }
    }

    protected void constructAndSendErrorSnapshot(IStackElement topElement, Throwable error, String errMsg) {
        InvocationData data = (InvocationData)topElement;
        HashMap<String, String> params = new HashMap<String, String>();
        data.IComponentParameterCallback_addParameters(params);
        if (error != null) {
            params.put("Exception", error.getMessage());
        }
        if (errMsg != null) {
            params.put("Error Message", errMsg);
        }
        String resourceName = this.formatParameterizedResource(data);
        TransactionComponentData tcdata = TransactionComponentData.createMilliSecTransactionComponentData((String)resourceName, (long)data.getWallClockFinishTime(), (long)1L, params);
        Map parameters = tcdata.getParameters();
        parameters.put("Trace Type", "ErrorSnapshot");
        parameters.put("Resource Name", resourceName);
        TransactionComponentData rootTcdData = this.createAggregatedErrorSnapshot(data, tcdata, resourceName);
        if (rootTcdData == null) {
            rootTcdData = tcdata;
        }
        this.getAgent().IAgent_queueEvent(rootTcdData);
    }

    private TransactionComponentData createAggregatedErrorSnapshot(InvocationData data, TransactionComponentData tcData, String destinationResourceName) {
        if (destinationResourceName != null && destinationResourceName.length() > 0) {
            String aggregatedResourceName = destinationResourceName.substring(0, destinationResourceName.lastIndexOf("|"));
            TransactionComponentData rootTcdData = TransactionComponentData.createMilliSecTransactionComponentData((String)aggregatedResourceName, (long)data.getWallClockFinishTime(), (long)1L, (TransactionComponentData[])new TransactionComponentData[]{tcData});
            Map parameters = rootTcdData.getParameters();
            parameters.putAll(tcData.getParameters());
            parameters.put("Resource Name", aggregatedResourceName);
            return rootTcdData;
        }
        return null;
    }

    public String getComponentNameOfLastBlamePoint(InvocationData data) {
        return this.formatParameterizedResource(data);
    }

    private boolean didFrontendTracerRun(InvocationData data) {
        Boolean frontendRun = (Boolean)data.get("frontend.jms.JMSReceiveFrontendTracer");
        return frontendRun != null && frontendRun != false;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.didFrontendTracerRun(data)) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (this.didFrontendTracerRun(data)) {
            super.ITracer_startTrace(tracerIndex, data);
        }
    }
}

