/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db.directives;

import com.wily.diagnos.cmp.directives.IDirectiveCollection;
import com.wily.diagnos.cmp.directives.parser.DGInvalidTracerNameException;
import com.wily.introscope.agent.db.directives.ConditionalDatabaseDirective;
import com.wily.introscope.agent.db.directives.DatabaseDirective;
import com.wily.introscope.agent.db.directives.DatabaseDirectiveInfo;
import com.wily.introscope.agent.db.directives.GroupDatabaseDirective;
import com.wily.introscope.agent.db.directives.IDatabaseDirective;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DatabaseDirectiveCollection
implements IDirectiveCollection {
    Collection fElements = new ArrayList();
    List fText;

    public DatabaseDirectiveCollection(IClassSchemaPolicy policy, IModuleFeedbackChannel moduleFeedbackChannel, Collection<DatabaseDirectiveInfo> dynamicDirectiveCollection) {
        this(policy, false, moduleFeedbackChannel, dynamicDirectiveCollection);
    }

    public DatabaseDirectiveCollection(IClassSchemaPolicy policy, boolean permanentOnly, IModuleFeedbackChannel moduleFeedbackChannel, Collection<DatabaseDirectiveInfo> dynamicDirectiveCollection) {
        if (dynamicDirectiveCollection != null) {
            for (DatabaseDirectiveInfo info : dynamicDirectiveCollection) {
                int directiveTypeInDatabase = info.getDirectiveType();
                if (permanentOnly && !info.isPermanent() || directiveTypeInDatabase == 2 || directiveTypeInDatabase == 6) continue;
                try {
                    IDatabaseDirective d = null;
                    if (info.getDirectiveType() == 0) {
                        d = new DatabaseDirective(policy, moduleFeedbackChannel, info);
                    } else if (info.getDirectiveType() == 3) {
                        info.setInterface(true);
                        d = new DatabaseDirective(policy, moduleFeedbackChannel, info);
                    } else if (info.getDirectiveType() == 5) {
                        info.setInterface(true);
                        d = new ConditionalDatabaseDirective(policy, moduleFeedbackChannel, info);
                    } else {
                        d = info.getDirectiveType() == 4 ? new ConditionalDatabaseDirective(policy, moduleFeedbackChannel, info) : new GroupDatabaseDirective(policy, moduleFeedbackChannel, info);
                    }
                    if (d == null) continue;
                    this.fElements.add(d);
                    if (!moduleFeedbackChannel.isTraceEnabled()) continue;
                    moduleFeedbackChannel.trace("loaded directive" + d.getText());
                }
                catch (DGInvalidTracerNameException e) {
                    e.printStackTrace();
                }
                catch (InvalidClassNameException e) {
                    e.printStackTrace();
                }
                catch (InvalidMethodDescriptorException e) {
                    e.printStackTrace();
                }
                catch (InvalidMethodNameException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Iterator getDirectives() {
        return this.fElements.iterator();
    }

    public String getName() {
        return "Dynamic Directives From Database";
    }

    public List getText() {
        ArrayList<String> result = new ArrayList<String>();
        for (IDatabaseDirective element : this.fElements) {
            result.add(element.getText());
        }
        return result;
    }

    public Map getTextLines() {
        HashMap result = new HashMap();
        for (IDatabaseDirective element : this.fElements) {
            String label = element.getLabel();
            ArrayList existingLines = (ArrayList)result.get(label);
            if (existingLines == null) {
                existingLines = new ArrayList();
                result.put(label, existingLines);
            }
            existingLines.addAll(element.getTextLines());
        }
        return result;
    }
}

